/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure.svg;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class SVGUtils {
    private SVGUtils() {
    }

    public static Image toSWT(Device device, BufferedImage awtImage) {
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData swtImageData = new ImageData(awtImage.getWidth(), awtImage.getHeight(), 24, palette);
        int scansize = (awtImage.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = awtImage.getAlphaRaster();
        byte[] alphaBytes = new byte[awtImage.getWidth()];
        int y = 0;
        while (y < awtImage.getHeight()) {
            int[] buff = awtImage.getRGB(0, y, awtImage.getWidth(), 1, null, 0, scansize);
            swtImageData.setPixels(0, y, awtImage.getWidth(), buff, 0);
            if (alphaRaster != null) {
                int[] alpha = alphaRaster.getPixels(0, y, awtImage.getWidth(), 1, (int[])null);
                int i = 0;
                while (i < awtImage.getWidth()) {
                    alphaBytes[i] = (byte)alpha[i];
                    ++i;
                }
                swtImageData.setAlphas(0, y, awtImage.getWidth(), alphaBytes, 0);
            }
            ++y;
        }
        return new Image(device, swtImageData);
    }

    public static Object getAntialiasHint(Graphics graphics) {
        int aa = -1;
        try {
            aa = graphics.getAntialias();
        }
        catch (Exception exception) {}
        Object aaHint = aa == 1 ? RenderingHints.VALUE_ANTIALIAS_ON : (aa == 0 ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        return aaHint;
    }

    public static Object getTextAntialiasHint(Graphics graphics) {
        int aa = -1;
        try {
            aa = graphics.getTextAntialias();
        }
        catch (Exception exception) {}
        Object aaHint = aa == 1 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : (aa == 0 ? RenderingHints.VALUE_TEXT_ANTIALIAS_OFF : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        return aaHint;
    }
}

