/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes();
        Ref ref1 = this.getRef((RepositoryTreeNode)nodes.get(0));
        Ref ref2 = this.getRef((RepositoryTreeNode)nodes.get(1));
        if (ref1 != null && ref2 != null) {
            Repository repo = ((RepositoryTreeNode)nodes.get(0)).getRepository();
            IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            try {
                RevCommit a = repo.parseCommit((AnyObjectId)ref1.getObjectId());
                RevCommit b = repo.parseCommit((AnyObjectId)ref2.getObjectId());
                if (a.getCommitTime() <= b.getCommitTime()) {
                    this.compare(workbenchPage, repo, b.getName(), a.getName());
                } else {
                    this.compare(workbenchPage, repo, a.getName(), b.getName());
                }
            }
            catch (IOException e) {
                throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected void compare(IWorkbenchPage workbenchPage, Repository repo, String compareCommit, String baseCommit) throws ExecutionException {
        GitCompareEditorInput compareInput = new GitCompareEditorInput(compareCommit, baseCommit, repo);
        CompareUtils.openInCompare(workbenchPage, compareInput);
    }

    private Ref getRef(RepositoryTreeNode node) {
        if (node instanceof TagNode) {
            return (Ref)((TagNode)node).getObject();
        }
        if (node instanceof RefNode || node instanceof AdditionalRefNode) {
            return (Ref)node.getObject();
        }
        return null;
    }

    public boolean isEnabled() {
        List nodes = this.getSelectedNodes();
        if (nodes.size() == 2) {
            return nodes.stream().map(RepositoryTreeNode::getRepository).distinct().count() == 1L;
        }
        return false;
    }
}

