/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.view.factories;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.view.factories.ViewFactory;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractViewFactory
implements ViewFactory {
    private PreferencesHint preferencesHint;

    public abstract View createView(IAdaptable var1, View var2, String var3, int var4, boolean var5, PreferencesHint var6);

    protected List createStyles(View view) {
        return new ArrayList();
    }

    protected boolean requiresElement(IAdaptable semanticAdapter, View view) {
        if (semanticAdapter != null) {
            return this.requiresElement((EObject)semanticAdapter.getAdapter(EObject.class), view);
        }
        return true;
    }

    protected boolean requiresElement(EObject semanticElement, View view) {
        return semanticElement != view.getElement();
    }

    protected void initializeFromPreferences(View view) {
        FontStyle fontStyle;
        IPreferenceStore store = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        if (store == null) {
            return;
        }
        LineStyle lineStyle = (LineStyle)view.getStyle(NotationPackage.Literals.LINE_STYLE);
        if (lineStyle != null) {
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"Appearance.lineColor");
            lineStyle.setLineColor(FigureUtilities.RGBToInteger((RGB)lineRGB).intValue());
        }
        if ((fontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE)) != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)"Appearance.defaultFont");
            fontStyle.setFontName(fontData.getName());
            fontStyle.setFontHeight(fontData.getHeight());
            fontStyle.setBold((fontData.getStyle() & 1) != 0);
            fontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"Appearance.fontColor");
            fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    protected static ViewService getViewService() {
        return ViewService.getInstance();
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    protected void setPreferencesHint(PreferencesHint preferencesHint) {
        this.preferencesHint = preferencesHint;
    }

    protected TransactionalEditingDomain getEditingDomain(EObject semanticElement, View containerView) {
        TransactionalEditingDomain result = null;
        if (semanticElement != null) {
            result = TransactionUtil.getEditingDomain((EObject)semanticElement);
        }
        if (result == null) {
            result = TransactionUtil.getEditingDomain((EObject)containerView);
        }
        return result;
    }
}

