/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task;

import java.util.Iterator;
import java.util.List;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class TaskExecutor {
    private TaskExecutor() {
    }

    public static boolean canExecute(List<ICommandTask> tasks) {
        boolean result = true;
        Iterator<ICommandTask> it = tasks.iterator();
        while (it.hasNext() && result) {
            ICommandTask task = it.next();
            boolean bl = result = result && TaskExecutor.canExecute(task);
        }
        return result;
    }

    public static void execute(List<ICommandTask> tasks) {
        for (ICommandTask task : tasks) {
            try {
                task.execute();
            }
            catch (MetaClassNotFoundException e) {
                SiriusPlugin.getDefault().error(Messages.TaskExecutor_errorModifyingModelMsg, e);
            }
            catch (FeatureNotFoundException e) {
                SiriusPlugin.getDefault().error(Messages.TaskExecutor_errorModifyingModelMsg, e);
            }
            if (task.executeMyselfChildrenTasks()) continue;
            TaskExecutor.execute(task.getChildrenTasks());
        }
    }

    private static boolean canExecute(ICommandTask task) {
        if (!task.canExecute()) {
            return false;
        }
        boolean result = true;
        Iterator<ICommandTask> it = task.getChildrenTasks().iterator();
        while (it.hasNext() && result) {
            ICommandTask childTask = it.next();
            boolean bl = result = result && TaskExecutor.canExecute(childTask);
        }
        return result;
    }
}

