/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineTypeDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class EngineTypeWizardPage
extends WizardPage {
    private TableViewer tableViewer;
    private EngineTypeDescriptor[] engineTypes;
    private EngineTypeDescriptor selection;

    public EngineTypeWizardPage(EngineTypeDescriptor[] engineTypes) {
        super("engineType");
        this.setTitle(Messages.EngineTypeWizardPage_title);
        this.setDescription(Messages.EngineTypeWizardPage_desc);
        this.engineTypes = engineTypes;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.searchScope");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.EngineTypeWizardPage_label);
        label.setFont(font);
        this.tableViewer = new TableViewer(container);
        this.tableViewer.setContentProvider((IContentProvider)new EngineContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EngineLabelProvider());
        this.tableViewer.addSelectionChangedListener(event -> {
            this.setPageComplete(!event.getSelection().isEmpty());
            this.selection = (EngineTypeDescriptor)event.getStructuredSelection().getFirstElement();
        });
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setInput((Object)this.engineTypes);
        this.tableViewer.getTable().setFont(font);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    public EngineTypeDescriptor getSelectedEngineType() {
        return this.selection;
    }

    class EngineContentProvider
    implements IStructuredContentProvider {
        EngineContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return EngineTypeWizardPage.this.engineTypes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class EngineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EngineLabelProvider() {
        }

        public String getText(Object obj) {
            EngineTypeDescriptor desc = (EngineTypeDescriptor)obj;
            return desc.getLabel();
        }

        public Image getImage(Object obj) {
            EngineTypeDescriptor desc = (EngineTypeDescriptor)obj;
            return desc.getIconImage();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }
    }
}

