/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.acquire;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.acquire.JmapVmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public class LocalJavaProcessesUtils {
    static List<JmapVmInfo> getLocalVMsUsingJPS(File jdkHome, IProgressListener listener) throws SnapshotException {
        String[] stringArray;
        String jps;
        String[] modules = new String[]{"jcmd", "jcmd.exe", "jps", "jps.exe"};
        String cmd = jps = "jps";
        if (jdkHome != null && jdkHome.exists()) {
            String[] stringArray2 = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                String mod = stringArray2[n2];
                File mod1 = new File(jdkHome.getAbsoluteFile(), "bin");
                if ((mod1 = new File(mod1, mod)).canExecute()) {
                    jps = mod1.getAbsolutePath();
                    cmd = mod;
                    break;
                }
                ++n2;
            }
        }
        String encoding = System.getProperty("file.encoding", "UTF-8");
        if (cmd.startsWith("jcmd")) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = jps;
            stringArray3[1] = "-l";
            stringArray = stringArray3;
            stringArray3[2] = "-J-Dfile.encoding=" + encoding;
        } else {
            String[] stringArray4 = new String[4];
            stringArray4[0] = jps;
            stringArray4[1] = "-m";
            stringArray4[2] = "-l";
            stringArray = stringArray4;
            stringArray4[3] = "-J-Dfile.encoding=" + encoding;
        }
        String[] cmds = stringArray;
        listener.subTask(jps);
        StreamCollector error = null;
        StreamCollector output = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmds);
            error = new StreamCollector(p.getErrorStream(), encoding);
            error.start();
            output = new StreamCollector(p.getInputStream(), encoding, listener);
            output.start();
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                return null;
            }
            ArrayList<JmapVmInfo> vms = new ArrayList<JmapVmInfo>();
            int jpsProcesses = 0;
            String jpssig1 = cmd.startsWith("jcmd") ? "sun.tools.jcmd.JCmd -l" : "Jps -m -l";
            String jpssig2 = cmd.startsWith("jcmd") ? "openj9.tools.attach.diagnostics.tools.Jcmd -l" : "Jps -m -l";
            StringTokenizer tok = new StringTokenizer(output.buf.toString(), "\r\n");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                JmapVmInfo info = LocalJavaProcessesUtils.parseJPSLine(token);
                if (info == null) continue;
                vms.add(info);
                if (!info.getDescription().contains(jpssig1) && !info.getDescription().contains(jpssig2)) continue;
                ++jpsProcesses;
            }
            if (jpsProcesses == 1) {
                for (JmapVmInfo info : vms) {
                    if (!info.getDescription().contains(jpssig1) && !info.getDescription().contains(jpssig2)) continue;
                    info.setHeapDumpEnabled(false);
                    break;
                }
            }
            ArrayList<JmapVmInfo> arrayList = vms;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new SnapshotException(MessageUtil.format((String)Messages.LocalJavaProcessesUtils_ErrorGettingProcessListJPS, (Object[])new Object[]{jps}), (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new SnapshotException(MessageUtil.format((String)Messages.LocalJavaProcessesUtils_ErrorGettingProcessListJPS, (Object[])new Object[]{jps}), (Throwable)ie);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private static JmapVmInfo parseJPSLine(String line) {
        int firstSpaceIdx = line.indexOf(32);
        if (firstSpaceIdx == -1) {
            return null;
        }
        int pid = Integer.parseInt(line.substring(0, firstSpaceIdx));
        String description = line.substring(firstSpaceIdx + 1);
        return new JmapVmInfo(pid, description, true, null, null);
    }

    static class StreamCollector
    extends Thread {
        InputStream is;
        StringBuilder buf;
        String encoding;
        IProgressListener listener;

        StreamCollector(InputStream is) {
            this(is, System.getProperty("file.encoding", "UTF-8"), null);
        }

        StreamCollector(InputStream is, String encoding) {
            this(is, encoding, null);
        }

        StreamCollector(InputStream is, String encoding, IProgressListener listener) {
            this.is = is;
            this.buf = new StringBuilder();
            this.encoding = encoding;
            this.listener = listener;
        }

        @Override
        public void run() {
            block13: {
                InputStreamReader isr = null;
                try {
                    try {
                        isr = new InputStreamReader(this.is, this.encoding);
                        BufferedReader br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            this.buf.append(line).append("\r\n");
                            if (this.listener == null) continue;
                            this.listener.worked(1);
                        }
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.LocalJavaProcessesUtils_ErrorGettingProcesses, ioe);
                        if (isr == null) break block13;
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

