/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveReader
implements IDocArchiveReader {
    protected IArchiveFile archive;
    protected boolean shareArchive;

    public ArchiveReader(IArchiveFile archive) throws IOException {
        this.shareArchive = true;
        this.archive = archive;
    }

    public ArchiveReader(String archiveName) throws IOException {
        if (archiveName == null || archiveName.length() == 0) {
            throw new IllegalArgumentException(archiveName);
        }
        File fd = new File(archiveName);
        if (!fd.isFile() || !fd.exists()) {
            throw new FileNotFoundException(CoreMessages.getFormattedString("error.InvalidArchiveName", archiveName));
        }
        archiveName = fd.getCanonicalPath();
        this.shareArchive = false;
        this.archive = new ArchiveFile(archiveName, "r");
    }

    @Override
    public void close() throws IOException {
        if (!this.shareArchive) {
            this.archive.close();
        }
    }

    public IArchiveFile getArchive() {
        return this.archive;
    }

    @Override
    public boolean exists(String relativePath) {
        if (!relativePath.startsWith("/")) {
            relativePath = "/" + relativePath;
        }
        return this.archive.exists(relativePath);
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    public RAInputStream getStream(String relativePath) throws IOException {
        if (!relativePath.startsWith("/")) {
            relativePath = "/" + relativePath;
        }
        ArchiveEntry entry = this.archive.openEntry(relativePath);
        return new ArchiveEntryInputStream(entry);
    }

    @Override
    public RAInputStream getInputStream(String relativePath) throws IOException {
        return this.getStream(relativePath);
    }

    @Override
    public List<String> listAllStreams() throws IOException {
        ArrayList<String> list = new ArrayList<String>(this.archive.listEntries("/"));
        return list;
    }

    @Override
    public List<String> listStreams(String namePattern) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        List<String> archiveEntries = this.archive.listEntries(namePattern);
        for (String name : archiveEntries) {
            String diffString;
            if (!name.startsWith(namePattern) || name.equalsIgnoreCase(namePattern) || (diffString = ArchiveUtil.getRelativePath(namePattern, name)).lastIndexOf("/") != 0) continue;
            list.add(name);
        }
        return list;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public Object lock(String relativePath) throws IOException {
        if (!relativePath.startsWith("/")) {
            relativePath = "/" + relativePath;
        }
        return this.archive.lockEntry(relativePath);
    }

    @Override
    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

