/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.spi;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.eclipse.microprofile.telemetry.tracing.tck.spi.TestResourceProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceSpiTest
extends Arquillian {
    public static final String TEST_VALUE1 = "test1";
    public static final String TEST_VALUE2 = "test2";
    @Inject
    private Tracer tracer;
    @Inject
    private InMemorySpanExporter exporter;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, TestResourceProvider.class})).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsServiceProvider(ResourceProvider.class, new Class[]{TestResourceProvider.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=in-memory\n" + TestResourceProvider.TEST_KEY1.getKey() + "=test1\notel.test.key2=test2"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testResource() {
        Span span = this.tracer.spanBuilder("span").startSpan();
        span.end();
        List<SpanData> spanItems = this.exporter.getFinishedSpanItems(1);
        Assert.assertEquals((int)spanItems.size(), (int)1);
        SpanData spanData = spanItems.get(0);
        Assert.assertEquals((String)((String)spanData.getResource().getAttribute(TestResourceProvider.TEST_KEY1)), (String)TEST_VALUE1);
        Assert.assertEquals((String)((String)spanData.getResource().getAttribute(TestResourceProvider.TEST_KEY2)), (String)TEST_VALUE2);
    }
}

