/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.editor.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlCodeFormatterPreferences {
    private int linesBetween;
    private int lineMaxLength;
    private int tabSpaces;
    private int spacesInsideBraces;
    private int spacesOutsideBraces;
    private int spacesBeforeArrows;
    private int spacesAfterArrows;
    private int spacesBeforeSemi;
    private int spacesAfterSemi;
    private int spacesBeforeComa;
    private int spacesAfterComa;
    private int spacesBeforeColon;
    private int spacesAfterColon;
    private int spacesBeforePoint;
    private int spacesAfterPoint;
    private int spacesBeforeOperator;
    private int spacesAfterOperator;
    private int spacesBeforeEqual;
    private int spacesAfterEqual;
    private int spacesBeforePipe;
    private int spacesAfterPipe;
    private int spacesBeforeExclamation;
    private int spacesAfterExclamation;
    private int spacesBeforeRuleBrace;
    private int spacesBeforeEndingSemi;
    private int linesAfterModule;
    private int linesAfterCreateFrom;
    private int linesAfterSpecialTags;
    private boolean cutAfterPoint;
    private int spacesAfterComment;
    private int spacesOutsideCollectionBrace;
    private int spacesInsideCollectionBrace;

    public AtlCodeFormatterPreferences() {
        this.setLinesBetween(1);
        this.setLineMaxLength(90);
        this.setTabSpaces(4);
        this.setSpacesOutsideBraces(0);
        this.setSpacesInsideBraces(0);
        this.setSpacesBeforeArrows(1);
        this.setSpacesAfterArrows(1);
        this.setSpacesBeforeSemi(0);
        this.setSpacesAfterSemi(1);
        this.setSpacesBeforeComa(0);
        this.setSpacesAfterComa(1);
        this.setSpacesBeforeColon(0);
        this.setSpacesAfterColon(1);
        this.setSpacesBeforePoint(0);
        this.setSpacesAfterPoint(0);
        this.setSpacesBeforeOperator(1);
        this.setSpacesAfterOperator(1);
        this.setLinesAfterModule(0);
        this.setLinesAfterCreateFrom(1);
        this.setLinesAfterSpecialTags(2);
        this.setCutAfterPoint(true);
        this.setSpacesBeforeEqual(1);
        this.setSpacesAfterEqual(1);
        this.setSpacesBeforePipe(1);
        this.setSpacesAfterPipe(1);
        this.setSpacesBeforeExclamation(0);
        this.setSpacesAfterExclamation(0);
        this.setSpacesBeforeRuleBrace(1);
        this.setSpacesBeforeEndingSemi(0);
        this.setSpacesAfterComment(1);
        this.setSpacesOutsideCollectionBrace(0);
        this.setSpacesInsideCollectionBrace(0);
    }

    public AtlCodeFormatterPreferences(IPreferenceStore preferenceStore) {
        this.retrievePreferences(preferenceStore);
    }

    public AtlCodeFormatterPreferences(Map<String, String> options) {
        this.retrievePreferences(options);
    }

    public void retrievePreferences(IPreferenceStore preferenceStore) {
        this.linesBetween = preferenceStore.getInt("Atl.CodeFormatter.LinesBetween");
        this.lineMaxLength = preferenceStore.getInt("Atl.CodeFormatter.LineMaxLength");
        this.tabSpaces = preferenceStore.getInt("tabWidth");
        this.spacesInsideBraces = preferenceStore.getInt("Atl.CodeFormatter.SpacesInsideBraces");
        this.spacesOutsideBraces = preferenceStore.getInt("Atl.CodeFormatter.SpacesOutsideBraces");
        this.spacesBeforeArrows = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeArrows");
        this.spacesAfterArrows = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterArrows");
        this.spacesBeforeSemi = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeSemi");
        this.spacesAfterSemi = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterSemi");
        this.spacesBeforeComa = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeComa");
        this.spacesAfterComa = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterComa");
        this.spacesBeforeColon = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeColon");
        this.spacesAfterColon = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterColon");
        this.spacesBeforePoint = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforePoint");
        this.spacesAfterPoint = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterPoint");
        this.spacesBeforeOperator = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeOperator");
        this.spacesAfterOperator = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterOperator");
        this.spacesBeforeEqual = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeEqual");
        this.spacesAfterEqual = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterEqual");
        this.spacesBeforePipe = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforePipe");
        this.spacesAfterPipe = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterPipe");
        this.spacesBeforeExclamation = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeExclamation");
        this.spacesAfterExclamation = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterExclamation");
        this.spacesBeforeRuleBrace = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeRuleBrace");
        this.spacesBeforeEndingSemi = preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeEndingSemi");
        this.cutAfterPoint = preferenceStore.getBoolean("Atl.CodeFormatter.CutAfterPoint");
        this.spacesAfterComment = preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterComment");
        this.spacesOutsideCollectionBrace = preferenceStore.getInt("Atl.CodeFormatter.SpacesOutsideCollectionBrace");
        this.spacesInsideCollectionBrace = preferenceStore.getInt("Atl.CodeFormatter.SpacesInsideCollectionBrace");
        this.linesAfterModule = preferenceStore.getInt("Atl.CodeFormatter.LinesAfterModule");
        this.linesAfterCreateFrom = preferenceStore.getInt("Atl.CodeFormatter.LinesAfterCreateFrom");
        this.linesAfterSpecialTags = preferenceStore.getInt("Atl.CodeFormatter.LinesAfterSpecialTags");
    }

    public void retrievePreferences(Map<String, String> options) {
        String sLinesBetween = options.get("Atl.CodeFormatter.LinesBetween");
        if (sLinesBetween != null) {
            try {
                this.linesBetween = Integer.parseInt(sLinesBetween);
            }
            catch (NumberFormatException numberFormatException) {
                this.setLinesBetween(1);
            }
        } else {
            this.setLinesBetween(1);
        }
        String sLineMaxLength = options.get("Atl.CodeFormatter.LineMaxLength");
        if (sLineMaxLength != null) {
            try {
                this.lineMaxLength = Integer.parseInt(sLineMaxLength);
            }
            catch (NumberFormatException numberFormatException) {
                this.setLineMaxLength(90);
            }
        } else {
            this.setLineMaxLength(90);
        }
        String sTabSpaces = options.get("tabWidth");
        if (sTabSpaces != null) {
            try {
                this.tabSpaces = Integer.parseInt(sTabSpaces);
            }
            catch (NumberFormatException numberFormatException) {
                this.setTabSpaces(4);
            }
        } else {
            this.setTabSpaces(4);
        }
        String sSpacesInsideBraces = options.get("Atl.CodeFormatter.SpacesInsideBraces");
        if (sSpacesInsideBraces != null) {
            try {
                this.spacesInsideBraces = Integer.parseInt(sSpacesInsideBraces);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesInsideBraces(0);
            }
        } else {
            this.setSpacesInsideBraces(0);
        }
        String sSpacesOutsideBraces = options.get("Atl.CodeFormatter.SpacesOutsideBraces");
        if (sSpacesOutsideBraces != null) {
            try {
                this.spacesOutsideBraces = Integer.parseInt(sSpacesOutsideBraces);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesOutsideBraces(0);
            }
        } else {
            this.setSpacesOutsideBraces(0);
        }
        String sSpacesBeforeArrows = options.get("Atl.CodeFormatter.SpacesBeforeArrows");
        if (sSpacesBeforeArrows != null) {
            try {
                this.spacesBeforeArrows = Integer.parseInt(sSpacesBeforeArrows);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeArrows(1);
            }
        } else {
            this.setSpacesBeforeArrows(1);
        }
        String sSpacesAfterArrows = options.get("Atl.CodeFormatter.SpacesAfterArrows");
        if (sSpacesAfterArrows != null) {
            try {
                this.spacesAfterArrows = Integer.parseInt(sSpacesAfterArrows);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterArrows(1);
            }
        } else {
            this.setSpacesAfterArrows(1);
        }
        String sSpacesBeforeSemi = options.get("Atl.CodeFormatter.SpacesBeforeSemi");
        if (sSpacesBeforeSemi != null) {
            try {
                this.spacesBeforeSemi = Integer.parseInt(sSpacesBeforeSemi);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeSemi(0);
            }
        } else {
            this.setSpacesBeforeSemi(0);
        }
        String sSpacesAfterSemi = options.get("Atl.CodeFormatter.SpacesAfterSemi");
        if (sSpacesAfterSemi != null) {
            try {
                this.spacesAfterSemi = Integer.parseInt(sSpacesAfterSemi);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterSemi(1);
            }
        } else {
            this.setSpacesAfterSemi(1);
        }
        String sSpacesBeforeComa = options.get("Atl.CodeFormatter.SpacesBeforeComa");
        if (sSpacesBeforeComa != null) {
            try {
                this.spacesBeforeComa = Integer.parseInt(sSpacesBeforeComa);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeComa(0);
            }
        } else {
            this.setSpacesBeforeComa(0);
        }
        String sSpacesAfterComa = options.get("Atl.CodeFormatter.SpacesAfterComa");
        if (sSpacesAfterComa != null) {
            try {
                this.spacesAfterComa = Integer.parseInt(sSpacesAfterComa);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterComa(1);
            }
        } else {
            this.setSpacesAfterComa(1);
        }
        String sSpacesBeforeColon = options.get("Atl.CodeFormatter.SpacesBeforeColon");
        if (sSpacesBeforeColon != null) {
            try {
                this.spacesBeforeColon = Integer.parseInt(sSpacesBeforeColon);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeColon(0);
            }
        } else {
            this.setSpacesBeforeColon(0);
        }
        String sSpacesAfterColon = options.get("Atl.CodeFormatter.SpacesAfterColon");
        if (sSpacesAfterColon != null) {
            try {
                this.spacesAfterColon = Integer.parseInt(sSpacesAfterColon);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterColon(1);
            }
        } else {
            this.setSpacesAfterColon(1);
        }
        String sSpacesBeforePoint = options.get("Atl.CodeFormatter.SpacesBeforePoint");
        if (sSpacesBeforePoint != null) {
            try {
                this.spacesBeforePoint = Integer.parseInt(sSpacesBeforePoint);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforePoint(0);
            }
        } else {
            this.setSpacesBeforePoint(0);
        }
        String sSpacesAfterPoint = options.get("Atl.CodeFormatter.SpacesAfterPoint");
        if (sSpacesAfterPoint != null) {
            try {
                this.spacesAfterPoint = Integer.parseInt(sSpacesAfterPoint);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterPoint(0);
            }
        } else {
            this.setSpacesAfterPoint(0);
        }
        String sSpacesBeforeOperator = options.get("Atl.CodeFormatter.SpacesBeforeOperator");
        if (sSpacesBeforeOperator != null) {
            try {
                this.spacesBeforeOperator = Integer.parseInt(sSpacesBeforeOperator);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeOperator(1);
            }
        } else {
            this.setSpacesBeforeOperator(1);
        }
        String sSpacesAfterOperator = options.get("Atl.CodeFormatter.SpacesAfterOperator");
        if (sSpacesAfterOperator != null) {
            try {
                this.spacesAfterOperator = Integer.parseInt(sSpacesAfterOperator);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterOperator(1);
            }
        } else {
            this.setSpacesAfterOperator(1);
        }
        String sSpacesBeforeEqual = options.get("Atl.CodeFormatter.SpacesBeforeEqual");
        if (sSpacesBeforeEqual != null) {
            try {
                this.spacesBeforeEqual = Integer.parseInt(sSpacesBeforeEqual);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeEqual(1);
            }
        } else {
            this.setSpacesBeforeEqual(1);
        }
        String sSpacesAfterEqual = options.get("Atl.CodeFormatter.SpacesAfterEqual");
        if (sSpacesAfterEqual != null) {
            try {
                this.spacesAfterEqual = Integer.parseInt(sSpacesAfterEqual);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterEqual(1);
            }
        } else {
            this.setSpacesAfterEqual(1);
        }
        String sSpacesBeforePipe = options.get("Atl.CodeFormatter.SpacesBeforePipe");
        if (sSpacesBeforePipe != null) {
            try {
                this.spacesBeforePipe = Integer.parseInt(sSpacesBeforePipe);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforePipe(1);
            }
        } else {
            this.setSpacesBeforePipe(1);
        }
        String sSpacesAfterPipe = options.get("Atl.CodeFormatter.SpacesAfterPipe");
        if (sSpacesAfterPipe != null) {
            try {
                this.spacesAfterPipe = Integer.parseInt(sSpacesAfterPipe);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterPipe(1);
            }
        } else {
            this.setSpacesAfterPipe(1);
        }
        String sSpacesBeforeExclamation = options.get("Atl.CodeFormatter.SpacesBeforeExclamation");
        if (sSpacesBeforeExclamation != null) {
            try {
                this.spacesBeforeExclamation = Integer.parseInt(sSpacesBeforeExclamation);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeExclamation(0);
            }
        } else {
            this.setSpacesBeforeExclamation(0);
        }
        String sSpacesAfterExclamation = options.get("Atl.CodeFormatter.SpacesAfterExclamation");
        if (sSpacesAfterExclamation != null) {
            try {
                this.spacesAfterExclamation = Integer.parseInt(sSpacesAfterExclamation);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterExclamation(0);
            }
        } else {
            this.setSpacesAfterExclamation(0);
        }
        String sSpacesBeforeRuleBrace = options.get("Atl.CodeFormatter.SpacesBeforeRuleBrace");
        if (sSpacesBeforeRuleBrace != null) {
            try {
                this.spacesBeforeRuleBrace = Integer.parseInt(sSpacesBeforeRuleBrace);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeRuleBrace(1);
            }
        } else {
            this.setSpacesBeforeRuleBrace(1);
        }
        String sSpacesBeforeEndingSemi = options.get("Atl.CodeFormatter.SpacesBeforeEndingSemi");
        if (sSpacesBeforeEndingSemi != null) {
            try {
                this.spacesBeforeEndingSemi = Integer.parseInt(sSpacesBeforeEndingSemi);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesBeforeEndingSemi(0);
            }
        } else {
            this.setSpacesBeforeEndingSemi(0);
        }
        String sCutAfterPoint = options.get("Atl.CodeFormatter.CutAfterPoint");
        if (sCutAfterPoint != null) {
            try {
                this.cutAfterPoint = Boolean.parseBoolean(sCutAfterPoint);
            }
            catch (NumberFormatException numberFormatException) {
                this.setCutAfterPoint(true);
            }
        } else {
            this.setCutAfterPoint(true);
        }
        String sSpacesAfterComment = options.get("Atl.CodeFormatter.SpacesAfterComment");
        if (sSpacesAfterComment != null) {
            try {
                this.spacesAfterComment = Integer.parseInt(sSpacesAfterComment);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesAfterComment(1);
            }
        } else {
            this.setSpacesAfterComment(1);
        }
        String sSpacesOutsideCollectionBrace = options.get("Atl.CodeFormatter.SpacesOutsideCollectionBrace");
        if (sSpacesOutsideCollectionBrace != null) {
            try {
                this.spacesOutsideCollectionBrace = Integer.parseInt(sSpacesOutsideCollectionBrace);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesOutsideCollectionBrace(0);
            }
        } else {
            this.setSpacesOutsideCollectionBrace(0);
        }
        String sSpacesInsideCollectionBrace = options.get("Atl.CodeFormatter.SpacesInsideCollectionBrace");
        if (sSpacesInsideCollectionBrace != null) {
            try {
                this.spacesInsideCollectionBrace = Integer.parseInt(sSpacesInsideCollectionBrace);
            }
            catch (NumberFormatException numberFormatException) {
                this.setSpacesInsideCollectionBrace(0);
            }
        } else {
            this.setSpacesInsideCollectionBrace(0);
        }
        String sLinesAfterModule = options.get("Atl.CodeFormatter.LinesAfterModule");
        if (sLinesAfterModule != null) {
            try {
                this.linesAfterModule = Integer.parseInt(sLinesAfterModule);
            }
            catch (NumberFormatException numberFormatException) {
                this.setLinesAfterModule(0);
            }
        } else {
            this.setLinesAfterModule(0);
        }
        String sLinesAfterCreateFrom = options.get("Atl.CodeFormatter.LinesAfterCreateFrom");
        if (sLinesAfterCreateFrom != null) {
            try {
                this.linesAfterCreateFrom = Integer.parseInt(sLinesAfterCreateFrom);
            }
            catch (NumberFormatException numberFormatException) {
                this.setLinesAfterCreateFrom(1);
            }
        } else {
            this.setLinesAfterCreateFrom(1);
        }
        String sLinesAfterSpecialTags = options.get("Atl.CodeFormatter.LinesAfterSpecialTags");
        if (sLinesAfterSpecialTags != null) {
            try {
                this.linesAfterSpecialTags = Integer.parseInt(sLinesAfterSpecialTags);
            }
            catch (NumberFormatException numberFormatException) {
                this.setLinesAfterSpecialTags(2);
            }
        } else {
            this.setLinesAfterSpecialTags(2);
        }
    }

    public static Map<String, String> getOptions(IPreferenceStore preferenceStore) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("Atl.CodeFormatter.LinesBetween", "" + preferenceStore.getInt("Atl.CodeFormatter.LinesBetween"));
        options.put("Atl.CodeFormatter.LineMaxLength", "" + preferenceStore.getInt("Atl.CodeFormatter.LineMaxLength"));
        options.put("tabWidth", "" + preferenceStore.getInt("tabWidth"));
        options.put("Atl.CodeFormatter.SpacesInsideBraces", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesInsideBraces"));
        options.put("Atl.CodeFormatter.SpacesOutsideBraces", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesOutsideBraces"));
        options.put("Atl.CodeFormatter.SpacesBeforeArrows", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeArrows"));
        options.put("Atl.CodeFormatter.SpacesAfterArrows", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterArrows"));
        options.put("Atl.CodeFormatter.SpacesBeforeSemi", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeSemi"));
        options.put("Atl.CodeFormatter.SpacesAfterSemi", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterSemi"));
        options.put("Atl.CodeFormatter.SpacesBeforeComa", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeComa"));
        options.put("Atl.CodeFormatter.SpacesAfterComa", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterComa"));
        options.put("Atl.CodeFormatter.SpacesBeforeColon", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeColon"));
        options.put("Atl.CodeFormatter.SpacesAfterColon", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterColon"));
        options.put("Atl.CodeFormatter.SpacesBeforePoint", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforePoint"));
        options.put("Atl.CodeFormatter.SpacesAfterPoint", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterPoint"));
        options.put("Atl.CodeFormatter.SpacesBeforeOperator", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeOperator"));
        options.put("Atl.CodeFormatter.SpacesAfterOperator", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterOperator"));
        options.put("Atl.CodeFormatter.SpacesBeforeEqual", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeEqual"));
        options.put("Atl.CodeFormatter.SpacesAfterEqual", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterEqual"));
        options.put("Atl.CodeFormatter.SpacesBeforePipe", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforePipe"));
        options.put("Atl.CodeFormatter.SpacesAfterPipe", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterPipe"));
        options.put("Atl.CodeFormatter.SpacesBeforeExclamation", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeExclamation"));
        options.put("Atl.CodeFormatter.SpacesAfterExclamation", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterExclamation"));
        options.put("Atl.CodeFormatter.SpacesBeforeRuleBrace", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeRuleBrace"));
        options.put("Atl.CodeFormatter.SpacesBeforeEndingSemi", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesBeforeEndingSemi"));
        options.put("Atl.CodeFormatter.CutAfterPoint", "" + preferenceStore.getBoolean("Atl.CodeFormatter.CutAfterPoint"));
        options.put("Atl.CodeFormatter.SpacesAfterComment", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesAfterComment"));
        options.put("Atl.CodeFormatter.SpacesOutsideCollectionBrace", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesOutsideCollectionBrace"));
        options.put("Atl.CodeFormatter.SpacesInsideCollectionBrace", "" + preferenceStore.getInt("Atl.CodeFormatter.SpacesInsideCollectionBrace"));
        options.put("Atl.CodeFormatter.LinesAfterModule", "" + preferenceStore.getInt("Atl.CodeFormatter.LinesAfterModule"));
        options.put("Atl.CodeFormatter.LinesAfterCreateFrom", "" + preferenceStore.getInt("Atl.CodeFormatter.LinesAfterCreateFrom"));
        options.put("Atl.CodeFormatter.LinesAfterSpecialTags", "" + preferenceStore.getInt("Atl.CodeFormatter.LinesAfterSpecialTags"));
        return options;
    }

    public static Map<String, String> getDefaultOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("Atl.CodeFormatter.LinesBetween", "1");
        options.put("Atl.CodeFormatter.LineMaxLength", "90");
        options.put("tabWidth", "4");
        options.put("Atl.CodeFormatter.SpacesInsideBraces", "0");
        options.put("Atl.CodeFormatter.SpacesOutsideBraces", "0");
        options.put("Atl.CodeFormatter.SpacesBeforeArrows", "1");
        options.put("Atl.CodeFormatter.SpacesAfterArrows", "1");
        options.put("Atl.CodeFormatter.SpacesBeforeSemi", "0");
        options.put("Atl.CodeFormatter.SpacesAfterSemi", "1");
        options.put("Atl.CodeFormatter.SpacesBeforeComa", "0");
        options.put("Atl.CodeFormatter.SpacesAfterComa", "1");
        options.put("Atl.CodeFormatter.SpacesBeforeColon", "0");
        options.put("Atl.CodeFormatter.SpacesAfterColon", "1");
        options.put("Atl.CodeFormatter.SpacesBeforePoint", "0");
        options.put("Atl.CodeFormatter.SpacesAfterPoint", "0");
        options.put("Atl.CodeFormatter.SpacesBeforeOperator", "1");
        options.put("Atl.CodeFormatter.SpacesAfterOperator", "1");
        options.put("Atl.CodeFormatter.SpacesBeforeEqual", "1");
        options.put("Atl.CodeFormatter.SpacesAfterEqual", "1");
        options.put("Atl.CodeFormatter.SpacesBeforePipe", "1");
        options.put("Atl.CodeFormatter.SpacesAfterPipe", "1");
        options.put("Atl.CodeFormatter.SpacesBeforeExclamation", "0");
        options.put("Atl.CodeFormatter.SpacesAfterExclamation", "0");
        options.put("Atl.CodeFormatter.SpacesBeforeRuleBrace", "1");
        options.put("Atl.CodeFormatter.SpacesBeforeEndingSemi", "0");
        options.put("Atl.CodeFormatter.CutAfterPoint", "true");
        options.put("Atl.CodeFormatter.SpacesAfterComment", "1");
        options.put("Atl.CodeFormatter.SpacesOutsideCollectionBrace", "0");
        options.put("Atl.CodeFormatter.SpacesInsideCollectionBrace", "0");
        options.put("Atl.CodeFormatter.LinesAfterModule", "0");
        options.put("Atl.CodeFormatter.LinesAfterCreateFrom", "1");
        options.put("Atl.CodeFormatter.LinesAfterSpecialTags", "2");
        return options;
    }

    public static String getChars(int n, char character) {
        String spaces = "";
        int i = 0;
        while (i < n) {
            spaces = String.valueOf(spaces) + character;
            ++i;
        }
        return spaces;
    }

    public int getLineMaxLength() {
        return this.lineMaxLength;
    }

    public int getTabSpaces() {
        return this.tabSpaces;
    }

    public String getLinesSpaces() {
        return AtlCodeFormatterPreferences.getChars(this.linesBetween, '\n');
    }

    public String getOpeningBracket() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesOutsideBraces, ' ')) + "(" + AtlCodeFormatterPreferences.getChars(this.spacesInsideBraces, ' ');
    }

    public String getClosingBracket() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesInsideBraces, ' ')) + ")" + AtlCodeFormatterPreferences.getChars(this.spacesOutsideBraces, ' ');
    }

    public String getBindingArrow() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeArrows, ' ')) + "<-" + AtlCodeFormatterPreferences.getChars(this.spacesAfterArrows, ' ');
    }

    public String getCallingArrow() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeArrows, ' ')) + "->" + AtlCodeFormatterPreferences.getChars(this.spacesAfterArrows, ' ');
    }

    public String getSemicolon() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeSemi, ' ')) + ";" + AtlCodeFormatterPreferences.getChars(this.spacesAfterSemi, ' ');
    }

    public String getComa() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeComa, ' ')) + "," + AtlCodeFormatterPreferences.getChars(this.spacesAfterComa, ' ');
    }

    public String getEndingComa(int tab) {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeComa, ' ')) + ",\n" + AtlCodeFormatterPreferences.getChars(tab, '\t');
    }

    public String getColon() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeColon, ' ')) + ":" + AtlCodeFormatterPreferences.getChars(this.spacesAfterColon, ' ');
    }

    public String getPoint() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforePoint, ' ')) + "." + AtlCodeFormatterPreferences.getChars(this.spacesAfterPoint, ' ');
    }

    public String getEqual() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeEqual, ' ')) + "=" + AtlCodeFormatterPreferences.getChars(this.spacesAfterEqual, ' ');
    }

    public String getEndingEqual() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeEqual, ' ')) + "=";
    }

    public String getPipe() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforePipe, ' ')) + "|" + AtlCodeFormatterPreferences.getChars(this.spacesAfterPipe, ' ');
    }

    public String getExclamation() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeExclamation, ' ')) + "!" + AtlCodeFormatterPreferences.getChars(this.spacesAfterExclamation, ' ');
    }

    public String getEndingSemicolon() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesBeforeEndingSemi, ' ')) + ";";
    }

    public String getSpacesAfterComment() {
        return AtlCodeFormatterPreferences.getChars(this.spacesAfterComment, ' ');
    }

    public String getOpeningCollectionBrace() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesOutsideCollectionBrace, ' ')) + "{" + AtlCodeFormatterPreferences.getChars(this.spacesInsideCollectionBrace, ' ');
    }

    public String getClosingCollectionBrace() {
        return String.valueOf(AtlCodeFormatterPreferences.getChars(this.spacesInsideCollectionBrace, ' ')) + "}" + AtlCodeFormatterPreferences.getChars(this.spacesOutsideCollectionBrace, ' ');
    }

    public String getRuleBrace(int indentation) {
        String before = "";
        if (this.spacesBeforeRuleBrace == 1) {
            before = " ";
        } else if (this.spacesBeforeRuleBrace == 2) {
            before = "\n" + AtlCodeFormatterPreferences.getChars(indentation, '\t');
        }
        return String.valueOf(before) + "{";
    }

    public String getBeforeOperator(int indentation) {
        String before = "";
        if (this.spacesBeforeOperator == 1) {
            before = " ";
        } else if (this.spacesBeforeOperator == 2) {
            before = "\n" + AtlCodeFormatterPreferences.getChars(indentation, '\t');
        }
        return before;
    }

    public String getAfterOperator(int indentation) {
        String before = "";
        if (this.spacesAfterOperator == 1) {
            before = " ";
        } else if (this.spacesAfterOperator == 2) {
            before = "\n" + AtlCodeFormatterPreferences.getChars(indentation, '\t');
        }
        return before;
    }

    public String getLinesAfterModule() {
        return AtlCodeFormatterPreferences.getChars(this.linesAfterModule, '\n');
    }

    public String getLinesAfterCreateFrom() {
        return AtlCodeFormatterPreferences.getChars(this.linesAfterCreateFrom, '\n');
    }

    public String getLinesAfterSpecialTags() {
        return AtlCodeFormatterPreferences.getChars(this.linesAfterSpecialTags, '\n');
    }

    public boolean isCutAfterPoint() {
        return this.cutAfterPoint;
    }

    private void setLineMaxLength(int lineMaxLength) {
        this.lineMaxLength = lineMaxLength;
    }

    private void setTabSpaces(int tabSpaces) {
        this.tabSpaces = tabSpaces;
    }

    private void setLinesBetween(int linesBetween) {
        this.linesBetween = linesBetween;
    }

    private void setSpacesInsideBraces(int spacesInsideBraces) {
        this.spacesInsideBraces = spacesInsideBraces;
    }

    private void setSpacesOutsideBraces(int spacesOutsideBraces) {
        this.spacesOutsideBraces = spacesOutsideBraces;
    }

    private void setSpacesBeforeArrows(int spacesBeforeArrows) {
        this.spacesBeforeArrows = spacesBeforeArrows;
    }

    private void setSpacesAfterArrows(int spacesAfterArrows) {
        this.spacesAfterArrows = spacesAfterArrows;
    }

    private void setSpacesBeforeSemi(int spacesBeforeSemi) {
        this.spacesBeforeSemi = spacesBeforeSemi;
    }

    private void setSpacesAfterSemi(int spacesAfterSemi) {
        this.spacesAfterSemi = spacesAfterSemi;
    }

    private void setSpacesBeforeComa(int spacesBeforeComa) {
        this.spacesBeforeComa = spacesBeforeComa;
    }

    private void setSpacesAfterComa(int spacesAfterComa) {
        this.spacesAfterComa = spacesAfterComa;
    }

    private void setSpacesBeforeColon(int spacesBeforeColon) {
        this.spacesBeforeColon = spacesBeforeColon;
    }

    private void setSpacesAfterColon(int spacesAfterColon) {
        this.spacesAfterColon = spacesAfterColon;
    }

    private void setSpacesBeforePoint(int spacesBeforePoint) {
        this.spacesBeforePoint = spacesBeforePoint;
    }

    private void setSpacesAfterPoint(int spacesAfterPoint) {
        this.spacesAfterPoint = spacesAfterPoint;
    }

    private void setSpacesBeforeOperator(int spacesBeforeOperator) {
        this.spacesBeforeOperator = spacesBeforeOperator;
    }

    private void setSpacesAfterOperator(int spacesAfterOperator) {
        this.spacesAfterOperator = spacesAfterOperator;
    }

    private void setLinesAfterModule(int linesAfterModule) {
        this.linesAfterModule = linesAfterModule;
    }

    private void setLinesAfterCreateFrom(int linesAfterCreateFrom) {
        this.linesAfterCreateFrom = linesAfterCreateFrom;
    }

    private void setLinesAfterSpecialTags(int linesAfterSpecialTags) {
        this.linesAfterSpecialTags = linesAfterSpecialTags;
    }

    private void setCutAfterPoint(boolean cutAfterPoint) {
        this.cutAfterPoint = cutAfterPoint;
    }

    private void setSpacesBeforeEqual(int spacesBeforeEqual) {
        this.spacesBeforeEqual = spacesBeforeEqual;
    }

    private void setSpacesAfterEqual(int spacesAfterEqual) {
        this.spacesAfterEqual = spacesAfterEqual;
    }

    private void setSpacesBeforePipe(int spacesBeforePipe) {
        this.spacesBeforePipe = spacesBeforePipe;
    }

    private void setSpacesAfterPipe(int spacesAfterPipe) {
        this.spacesAfterPipe = spacesAfterPipe;
    }

    private void setSpacesBeforeExclamation(int spacesBeforeExclamation) {
        this.spacesBeforeExclamation = spacesBeforeExclamation;
    }

    private void setSpacesAfterExclamation(int spacesAfterExclamation) {
        this.spacesAfterExclamation = spacesAfterExclamation;
    }

    private void setSpacesBeforeRuleBrace(int spacesBeforeRuleBrace) {
        this.spacesBeforeRuleBrace = spacesBeforeRuleBrace;
    }

    private void setSpacesBeforeEndingSemi(int spacesBeforeEndingSemi) {
        this.spacesBeforeEndingSemi = spacesBeforeEndingSemi;
    }

    private void setSpacesAfterComment(int spacesAfterComment) {
        this.spacesAfterComment = spacesAfterComment;
    }

    public void setSpacesOutsideCollectionBrace(int spacesOutsideCollectionBrace) {
        this.spacesOutsideCollectionBrace = spacesOutsideCollectionBrace;
    }

    public void setSpacesInsideCollectionBrace(int spacesInsideCollectionBrace) {
        this.spacesInsideCollectionBrace = spacesInsideCollectionBrace;
    }
}

