/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.impl.ModelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
extends ModelImpl
implements Metamodel {
    protected Map<String, EClassifier> types;
    protected Set<String> ambiguousTypes = new HashSet<String>();

    protected MetamodelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.METAMODEL;
    }

    @Override
    public synchronized EClassifier findType(String typeName) {
        EClassifier type;
        if (this.types == null) {
            this.types = this.createTypeTable(this.ambiguousTypes);
        }
        if ((type = this.types.get(typeName)) == null) {
            throw new IllegalArgumentException(String.format("Type %s not found in metamodel %s", typeName, this));
        }
        if (this.ambiguousTypes.contains(typeName)) {
            ATLLogger.warning((String)String.format("Metamodel %s contains more than one type with name %s", this, typeName));
        }
        return type;
    }

    private Map<String, EClassifier> createTypeTable(Set<String> ambiguousTypes) {
        HashMap<String, EClassifier> types = new HashMap<String, EClassifier>();
        Resource res = this.getResource();
        assert (res != null);
        MetamodelImpl.registerTypeChain(types, res, null, new HashSet<Object>(), ambiguousTypes);
        return types;
    }

    private static void registerTypeChain(Map<String, EClassifier> types, Resource res, String ns, Set<Object> ignore, Set<String> ambiguousTypes) {
        if (res != null && !ignore.contains(res)) {
            ignore.add(res);
            MetamodelImpl.registerTypeChain(types, (EList<? extends EObject>)res.getContents(), null, ignore, ambiguousTypes);
        }
    }

    private static void registerTypeChain(Map<String, EClassifier> types, EList<? extends EObject> objects, String ns, Set<Object> ignore, Set<String> ambiguousTypes) {
        for (EObject o : objects) {
            switch (o.eClass().getClassifierID()) {
                case 12: {
                    String pname = ((EPackage)o).getName();
                    if (ns != null) {
                        pname = String.valueOf(ns) + "::" + pname;
                    }
                    MetamodelImpl.registerTypeChain(types, (EList<? extends EObject>)o.eContents(), pname, ignore, ambiguousTypes);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    MetamodelImpl.registerTypeChain(types, (EClassifier)o, ns, ignore, ambiguousTypes);
                    break;
                }
                default: {
                    MetamodelImpl.registerTypeChain(types, (EList<? extends EObject>)o.eContents(), ns, ignore, ambiguousTypes);
                }
            }
        }
    }

    private static void registerTypeChain(Map<String, EClassifier> types, EClassifier type, String ns, Set<Object> ignore, Set<String> ambiguousTypes) {
        if (ignore.contains(type)) {
            return;
        }
        ignore.add(type);
        MetamodelImpl.registerSingleType(types, String.valueOf(ns) + "::" + type.getName(), type, ambiguousTypes);
        MetamodelImpl.registerSingleType(types, type.getName(), type, ambiguousTypes);
        if (type instanceof EClass) {
            EClassifier eType;
            EClass cls = (EClass)type;
            for (EStructuralFeature sf : cls.getEStructuralFeatures()) {
                eType = sf.getEType();
                if (eType == null) continue;
                MetamodelImpl.registerTypeChain(types, eType.eResource(), null, ignore, ambiguousTypes);
            }
            for (EOperation op : cls.getEOperations()) {
                eType = op.getEType();
                if (eType != null) {
                    MetamodelImpl.registerTypeChain(types, eType.eResource(), null, ignore, ambiguousTypes);
                }
                for (EParameter p : op.getEParameters()) {
                    eType = p.getEType();
                    if (eType == null) continue;
                    MetamodelImpl.registerTypeChain(types, eType.eResource(), null, ignore, ambiguousTypes);
                }
            }
            for (EClass superCls : cls.getESuperTypes()) {
                MetamodelImpl.registerTypeChain(types, superCls.eResource(), null, ignore, ambiguousTypes);
            }
        }
    }

    private static void registerSingleType(Map<String, EClassifier> types, String typeName, EClassifier type, Set<String> ambiguousTypes) {
        if (types.containsKey(typeName)) {
            ambiguousTypes.add(typeName);
        }
        types.put(typeName, type);
    }
}

