/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RuleMode implements Enumerator
{
    MANUAL(0, "manual", "manual"),
    AUTOMATIC_SINGLE(1, "automaticSingle", "automaticSingle"),
    AUTOMATIC_RECURSIVE(2, "automaticRecursive", "automaticRecursive");

    public static final int MANUAL_VALUE = 0;
    public static final int AUTOMATIC_SINGLE_VALUE = 1;
    public static final int AUTOMATIC_RECURSIVE_VALUE = 2;
    private static final RuleMode[] VALUES_ARRAY;
    public static final List<RuleMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RuleMode[]{MANUAL, AUTOMATIC_SINGLE, AUTOMATIC_RECURSIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RuleMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleMode get(int value) {
        switch (value) {
            case 0: {
                return MANUAL;
            }
            case 1: {
                return AUTOMATIC_SINGLE;
            }
            case 2: {
                return AUTOMATIC_RECURSIVE;
            }
        }
        return null;
    }

    private RuleMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

