/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public interface UnitResolverFactory {
    public boolean isAccepted(Object var1);

    public UnitResolver getResolver(URI var1);

    public UnitProxy findUnit(URI var1);

    public static interface Registry {
        public static final String POINT_ID = "org.eclipse.m2m.qvt.oml.unitResolverFactory";
        public static final String CLASS_ATTR = "class";
        public static final Registry INSTANCE = new Registry(){
            private List<UnitResolverFactory> factories = this.readFactories();

            @Override
            public UnitResolverFactory getFactory(Object source) {
                for (UnitResolverFactory nextFactory : this.factories) {
                    if (!nextFactory.isAccepted(source)) continue;
                    return nextFactory;
                }
                return null;
            }

            @Override
            public UnitProxy getUnit(URI uri) {
                UnitResolverFactory factory = this.getFactory(uri);
                if (factory != null) {
                    return factory.findUnit(uri);
                }
                return null;
            }

            private List<UnitResolverFactory> readFactories() {
                ArrayList<UnitResolverFactory> factoryEntries = new ArrayList<UnitResolverFactory>();
                IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(Registry.POINT_ID);
                if (extensionPoint != null) {
                    IExtension[] allExtensions;
                    IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
                    int n = allExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension nextExtension = iExtensionArray[n2];
                        IConfigurationElement[] elements = nextExtension.getConfigurationElements();
                        Object factoryObj = null;
                        try {
                            factoryObj = elements[0].createExecutableExtension(Registry.CLASS_ATTR);
                            if (factoryObj instanceof UnitResolverFactory) {
                                factoryEntries.add((UnitResolverFactory)factoryObj);
                            }
                        }
                        catch (CoreException e) {
                            QvtPlugin.log(e);
                        }
                        ++n2;
                    }
                }
                return factoryEntries;
            }
        };

        public UnitResolverFactory getFactory(Object var1);

        public UnitProxy getUnit(URI var1);
    }
}

