/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.business.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.gastro.business.provider.BusinessDayItemProvider;
import org.gastro.business.provider.OrderDetailItemProvider;
import org.gastro.business.provider.OrderItemProvider;
import org.gastro.business.provider.WaiterItemProvider;
import org.gastro.business.util.BusinessAdapterFactory;

public class BusinessItemProviderAdapterFactory
extends BusinessAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected BusinessDayItemProvider businessDayItemProvider;
    protected OrderItemProvider orderItemProvider;
    protected OrderDetailItemProvider orderDetailItemProvider;
    protected WaiterItemProvider waiterItemProvider;

    public BusinessItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createBusinessDayAdapter() {
        if (this.businessDayItemProvider == null) {
            this.businessDayItemProvider = new BusinessDayItemProvider((AdapterFactory)this);
        }
        return this.businessDayItemProvider;
    }

    public Adapter createOrderAdapter() {
        if (this.orderItemProvider == null) {
            this.orderItemProvider = new OrderItemProvider((AdapterFactory)this);
        }
        return this.orderItemProvider;
    }

    public Adapter createOrderDetailAdapter() {
        if (this.orderDetailItemProvider == null) {
            this.orderDetailItemProvider = new OrderDetailItemProvider((AdapterFactory)this);
        }
        return this.orderDetailItemProvider;
    }

    public Adapter createWaiterAdapter() {
        if (this.waiterItemProvider == null) {
            this.waiterItemProvider = new WaiterItemProvider((AdapterFactory)this);
        }
        return this.waiterItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.businessDayItemProvider != null) {
            this.businessDayItemProvider.dispose();
        }
        if (this.orderItemProvider != null) {
            this.orderItemProvider.dispose();
        }
        if (this.orderDetailItemProvider != null) {
            this.orderDetailItemProvider.dispose();
        }
        if (this.waiterItemProvider != null) {
            this.waiterItemProvider.dispose();
        }
    }
}

