/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.net4j.internal.util.test.CurrentTestName;
import org.eclipse.net4j.internal.util.test.TestExecuter;
import org.eclipse.net4j.tests.bundle.OM;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.concurrent.TrackableTimerTask;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.TMPUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.FileLogHandler;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.junit.Assert;

public abstract class AbstractOMTest
extends TestCase {
    public static final long DEFAULT_TIMEOUT = 15000L;
    public static final long DEFAULT_TIMEOUT_EXPECTED = 5000L;
    public static boolean EXTERNAL_LOG;
    public static boolean SUPPRESS_OUTPUT;
    private static final IListener DUMPER;
    private static final ContextTracer TRACER;
    private static boolean consoleEnabled;
    private static String testName;
    private final transient List<File> filesToDelete = new ArrayList<File>();
    private transient String codeLink;

    static {
        DUMPER = new IListener(){

            public void notifyEvent(IEvent event) {
                IOUtil.OUT().println(event);
            }
        };
        TRACER = new ContextTracer(OM.DEBUG, AbstractOMTest.class);
        try {
            if (EXTERNAL_LOG) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
                String prefix = String.valueOf(AbstractOMTest.class.getName()) + "-" + formatter.format(new Date()) + "-";
                File logFile = TMPUtil.createTempFile((String)prefix, (String)".log");
                OMPlatform.INSTANCE.addLogHandler((OMLogHandler)new FileLogHandler(logFile, OMLogger.Level.WARN){

                    protected void writeLog(OMLogger logger, OMLogger.Level level, String msg, Throwable t) throws Throwable {
                        super.writeLog(logger, level, "--> " + testName + "\n" + msg, t);
                    }
                });
                IOUtil.ERR().println("Logging errors and warnings to " + logFile);
                IOUtil.ERR().println();
            }
        }
        catch (Throwable ex) {
            IOUtil.print((Throwable)ex);
        }
    }

    protected AbstractOMTest() {
    }

    public String getCodeLink() {
        return this.codeLink;
    }

    public void determineCodeLink() {
        if (this.codeLink == null) {
            this.codeLink = this.determineCodeLink(this.getName());
            if (this.codeLink == null) {
                this.codeLink = this.determineCodeLink("doSetUp");
                if (this.codeLink == null) {
                    this.codeLink = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName() + "(" + ((Object)((Object)this)).getClass().getSimpleName() + ".java:1)";
                }
            }
        }
    }

    protected String determineCodeLink(String methodName) {
        StackTraceElement[] stackTrace;
        String className = ((Object)((Object)this)).getClass().getName();
        StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            if (frame.getClassName().equals(className) && frame.getMethodName().equals(methodName)) {
                return frame.toString();
            }
            ++n2;
        }
        return null;
    }

    protected boolean logSetUpAndTearDown() {
        return false;
    }

    public void setUp() throws Exception {
        testName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName() + "()";
        CurrentTestName.set((String)testName);
        this.codeLink = null;
        PrintTraceHandler.CONSOLE.setShortContext(true);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        this.enableConsole();
        if (!SUPPRESS_OUTPUT) {
            IOUtil.OUT().println("*******************************************************\n" + (Object)((Object)this) + "\n*******************************************************");
        }
        if (!this.logSetUpAndTearDown()) {
            this.disableConsole();
        }
        super.setUp();
        this.doSetUp();
        if (!SUPPRESS_OUTPUT && this.logSetUpAndTearDown()) {
            IOUtil.OUT().println("\n------------------------ START ------------------------");
        }
        this.enableConsole();
    }

    public void tearDown() throws Exception {
        if (this.logSetUpAndTearDown()) {
            this.enableConsole();
        } else {
            this.disableConsole();
        }
        if (!SUPPRESS_OUTPUT && this.logSetUpAndTearDown()) {
            IOUtil.OUT().println("------------------------- END -------------------------\n");
        }
        try {
            this.doTearDown();
        }
        catch (Exception ex) {
            IOUtil.print((Throwable)ex);
        }
        try {
            super.tearDown();
        }
        catch (Exception ex) {
            IOUtil.print((Throwable)ex);
        }
        try {
            TrackableTimerTask.logConstructionStackTraces((long)30000L);
        }
        catch (Exception ex) {
            IOUtil.print((Throwable)ex);
        }
        try {
            this.clearReferences(((Object)((Object)this)).getClass());
        }
        catch (Exception ex) {
            IOUtil.print((Throwable)ex);
        }
        if (!SUPPRESS_OUTPUT) {
            IOUtil.OUT().println();
            IOUtil.OUT().println();
        }
    }

    protected void clearReferences(Class<?> c) {
        if (c != AbstractOMTest.class) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers()) && !field.getType().isPrimitive()) {
                    ReflectUtil.makeAccessible((AccessibleObject)field);
                    ReflectUtil.setValue((Field)field, (Object)((Object)this), null);
                }
                ++n2;
            }
            this.clearReferences(c.getSuperclass());
        }
    }

    public void runBare() throws Throwable {
        TestExecuter.execute((Object)((Object)this), (TestExecuter.Executable)new TestExecuter.Executable(){

            public void execute() throws Throwable {
                try {
                    Throwable exception;
                    block17: {
                        exception = null;
                        try {
                            try {
                                AbstractOMTest.this.setUp();
                                AbstractOMTest.this.runTest();
                            }
                            catch (Throwable running) {
                                exception = running;
                                try {
                                    AbstractOMTest.this.tearDown();
                                }
                                catch (Throwable tearingDown) {
                                    if (exception == null) {
                                        exception = tearingDown;
                                    }
                                    break block17;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block18: {
                                try {
                                    AbstractOMTest.this.tearDown();
                                }
                                catch (Throwable tearingDown) {
                                    if (exception != null) break block18;
                                    exception = tearingDown;
                                }
                            }
                            throw throwable;
                        }
                        try {
                            AbstractOMTest.this.tearDown();
                        }
                        catch (Throwable tearingDown) {
                            if (exception != null) break block17;
                            exception = tearingDown;
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
                catch (SkipTestException ex) {
                    OM.LOG.info("Skipped " + this + "\n");
                }
                catch (Throwable t) {
                    if (!SUPPRESS_OUTPUT) {
                        t.printStackTrace(IOUtil.OUT());
                    }
                    throw t;
                }
            }

            public String toString() {
                return AbstractOMTest.getCurrrentTest().toString();
            }
        });
    }

    public void run(TestResult result) {
        try {
            super.run(result);
        }
        catch (SkipTestException ex) {
            OM.LOG.info("Skipped " + (Object)((Object)this) + "\n");
        }
        catch (RuntimeException ex) {
            if (!SUPPRESS_OUTPUT) {
                ex.printStackTrace(IOUtil.OUT());
            }
            throw ex;
        }
        catch (Error err) {
            if (!SUPPRESS_OUTPUT) {
                err.printStackTrace(IOUtil.OUT());
            }
            throw err;
        }
    }

    protected void enableConsole() {
        if (!SUPPRESS_OUTPUT) {
            OMPlatform.INSTANCE.setDebugging(true);
            consoleEnabled = true;
        }
    }

    protected void disableConsole() {
        if (!SUPPRESS_OUTPUT) {
            consoleEnabled = false;
            OMPlatform.INSTANCE.setDebugging(false);
        }
    }

    protected void doSetUp() throws Exception {
    }

    protected void doTearDown() throws Exception {
        this.deleteFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFiles() {
        List<File> list = this.filesToDelete;
        synchronized (list) {
            for (File file : this.filesToDelete) {
                IOUtil.delete((File)file);
            }
            this.filesToDelete.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToDelete(File file) {
        List<File> list = this.filesToDelete;
        synchronized (list) {
            this.filesToDelete.add(file);
        }
    }

    public File getTempName() throws IORuntimeException {
        File name = TMPUtil.getTempName();
        this.addFileToDelete(name);
        return name;
    }

    public File getTempName(String prefix) throws IORuntimeException {
        File name = TMPUtil.getTempName((String)prefix);
        this.addFileToDelete(name);
        return name;
    }

    public File getTempName(String prefix, String suffix) throws IORuntimeException {
        File name = TMPUtil.getTempName((String)prefix, (String)suffix);
        this.addFileToDelete(name);
        return name;
    }

    public File getTempName(String prefix, String suffix, File directory) throws IORuntimeException {
        File name = TMPUtil.getTempName((String)prefix, (String)suffix, (File)directory);
        this.addFileToDelete(name);
        return name;
    }

    public File createTempFolder() throws IORuntimeException {
        File folder = TMPUtil.createTempFolder();
        this.addFileToDelete(folder);
        return folder;
    }

    public File createTempFolder(String prefix) throws IORuntimeException {
        File folder = TMPUtil.createTempFolder((String)prefix);
        this.addFileToDelete(folder);
        return folder;
    }

    public File createTempFolder(String prefix, String suffix) throws IORuntimeException {
        File folder = TMPUtil.createTempFolder((String)prefix, (String)suffix);
        this.addFileToDelete(folder);
        return folder;
    }

    public File createTempFolder(String prefix, String suffix, File directory) throws IORuntimeException {
        File folder = TMPUtil.createTempFile((String)prefix, (String)suffix, (File)directory);
        this.addFileToDelete(folder);
        return folder;
    }

    public File createTempFile() throws IORuntimeException {
        File file = TMPUtil.createTempFile();
        this.addFileToDelete(file);
        return file;
    }

    public File createTempFile(String prefix) throws IORuntimeException {
        File file = TMPUtil.createTempFile((String)prefix);
        this.addFileToDelete(file);
        return file;
    }

    public File createTempFile(String prefix, String suffix) throws IORuntimeException {
        File file = TMPUtil.createTempFile((String)prefix, (String)suffix);
        this.addFileToDelete(file);
        return file;
    }

    public File createTempFile(String prefix, String suffix, File directory) throws IORuntimeException {
        File file = TMPUtil.createTempFile((String)prefix, (String)suffix, (File)directory);
        this.addFileToDelete(file);
        return file;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "." + this.getName();
    }

    public static AbstractOMTest getCurrrentTest() {
        return (AbstractOMTest)((Object)TestExecuter.getCurrrentTest());
    }

    public static void assertTrue(String message, boolean condition) {
        AbstractOMTest.assertEquals((String)message, (boolean)true, (boolean)condition);
    }

    public static void assertTrue(boolean condition) {
        AbstractOMTest.assertEquals((boolean)true, (boolean)condition);
    }

    public static void assertFalse(String message, boolean condition) {
        AbstractOMTest.assertEquals((String)message, (boolean)false, (boolean)condition);
    }

    public static void assertFalse(boolean condition) {
        AbstractOMTest.assertEquals((boolean)false, (boolean)condition);
    }

    public static void assertEquals(Object[] expected, Object[] actual) {
        if (!Arrays.deepEquals(expected, actual)) {
            throw new AssertionFailedError("expected:" + Arrays.deepToString(expected) + " but was:" + Arrays.deepToString(actual));
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        if (actual == expected) {
            return;
        }
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError ex) {
            AssertionFailedError error = new AssertionFailedError(((Throwable)((Object)ex)).getMessage());
            error.initCause((Throwable)((Object)ex));
            throw error;
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        if (actual != null && actual.equals(expected)) {
            return;
        }
        AbstractOMTest.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void assertEqualsIgnoreCase(String actual, String expected) {
        if (actual == null) {
            AbstractOMTest.assertNull((Object)expected);
        }
        if (!actual.equalsIgnoreCase(expected)) {
            AbstractOMTest.fail((String)("Expected (ignoring case): '" + expected + "', but was: '" + actual + "'"));
        }
    }

    public static void assertInstanceOf(Class<?> expected, Object object) {
        AbstractOMTest.assertEquals((String)("Not an instance of " + expected + ": " + object.getClass().getName()), (boolean)true, (boolean)expected.isInstance(object));
    }

    public static void assertNotInstanceOf(Class<?> expected, Object object) {
        AbstractOMTest.assertEquals((String)("An instance of " + expected + ": " + object.getClass().getName()), (boolean)false, (boolean)expected.isInstance(object));
    }

    public static void assertException(Class<? extends Throwable> type, RunnableWithException runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            AbstractOMTest.assertInstanceOf(type, ex);
            return;
        }
        AbstractOMTest.fail((String)("Expected " + type));
    }

    public static void assertActive(Object object) throws InterruptedException {
        final LatchTimeOuter timeOuter = new LatchTimeOuter();
        LifecycleEventAdapter listener = new LifecycleEventAdapter(){

            protected void onActivated(ILifecycle lifecycle) {
                timeOuter.countDown();
            }
        };
        EventUtil.addListener((Object)object, (IListener)listener);
        try {
            if (LifecycleUtil.isActive((Object)object)) {
                timeOuter.countDown();
            }
            timeOuter.assertNoTimeOut();
        }
        finally {
            EventUtil.removeListener((Object)object, (IListener)listener);
        }
    }

    public static void assertInactive(Object object) throws InterruptedException {
        final LatchTimeOuter timeOuter = new LatchTimeOuter();
        LifecycleEventAdapter listener = new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                timeOuter.countDown();
            }
        };
        EventUtil.addListener((Object)object, (IListener)listener);
        try {
            if (!LifecycleUtil.isActive((Object)object)) {
                return;
            }
            timeOuter.assertNoTimeOut();
        }
        finally {
            EventUtil.removeListener((Object)object, (IListener)listener);
        }
    }

    public static void assertSimilar(double expected, double actual, int precision) {
        double factor = 10 * precision;
        if (Math.round(expected * factor) != Math.round(actual * factor)) {
            AbstractOMTest.assertEquals(expected, actual);
        }
    }

    public static void assertSimilar(float expected, float actual, int precision) {
        float factor = 10 * precision;
        if (Math.round(expected * factor) != Math.round(actual * factor)) {
            AbstractOMTest.assertEquals(Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    public static void assertNoTimeout(BooleanSupplier success) {
        AbstractOMTest.assertNoTimeout(15000L, success);
    }

    public static void assertNoTimeout(long timeout, BooleanSupplier success) {
        AbstractOMTest.withTimeOuter(success, (ConsumerWithException<TimeOuter, InterruptedException>)((ConsumerWithException)timeOuter -> timeOuter.assertNoTimeOut(timeout)));
    }

    public static void assertTimeout(BooleanSupplier success) {
        AbstractOMTest.assertTimeout(5000L, success);
    }

    public static void assertTimeout(long timeout, BooleanSupplier success) {
        AbstractOMTest.withTimeOuter(success, (ConsumerWithException<TimeOuter, InterruptedException>)((ConsumerWithException)timeOuter -> timeOuter.assertTimeOut(timeout)));
    }

    private static void withTimeOuter(final BooleanSupplier success, ConsumerWithException<TimeOuter, InterruptedException> consumer) {
        try {
            PollingTimeOuter timeOuter = new PollingTimeOuter(){

                @Override
                protected boolean successful() {
                    return success.getAsBoolean();
                }
            };
            consumer.accept((Object)timeOuter);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static void sleep(long millis) {
        AbstractOMTest.msg("Sleeping " + millis);
        ConcurrencyUtil.sleep((long)millis);
    }

    public static void msg(Object m) {
        if (!SUPPRESS_OUTPUT && consoleEnabled && TRACER.isEnabled()) {
            TRACER.trace(String.valueOf(m));
        }
    }

    public static void dumpEvents(Object notifier) {
        AbstractOMTest.dumpEvents(notifier, true);
    }

    public static void dumpEvents(Object notifier, boolean on) {
        if (notifier instanceof INotifier) {
            INotifier iNotifier = (INotifier)notifier;
            IListener[] listeners = iNotifier.getListeners();
            boolean wasOn = false;
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] == DUMPER) {
                    wasOn = true;
                    break;
                }
                ++i;
            }
            if (on && !wasOn) {
                iNotifier.addListener(DUMPER);
            } else if (!on && wasOn) {
                iNotifier.removeListener(DUMPER);
            }
        }
    }

    public static void skipTest(boolean skip) {
        if (skip) {
            throw new SkipTestException();
        }
    }

    public static void skipTest() {
        AbstractOMTest.skipTest(true);
    }

    public static void triggerGC() {
        ArrayList<byte[]> bigdata = new ArrayList<byte[]>();
        try {
            try {
                while (true) {
                    bigdata.add(new byte[0x100000]);
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void disableLog4j() {
        BasicConfigurator.configure((Appender)new Appender(){

            public void setName(String arg0) {
            }

            public void setLayout(Layout arg0) {
            }

            public void setErrorHandler(ErrorHandler arg0) {
            }

            public boolean requiresLayout() {
                return false;
            }

            public String getName() {
                return null;
            }

            public Layout getLayout() {
                return null;
            }

            public Filter getFilter() {
                return null;
            }

            public ErrorHandler getErrorHandler() {
                return null;
            }

            public void doAppend(LoggingEvent arg0) {
            }

            public void close() {
            }

            public void clearFilters() {
            }

            public void addFilter(Filter arg0) {
            }
        });
    }

    public static void await(CountDownLatch latch) throws TimeoutRuntimeException {
        AbstractOMTest.await(latch, 15000L);
    }

    public static void await(CountDownLatch latch, long millis) throws TimeoutRuntimeException {
        try {
            if (!latch.await(millis, TimeUnit.MILLISECONDS)) {
                throw new TimeoutRuntimeException("Latch timed out: " + latch);
            }
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static class AsyncResult<T> {
        private volatile T value;
        private CountDownLatch latch = new CountDownLatch(1);

        public void setValue(T value) {
            this.value = value;
            this.latch.countDown();
        }

        public T getValue(long timeout) throws Exception {
            if (!this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Result value not available after " + timeout + " milli seconds");
            }
            return this.value;
        }

        public T getValue() throws Exception {
            return this.getValue(15000L);
        }
    }

    public static interface ITimeOuter {
        public boolean timedOut(long var1) throws InterruptedException;
    }

    public static class LatchTimeOuter
    extends TimeOuter {
        private CountDownLatch latch;

        public LatchTimeOuter(CountDownLatch latch) {
            this.latch = latch;
        }

        public LatchTimeOuter(int count) {
            this(new CountDownLatch(count));
        }

        public LatchTimeOuter() {
            this(1);
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public long getCount() {
            return this.latch.getCount();
        }

        public void countDown() {
            this.latch.countDown();
        }

        public void countDown(int n) {
            int i = 0;
            while (i < n) {
                this.countDown();
                ++i;
            }
        }

        @Override
        public boolean timedOut(long timeoutMillis) throws InterruptedException {
            return !this.latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public static class LockTimeOuter
    extends TimeOuter {
        private Lock lock;

        public LockTimeOuter(Lock lock) {
            this.lock = lock;
        }

        public Lock getLock() {
            return this.lock;
        }

        @Override
        public boolean timedOut(long timeoutMillis) throws InterruptedException {
            Condition condition = this.lock.newCondition();
            return !condition.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public static abstract class PollingTimeOuter
    extends TimeOuter {
        public static final long DEFAULT_SLEEP_MILLIS = 1L;
        private long sleepMillis = 1L;

        public PollingTimeOuter(long sleepMillis) {
            this.sleepMillis = sleepMillis;
        }

        public PollingTimeOuter() {
        }

        @Override
        public boolean timedOut(long timeoutMillis) throws InterruptedException {
            int retries = (int)Math.round((double)(timeoutMillis / this.sleepMillis) + 0.5);
            int i = 0;
            while (i < retries) {
                if (this.successful()) {
                    return false;
                }
                AbstractOMTest.sleep(this.sleepMillis);
                ++i;
            }
            return true;
        }

        protected abstract boolean successful();
    }

    public static final class SkipTestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class ThreadTimeOuter
    extends LatchTimeOuter
    implements Runnable {
        private RuntimeException exception;

        public ThreadTimeOuter() {
            super(1);
        }

        @Override
        public boolean timedOut(long timeoutMillis) throws InterruptedException {
            Thread thread = new Thread((Runnable)this, "ThreadTimeOuter"){

                @Override
                public void run() {
                    try {
                        try {
                            this.run();
                        }
                        catch (RuntimeException ex) {
                            exception = ex;
                            this.countDown();
                        }
                    }
                    finally {
                        this.countDown();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            boolean result = super.timedOut(timeoutMillis);
            if (this.exception != null) {
                throw this.exception;
            }
            return result;
        }
    }

    public static abstract class TimeOuter
    implements ITimeOuter {
        public boolean timedOut() throws InterruptedException {
            return this.timedOut(15000L);
        }

        public void assertTimeOut(long timeoutMillis) throws InterruptedException {
            AbstractOMTest.assertEquals((String)"Timeout expected", (boolean)true, (boolean)this.timedOut(timeoutMillis));
        }

        public void assertTimeOut() throws InterruptedException {
            this.assertTimeOut(5000L);
        }

        public void assertNoTimeOut(long timeoutMillis) throws InterruptedException {
            AbstractOMTest.assertEquals((String)("Timeout after " + timeoutMillis + " millis"), (boolean)false, (boolean)this.timedOut(timeoutMillis));
        }

        public void assertNoTimeOut() throws InterruptedException {
            this.assertNoTimeOut(15000L);
        }
    }
}

