/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.cdo.etypes.impl.ModelElementImpl;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.TopicStatus;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class TopicContainerImpl
extends ModelElementImpl
implements TopicContainer {
    protected static final int TOPIC_COUNT_EDEFAULT = 0;
    protected static final int UNRESOLVED_COUNT_EDEFAULT = 0;
    protected static final int RESOLVED_COUNT_EDEFAULT = 0;

    protected TopicContainerImpl() {
    }

    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.TOPIC_CONTAINER;
    }

    @Override
    public abstract Review getReview();

    @Override
    public EList<Comment> getComments() {
        return (EList)this.eDynamicGet(3, (EStructuralFeature)ReviewsPackage.Literals.TOPIC_CONTAINER__COMMENTS, true, true);
    }

    @Override
    public int getTopicCount() {
        return TopicContainerImpl.getTopicCount(this);
    }

    @Override
    public int getUnresolvedCount() {
        return TopicContainerImpl.getUnresolvedCount(this);
    }

    @Override
    public int getResolvedCount() {
        return TopicContainerImpl.getResolvedCount(this);
    }

    @Override
    public EList<Topic> getTopics() {
        return (EList)this.eDynamicGet(2, (EStructuralFeature)ReviewsPackage.Literals.TOPIC_CONTAINER__TOPICS, true, true);
    }

    public abstract System getSystem();

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getTopics()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getComments()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getTopics()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getComments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getReview();
            }
            case 2: {
                return this.getTopics();
            }
            case 3: {
                return this.getComments();
            }
            case 4: {
                return this.getTopicCount();
            }
            case 5: {
                return this.getUnresolvedCount();
            }
            case 6: {
                return this.getResolvedCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getTopics().clear();
                this.getTopics().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getComments().clear();
                this.getComments().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getTopics().clear();
                return;
            }
            case 3: {
                this.getComments().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.getReview() != null;
            }
            case 2: {
                return !this.getTopics().isEmpty();
            }
            case 3: {
                return !this.getComments().isEmpty();
            }
            case 4: {
                return this.getTopicCount() != 0;
            }
            case 5: {
                return this.getUnresolvedCount() != 0;
            }
            case 6: {
                return this.getResolvedCount() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getSystem();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public static TopicStatistics getTopicStatistics(TopicContainer container) {
        TopicStatistics statistics = new TopicStatistics();
        TopicContainerImpl.updateCommentStatistics(statistics, container);
        return statistics;
    }

    static void updateCommentStatistics(TopicStatistics statistics, TopicContainer container) {
        if (container instanceof Topic) {
            Topic topic = (Topic)container;
            TopicStatus status = topic.getStatus();
            if (status == TopicStatus.UNRESOLVED) {
                statistics.incUnresolvedCount();
            } else if (status == TopicStatus.RESOLVED) {
                statistics.incResolvedCount();
            } else {
                statistics.incNoneCount();
            }
        }
        for (Topic topic : container.getTopics()) {
            TopicContainerImpl.updateCommentStatistics(statistics, topic);
        }
    }

    static int getTopicCount(TopicContainer container) {
        TopicStatistics statistics = TopicContainerImpl.getTopicStatistics(container);
        return statistics.getTotalCount();
    }

    static int getUnresolvedCount(TopicContainer container) {
        TopicStatistics statistics = TopicContainerImpl.getTopicStatistics(container);
        return statistics.getUnresolvedCount();
    }

    static int getResolvedCount(TopicContainer container) {
        TopicStatistics statistics = TopicContainerImpl.getTopicStatistics(container);
        return statistics.getResolvedCount();
    }

    public static final class TopicStatistics {
        private int noneCount;
        private int unresolvedCount;
        private int resolvedCount;

        private TopicStatistics() {
        }

        private void incNoneCount() {
            ++this.noneCount;
        }

        private void incUnresolvedCount() {
            ++this.unresolvedCount;
        }

        private void incResolvedCount() {
            ++this.resolvedCount;
        }

        public int getTotalCount() {
            return this.noneCount + this.unresolvedCount + this.resolvedCount;
        }

        public int getNoneCount() {
            return this.noneCount;
        }

        public int getUnresolvedCount() {
            return this.unresolvedCount;
        }

        public int getResolvedCount() {
            return this.resolvedCount;
        }
    }
}

