/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.util.CoreOperations;
import org.eclipse.emf.cdo.ui.AbstractAuthorizingDialog;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.collection.MapEntry;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DeleteBranchDialog
extends AbstractAuthorizingDialog<CDOBranch> {
    public static final String TITLE = "Delete Branch";
    private final CDOBranch rootBranch;
    private final CDOBranch viewerInput;
    private TreeViewer branchViewer;

    public DeleteBranchDialog(Shell parentShell, CDOBranch branch) {
        super(parentShell, CDOUtil.getSession((Object)branch));
        this.rootBranch = branch;
        this.viewerInput = branch.getBase().getBranch();
    }

    @Override
    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        this.setTitle(TITLE);
        this.setTitleImage(SharedIcons.getImage((String)"wizban/delete.gif"));
        this.setMessage("Confirm to delete the following branches permanently.");
        return super.createDialogArea(parent);
    }

    @Override
    protected void doCreateUI(Composite container) {
        CDOItemProvider itemProvider = new CDOItemProvider(null){

            @Override
            protected boolean hasChildren(CDOBranch branch) {
                return branch == DeleteBranchDialog.this.viewerInput ? true : super.hasChildren(branch);
            }

            @Override
            protected Object[] getChildren(CDOBranch branch) {
                Object[] objectArray;
                if (branch == DeleteBranchDialog.this.viewerInput) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = DeleteBranchDialog.this.rootBranch;
                } else {
                    objectArray = super.getChildren(branch);
                }
                return objectArray;
            }

            @Override
            public String getText(Object obj) {
                CDOBranch branch = (CDOBranch)obj;
                Object name = branch.getName();
                if (DeleteBranchDialog.this.authorizer.isAuthorizing()) {
                    String authorization = DeleteBranchDialog.this.authorizer.getAuthorization(branch);
                    if (authorization == null) {
                        authorization = "Authorization pending...";
                    }
                    name = (String)name + "  (" + authorization + ")";
                }
                return name;
            }
        };
        this.branchViewer = new TreeViewer(container, 2052);
        this.branchViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.branchViewer.setLabelProvider((IBaseLabelProvider)itemProvider);
        this.branchViewer.setContentProvider((IContentProvider)itemProvider);
        this.branchViewer.setInput((Object)this.viewerInput);
        UIUtil.asyncExec(() -> this.branchViewer.expandAll());
    }

    @Override
    public void updateUIAfterAuthorization() {
        this.branchViewer.refresh();
    }

    @Override
    public void collectElementOperations(List<Map.Entry<CDOBranch, AuthorizableOperation>> operations) {
        CDOBranchUtil.forEachBranchInTree((CDOBranch)this.rootBranch, b -> {
            boolean bl = operations.add((Map.Entry<CDOBranch, AuthorizableOperation>)new MapEntry(b, (Object)CoreOperations.deleteBranch((int)b.getID())));
        });
    }
}

