/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

abstract class WriteCursorConstantAction
implements ConstantAction,
Formatable {
    long conglomId;
    StaticCompiledOpenConglomInfo heapSCOCI;
    IndexRowGenerator[] irgs;
    long[] indexCIDS;
    StaticCompiledOpenConglomInfo[] indexSCOCIs;
    String[] indexNames;
    boolean deferred;
    private Properties targetProperties;
    UUID targetUUID;
    int lockMode;
    private FKInfo[] fkInfo;
    private TriggerInfo triggerInfo;
    private FormatableBitSet baseRowReadList;
    private int[] baseRowReadMap;
    private int[] streamStorableHeapColIds;
    boolean singleRowSource;
    private boolean underMerge;

    public WriteCursorConstantAction() {
    }

    public WriteCursorConstantAction(long conglomId, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, String[] indexNames, boolean deferred, Properties targetProperties, UUID targetUUID, int lockMode, FKInfo[] fkInfo, TriggerInfo triggerInfo, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableHeapColIds, boolean singleRowSource, boolean underMerge) {
        this.conglomId = conglomId;
        this.heapSCOCI = heapSCOCI;
        this.irgs = irgs;
        this.indexSCOCIs = indexSCOCIs;
        this.indexCIDS = indexCIDS;
        this.indexSCOCIs = indexSCOCIs;
        this.deferred = deferred;
        this.targetProperties = targetProperties;
        this.targetUUID = targetUUID;
        this.lockMode = lockMode;
        this.fkInfo = fkInfo;
        this.triggerInfo = triggerInfo;
        this.baseRowReadList = baseRowReadList;
        this.baseRowReadMap = baseRowReadMap;
        this.streamStorableHeapColIds = streamStorableHeapColIds;
        this.singleRowSource = singleRowSource;
        this.indexNames = indexNames;
        this.underMerge = underMerge;
        if (fkInfo != null) {
            SanityManager.ASSERT(fkInfo.length != 0, "fkinfo array has no elements, if there are no foreign keys, then pass in null");
        }
    }

    final FKInfo[] getFKInfo() {
        return this.fkInfo;
    }

    TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    @Override
    public final void executeConstantAction(Activation activation) throws StandardException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.conglomId = in.readLong();
        this.heapSCOCI = (StaticCompiledOpenConglomInfo)in.readObject();
        this.irgs = new IndexRowGenerator[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.irgs);
        this.indexCIDS = ArrayUtil.readLongArray(in);
        this.indexSCOCIs = new StaticCompiledOpenConglomInfo[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.indexSCOCIs);
        this.deferred = in.readBoolean();
        this.targetProperties = (Properties)in.readObject();
        this.targetUUID = (UUID)in.readObject();
        this.lockMode = in.readInt();
        this.fkInfo = new FKInfo[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.fkInfo);
        this.triggerInfo = (TriggerInfo)in.readObject();
        this.baseRowReadList = (FormatableBitSet)in.readObject();
        this.baseRowReadMap = ArrayUtil.readIntArray(in);
        this.streamStorableHeapColIds = ArrayUtil.readIntArray(in);
        this.singleRowSource = in.readBoolean();
        this.indexNames = ArrayUtil.readStringArray(in);
        this.underMerge = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.conglomId);
        out.writeObject(this.heapSCOCI);
        ArrayUtil.writeArray(out, this.irgs);
        ArrayUtil.writeLongArray(out, this.indexCIDS);
        ArrayUtil.writeArray(out, this.indexSCOCIs);
        out.writeBoolean(this.deferred);
        out.writeObject(this.targetProperties);
        out.writeObject(this.targetUUID);
        out.writeInt(this.lockMode);
        ArrayUtil.writeArray(out, this.fkInfo);
        out.writeObject(this.triggerInfo);
        out.writeObject(this.baseRowReadList);
        ArrayUtil.writeIntArray(out, this.baseRowReadMap);
        ArrayUtil.writeIntArray(out, this.streamStorableHeapColIds);
        out.writeBoolean(this.singleRowSource);
        ArrayUtil.writeArray(out, this.indexNames);
        out.writeBoolean(this.underMerge);
    }

    public boolean underMerge() {
        return this.underMerge;
    }

    public long getConglomerateId() {
        return this.conglomId;
    }

    public Properties getTargetProperties() {
        return this.targetProperties;
    }

    public String getProperty(String key) {
        return this.targetProperties == null ? null : this.targetProperties.getProperty(key);
    }

    public FormatableBitSet getBaseRowReadList() {
        return this.baseRowReadList;
    }

    public int[] getBaseRowReadMap() {
        return this.baseRowReadMap;
    }

    public int[] getStreamStorableHeapColIds() {
        return this.streamStorableHeapColIds;
    }

    public String getIndexNameFromCID(long indexCID) {
        int size = this.indexCIDS.length;
        if (this.indexNames == null) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            if (this.indexCIDS[i] != indexCID) continue;
            return this.indexNames[i];
        }
        return null;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }
}

