/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.assembly.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.etypes.impl.ModelElementImpl;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.assembly.AssemblyPackage;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class AssemblyImpl
extends ModelElementImpl
implements Assembly {
    protected static final String SYSTEM_NAME_EDEFAULT = null;

    protected AssemblyImpl() {
    }

    protected EClass eStaticClass() {
        return AssemblyPackage.Literals.ASSEMBLY;
    }

    protected boolean emfToString() {
        return true;
    }

    @Override
    public String getSystemName() {
        return (String)this.eDynamicGet(1, (EStructuralFeature)AssemblyPackage.Literals.ASSEMBLY__SYSTEM_NAME, true, true);
    }

    @Override
    public void setSystemName(String newSystemName) {
        this.eDynamicSet(1, (EStructuralFeature)AssemblyPackage.Literals.ASSEMBLY__SYSTEM_NAME, newSystemName);
    }

    @Override
    public EList<AssemblyModule> getModules() {
        return (EList)this.eDynamicGet(2, (EStructuralFeature)AssemblyPackage.Literals.ASSEMBLY__MODULES, true, true);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotations()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getModules()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getModules()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotations();
            }
            case 1: {
                return this.getSystemName();
            }
            case 2: {
                return this.getModules();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setSystemName((String)newValue);
                return;
            }
            case 2: {
                this.getModules().clear();
                this.getModules().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotations().clear();
                return;
            }
            case 1: {
                this.setSystemName(SYSTEM_NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getModules().clear();
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.getAnnotations().isEmpty();
            }
            case 1: {
                return SYSTEM_NAME_EDEFAULT == null ? this.getSystemName() != null : !SYSTEM_NAME_EDEFAULT.equals(this.getSystemName());
            }
            case 2: {
                return !this.getModules().isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public AssemblyModule getRootModule() {
        for (AssemblyModule module : this.getModules()) {
            if (!module.isRoot()) continue;
            return module;
        }
        throw new IllegalStateException("No root module: " + String.valueOf(this));
    }

    @Override
    public AssemblyModule getModule(String moduleName) {
        EList<AssemblyModule> modules = this.getModules();
        return AssemblyImpl.getModule(modules, moduleName);
    }

    @Override
    public void forEachDependency(Consumer<AssemblyModule> consumer) {
        for (AssemblyModule module : this.getModules()) {
            if (module.isRoot()) continue;
            consumer.accept(module);
        }
    }

    @Override
    public boolean compareTo(Assembly newAssembly, Assembly.DeltaHandler handler) {
        boolean different = false;
        BasicEList oldModules = new BasicEList(this.getModules());
        for (AssemblyModule oldModule : oldModules) {
            AssemblyModule newModule = newAssembly.getModule(oldModule.getName());
            if (newModule != null) continue;
            different = true;
            handler.handleRemoval(oldModule);
        }
        for (AssemblyModule newModule : newAssembly.getModules()) {
            AssemblyModule oldModule = AssemblyImpl.getModule((EList<AssemblyModule>)oldModules, newModule.getName());
            if (oldModule == null) {
                different = true;
                handler.handleAddition(newModule);
                continue;
            }
            if (oldModule.isRoot() == newModule.isRoot() && Objects.equals(oldModule.getVersion(), newModule.getVersion()) && Objects.equals(oldModule.getBranchPoint(), newModule.getBranchPoint()) && AssemblyImpl.equalLists((List<? extends EObject>)oldModule.getAnnotations(), (List<? extends EObject>)newModule.getAnnotations())) continue;
            different = true;
            handler.handleModification(oldModule, newModule);
        }
        return different;
    }

    private static boolean equalLists(List<? extends EObject> list1, List<? extends EObject> list2) {
        EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper(){
            private static final long serialVersionUID = 1L;

            protected boolean haveEqualReference(EObject eObject1, EObject eObject2, EReference reference) {
                if (reference.isContainer()) {
                    return true;
                }
                return super.haveEqualReference(eObject1, eObject2, reference);
            }
        };
        return equalityHelper.equals(list1, list2);
    }

    private static AssemblyModule getModule(EList<AssemblyModule> modules, String moduleName) {
        for (AssemblyModule module : modules) {
            if (!Objects.equals(module.getName(), moduleName)) continue;
            return module;
        }
        return null;
    }
}

