/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.commit.FailureCommitInfo;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.LockingManager;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.BaseCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.StubCDORevision;
import org.eclipse.emf.cdo.spi.server.ICommitConflictResolver;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalUnitManager;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class TransactionCommitContext
implements InternalCommitContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, TransactionCommitContext.class);
    private static final InternalCDORevision DETACHED = new StubCDORevision(null);
    private static final IRWLockManager.LockType[] ALL_LOCK_TYPES = IRWLockManager.LockType.values();
    private static final Map<String, String> NO_COMMIT_PROPERTIES = Collections.emptyMap();
    private final InternalTransaction transaction;
    private final CDOBranch branch;
    private InternalRepository repository;
    private InternalCDOPackageRegistry repositoryPackageRegistry;
    private boolean packageRegistryLocked;
    private TransactionPackageRegistry packageRegistry;
    private IStoreAccessor accessor;
    private long lastUpdateTime;
    private long lastTreeRestructuringCommit;
    private Boolean treeRestructuring;
    private long timeStamp = 0L;
    private long previousTimeStamp = 0L;
    private int commitNumber;
    private String commitComment;
    private Map<String, String> commitProperties;
    private CDOBranchPoint commitMergeSource;
    private boolean usingEcore;
    private boolean usingEtypes;
    private InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[0];
    private InternalCDORevision[] newObjects = new InternalCDORevision[0];
    private InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[0];
    private CDOID[] detachedObjects = new CDOID[0];
    private Map<CDOID, EClass> detachedObjectTypes;
    private CDOBranchVersion[] detachedObjectVersions;
    private InternalCDORevision[] dirtyObjects = new InternalCDORevision[0];
    private InternalCDORevision[] cachedDetachedRevisions = new InternalCDORevision[0];
    private Map<CDOID, InternalCDORevision> cachedRevisions;
    private Map<CDOID, InternalCDORevision> oldRevisions = CDOIDUtil.createMap();
    private Map<CDOID, InternalCDORevision> newRevisions;
    private CDOProtocol.CommitData originalCommmitData;
    private Map<CDOID, CDOID> idMappings = CDOIDUtil.createMap();
    private CDOReferenceAdjuster idMapper = new CDOIDMapper(this.idMappings);
    private byte rollbackReason = 0;
    private String rollbackMessage;
    private List<CDOIDReference> xRefs;
    private boolean hasChanges;
    private boolean serializingCommits;
    private boolean ensuringReferentialIntegrity;
    private ExtendedDataInputStream lobs;
    private long optimisticLockingTimeout;
    private InternalLockManager lockManager;
    private Set<Object> lockedObjects = new HashSet<Object>();
    private List<CDOID> lockedTargets;
    private CDOLockState[] locksOnNewObjects = CDOLockUtil.NO_LOCK_STATES;
    private CDOID[] idsToUnlock = new CDOID[0];
    private final LockingManager.LockDeltaCollector lockDeltas = new LockingManager.LockDeltaCollector();
    private final LockingManager.LockStateCollector lockStates = new LockingManager.LockStateCollector();
    private CDOLockChangeInfo lockChangeInfo;
    private Map<Object, Object> data;
    private CDOProtocol.CommitNotificationInfo commitNotificationInfo = new CDOProtocol.CommitNotificationInfo();
    private boolean allowModify;

    public TransactionCommitContext(InternalTransaction transaction) {
        this.transaction = transaction;
        this.branch = transaction.getBranch();
        this.repository = transaction.getRepository();
        this.lockManager = this.repository.getLockingManager();
        this.serializingCommits = this.repository.isSerializingCommits();
        this.ensuringReferentialIntegrity = this.repository.isEnsuringReferentialIntegrity();
        this.repositoryPackageRegistry = this.repository.getPackageRegistry(false);
    }

    @Override
    public InternalTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public CDOBranchPoint getBranchPoint() {
        return this.branch.getPoint(this.timeStamp);
    }

    @Override
    public String getUserID() {
        return this.transaction.getSession().getUserID();
    }

    public int getCommitNumber() {
        return this.commitNumber;
    }

    @Override
    public String getCommitComment() {
        return this.commitComment;
    }

    @Override
    public Map<String, String> getCommitProperties() {
        return this.commitProperties == null ? NO_COMMIT_PROPERTIES : this.commitProperties;
    }

    @Override
    public CDOBranchPoint getCommitMergeSource() {
        return this.commitMergeSource;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public byte getRollbackReason() {
        return this.rollbackReason;
    }

    @Override
    public String getRollbackMessage() {
        return this.rollbackMessage;
    }

    @Override
    public List<CDOIDReference> getXRefs() {
        return this.xRefs;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        if (this.packageRegistry == null) {
            this.packageRegistry = new TransactionPackageRegistry(this.repositoryPackageRegistry);
            this.packageRegistry.activate();
        }
        return this.packageRegistry;
    }

    @Override
    public boolean isClearResourcePathCache() {
        return this.commitNotificationInfo.isClearResourcePathCache();
    }

    @Override
    public byte getSecurityImpact() {
        return this.commitNotificationInfo.getSecurityImpact();
    }

    @Override
    public boolean isUsingEcore() {
        return this.usingEcore;
    }

    @Override
    public boolean isUsingEtypes() {
        return this.usingEtypes;
    }

    @Override
    public InternalCDOPackageUnit[] getNewPackageUnits() {
        return this.newPackageUnits;
    }

    @Override
    public InternalCDORevision[] getNewObjects() {
        return this.newObjects;
    }

    @Override
    public InternalCDORevision[] getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    public CDOID[] getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public Map<CDOID, EClass> getDetachedObjectTypes() {
        return this.detachedObjectTypes;
    }

    @Override
    public CDOBranchVersion[] getDetachedObjectVersions() {
        return this.detachedObjectVersions;
    }

    @Override
    public InternalCDORevision[] getDetachedRevisions() {
        return this.getDetachedRevisions(true);
    }

    @Override
    public InternalCDORevision[] getDetachedRevisions(boolean check) {
        if (check) {
            InternalCDORevision[] internalCDORevisionArray = this.cachedDetachedRevisions;
            int n = this.cachedDetachedRevisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision cachedDetachedRevision = internalCDORevisionArray[n2];
                if (cachedDetachedRevision == null) {
                    throw new AssertionError((Object)"Detached revisions are incomplete");
                }
                ++n2;
            }
        }
        return this.cachedDetachedRevisions;
    }

    @Override
    public InternalCDORevisionDelta[] getDirtyObjectDeltas() {
        return this.dirtyObjectDeltas;
    }

    @Override
    public Map<CDOID, InternalCDORevision> getOldRevisions() {
        return this.oldRevisions;
    }

    @Override
    public Map<CDOID, InternalCDORevision> getNewRevisions() {
        if (this.newRevisions == null) {
            this.newRevisions = CDOIDUtil.createMap();
            int i = 0;
            while (i < this.newObjects.length) {
                InternalCDORevision revision = this.newObjects[i];
                this.newRevisions.put(revision.getID(), revision);
                ++i;
            }
        }
        return this.newRevisions;
    }

    @Override
    public CDOProtocol.CommitData getOriginalCommmitData() {
        return this.originalCommmitData;
    }

    public InternalCDORevision getRevision(CDOID id) {
        InternalCDORevision revision;
        if (this.cachedRevisions == null) {
            this.cachedRevisions = this.cacheRevisions();
        }
        if ((revision = this.cachedRevisions.get(id)) == DETACHED) {
            return null;
        }
        if (revision != null) {
            return revision;
        }
        return (InternalCDORevision)this.transaction.getRevision(id);
    }

    protected Map<CDOID, InternalCDORevision> cacheRevisions() {
        InternalCDORevision revision;
        int i;
        Map cache = CDOIDUtil.createMap();
        if (this.newObjects != null) {
            i = 0;
            while (i < this.newObjects.length) {
                revision = this.newObjects[i];
                cache.put(revision.getID(), revision);
                ++i;
            }
        }
        if (this.dirtyObjects != null) {
            i = 0;
            while (i < this.dirtyObjects.length) {
                revision = this.dirtyObjects[i];
                cache.put(revision.getID(), revision);
                ++i;
            }
        }
        if (this.detachedObjects != null) {
            i = 0;
            while (i < this.detachedObjects.length) {
                cache.put(this.detachedObjects[i], DETACHED);
                ++i;
            }
        }
        return cache;
    }

    @Override
    public Map<CDOID, CDOID> getIDMappings() {
        return Collections.unmodifiableMap(this.idMappings);
    }

    @Override
    public void addIDMapping(CDOID oldID, CDOID newID) {
        if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
            throw new IllegalStateException("newID=" + newID);
        }
        CDOID previousMapping = this.idMappings.put(oldID, newID);
        if (previousMapping != null && previousMapping != newID) {
            throw new IllegalStateException("previousMapping != null && previousMapping != newID");
        }
    }

    @Override
    public void applyIDMappings(OMMonitor monitor) {
        boolean mapIDs = !this.idMappings.isEmpty();
        monitor.begin((double)(1 + (mapIDs ? this.newObjects.length + this.dirtyObjects.length + this.dirtyObjectDeltas.length : 0)));
        try {
            if (mapIDs) {
                this.applyIDMappings(this.newObjects, monitor.fork((double)this.newObjects.length));
                this.applyIDMappings(this.dirtyObjects, monitor.fork((double)this.dirtyObjects.length));
                InternalCDORevisionDelta[] internalCDORevisionDeltaArray = this.dirtyObjectDeltas;
                int n = this.dirtyObjectDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDORevisionDelta dirtyObjectDelta = internalCDORevisionDeltaArray[n2];
                    dirtyObjectDelta.adjustReferences(this.idMapper);
                    monitor.worked();
                    ++n2;
                }
            }
            this.notifyBeforeCommitting(monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void applyIDMappings(InternalCDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                if (revision != null) {
                    CDOID newID = this.idMappings.get(revision.getID());
                    if (newID != null) {
                        revision.setID(newID);
                    }
                    revision.adjustReferences(this.idMapper);
                    monitor.worked();
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void notifyBeforeCommitting(OMMonitor monitor) {
        try {
            this.allowModify = true;
            this.repository.notifyWriteAccessHandlers(this.transaction, this, true, monitor.fork());
        }
        finally {
            this.allowModify = false;
        }
    }

    @Override
    public void preWrite() {
        this.accessor = this.repository.getStore().getWriter(this.transaction);
        StoreThreadLocal.setAccessor(this.accessor);
        StoreThreadLocal.setCommitContext(this);
    }

    @Override
    public boolean isTreeRestructuring() {
        if (this.treeRestructuring == null) {
            this.treeRestructuring = CDORevisionUtil.isTreeRestructuring((InternalCDORevisionDelta[])this.dirtyObjectDeltas);
        }
        return this.treeRestructuring;
    }

    @Override
    public void setLastTreeRestructuringCommit(long lastTreeRestructuringCommit) {
        this.lastTreeRestructuringCommit = lastTreeRestructuringCommit;
    }

    @Override
    public void setClearResourcePathCache(boolean clearResourcePathCache) {
        this.commitNotificationInfo.setClearResourcePathCache(clearResourcePathCache);
    }

    @Override
    public void setSecurityImpact(byte securityImpact, Set<? extends Object> impactedRules) {
        this.commitNotificationInfo.setSecurityImpact(securityImpact);
        this.commitNotificationInfo.setImpactedRules(impactedRules);
    }

    @Override
    public void setUsingEcore(boolean usingEcore) {
        this.usingEcore = usingEcore;
    }

    @Override
    public void setUsingEtypes(boolean usingEtypes) {
        this.usingEtypes = usingEtypes;
    }

    @Override
    public void setNewPackageUnits(InternalCDOPackageUnit[] newPackageUnits) {
        this.newPackageUnits = newPackageUnits;
    }

    @Override
    public void setNewObjects(InternalCDORevision[] newObjects) {
        this.newObjects = newObjects;
    }

    @Override
    public void setDirtyObjectDeltas(InternalCDORevisionDelta[] dirtyObjectDeltas) {
        this.dirtyObjectDeltas = dirtyObjectDeltas;
    }

    @Override
    public void setDetachedObjects(CDOID[] detachedObjects) {
        this.detachedObjects = detachedObjects;
    }

    @Override
    public void setDetachedObjectTypes(Map<CDOID, EClass> detachedObjectTypes) {
        this.detachedObjectTypes = detachedObjectTypes;
    }

    @Override
    public void setDetachedObjectVersions(CDOBranchVersion[] detachedObjectVersions) {
        this.detachedObjectVersions = detachedObjectVersions;
    }

    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public void setOptimisticLockingTimeout(long optimisticLockingTimeout) {
        this.optimisticLockingTimeout = optimisticLockingTimeout;
    }

    @Override
    public void setCommitNumber(int commitNumber) {
        this.commitNumber = commitNumber;
    }

    @Override
    public void setCommitComment(String commitComment) {
        this.commitComment = commitComment;
    }

    @Override
    public void setCommitProperties(Map<String, String> commitProperties) {
        this.commitProperties = commitProperties;
    }

    @Override
    public void setCommitMergeSource(CDOBranchPoint commitMergeSource) {
        this.commitMergeSource = commitMergeSource;
    }

    @Override
    public ExtendedDataInputStream getLobs() {
        return this.lobs;
    }

    @Override
    public void setLobs(ExtendedDataInputStream in) {
        this.lobs = in;
    }

    @Override
    public CDOLockState[] getLocksOnNewObjects() {
        return this.locksOnNewObjects;
    }

    @Override
    public void setLocksOnNewObjects(CDOLockState[] locksOnNewObjects) {
        this.locksOnNewObjects = locksOnNewObjects;
    }

    @Override
    public CDOID[] getIDsToUnlock() {
        return this.idsToUnlock;
    }

    @Override
    public void setIDsToUnlock(CDOID[] idsToUnlock) {
        this.idsToUnlock = idsToUnlock;
    }

    @Override
    public <T> T getData(Object key) {
        if (this.data == null) {
            return null;
        }
        Object result = this.data.get(key);
        return (T)result;
    }

    @Override
    public synchronized <T> T setData(Object key, T value) {
        if (this.data == null) {
            this.data = new HashMap<Object, Object>();
        }
        Object old = this.data.put(key, value);
        return (T)old;
    }

    protected InternalCDOPackageUnit[] lockPackageRegistry(InternalCDOPackageUnit[] packageUnits) throws InterruptedException {
        if (!this.packageRegistryLocked) {
            this.repository.getPackageRegistryCommitLock().acquire();
            this.packageRegistryLocked = true;
        }
        ArrayList<InternalCDOPackageUnit> noDuplicates = new ArrayList<InternalCDOPackageUnit>();
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            String id = packageUnit.getID();
            if (!this.repositoryPackageRegistry.containsKey((Object)id)) {
                noDuplicates.add(packageUnit);
            }
            ++n2;
        }
        int newSize = noDuplicates.size();
        if (packageUnits.length != newSize) {
            return noDuplicates.toArray(new InternalCDOPackageUnit[newSize]);
        }
        return packageUnits;
    }

    @Override
    public void write(OMMonitor monitor) {
        try {
            monitor.begin(106.0);
            boolean bl = this.hasChanges = this.newPackageUnits.length != 0 || this.newObjects.length != 0 || this.dirtyObjectDeltas.length != 0;
            if (!this.hasChanges) {
                return;
            }
            try {
                this.dirtyObjects = new InternalCDORevision[this.dirtyObjectDeltas.length];
                if (this.newPackageUnits.length != 0) {
                    this.newPackageUnits = this.lockPackageRegistry(this.newPackageUnits);
                }
                this.lockObjects();
                monitor.worked();
                this.setTimeStamp(monitor.fork());
                this.adjustForCommit();
                monitor.worked();
                this.computeDirtyObjects(monitor.fork());
                this.checkContainmentCycles();
                this.checkXRefs();
                this.checkUnitMoves();
                monitor.worked();
                this.detachObjects(monitor.fork());
                this.writeAccessor(monitor.fork(100.0));
            }
            catch (RollbackException ex) {
                this.rollbackReason = ex.getRollbackReason();
                this.rollback(ex.getRollbackMessage());
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
        finally {
            this.finishMonitor(monitor);
        }
    }

    @Override
    public void commit(OMMonitor monitor) {
        try {
            try {
                monitor.begin(101.0);
                if (this.hasChanges) {
                    this.accessor.commit(monitor.fork(100.0));
                } else {
                    monitor.worked(100.0);
                }
                this.updateInfraStructure(monitor.fork());
                if (this.hasChanges) {
                    this.repository.endCommit(this.timeStamp);
                }
            }
            catch (Throwable ex) {
                this.handleException(ex);
                this.finishMonitor(monitor);
            }
        }
        finally {
            this.finishMonitor(monitor);
        }
    }

    protected void handleException(Throwable throwable) {
        try {
            if (throwable instanceof IRepository.WriteAccessHandler.TransactionValidationException) {
                if (TRACER.isEnabled()) {
                    TRACER.trace(throwable);
                }
                this.rollbackReason = (byte)5;
                this.rollback(throwable.getLocalizedMessage());
            } else {
                OM.LOG.error(throwable);
                String storeClass = this.repository.getStore().getClass().getSimpleName();
                this.rollback("Rollback in " + storeClass + ": " + StringUtil.formatException((Throwable)throwable));
            }
        }
        catch (Exception ex) {
            if (this.rollbackMessage == null) {
                this.rollbackMessage = ex.getMessage();
            }
            try {
                if (TRACER.isEnabled()) {
                    TRACER.trace((Throwable)ex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finishMonitor(OMMonitor monitor) {
        try {
            monitor.done();
        }
        catch (Exception ex) {
            try {
                OM.LOG.warn((Throwable)ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setTimeStamp(OMMonitor monitor) {
        long[] times = this.createTimeStamp(monitor);
        this.timeStamp = times[0];
        this.previousTimeStamp = times[1];
        CheckUtil.checkState((this.timeStamp != 0L ? 1 : 0) != 0, (String)"Commit timestamp must not be 0");
        this.transaction.setLastCommitAttempt(new InternalTransaction.CommitAttempt(this.commitNumber, this.timeStamp, this.previousTimeStamp));
    }

    protected long[] createTimeStamp(OMMonitor monitor) {
        return this.repository.createCommitTimeStamp(monitor);
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getPreviousTimeStamp() {
        return this.previousTimeStamp;
    }

    @Override
    public List<CDOLockDelta> getLockDeltas() {
        return this.lockDeltas;
    }

    @Override
    public List<CDOLockState> getLockStates() {
        return this.lockStates;
    }

    @Override
    public void postCommit(boolean success) {
        try {
            if (this.packageRegistryLocked) {
                this.repository.getPackageRegistryCommitLock().release();
            }
        }
        catch (Throwable ex) {
            OM.LOG.warn("A problem occured while releasing the package registry commit lock", ex);
        }
        try {
            try {
                if (this.timeStamp != 0L || this.lockChangeInfo != null) {
                    this.sendCommitNotifications(success);
                }
            }
            catch (Throwable ex) {
                OM.LOG.warn("A problem occured while notifying other sessions", ex);
                StoreThreadLocal.release();
                this.accessor = null;
                this.lockedTargets = null;
                if (this.packageRegistry != null) {
                    this.packageRegistry.deactivate();
                    this.packageRegistry = null;
                }
            }
        }
        finally {
            StoreThreadLocal.release();
            this.accessor = null;
            this.lockedTargets = null;
            if (this.packageRegistry != null) {
                this.packageRegistry.deactivate();
                this.packageRegistry = null;
            }
        }
    }

    protected void sendCommitNotifications(boolean success) {
        this.commitNotificationInfo.setSender((CDOCommonSession)this.transaction.getSession());
        this.commitNotificationInfo.setModifiedByServer(this.originalCommmitData != null);
        this.commitNotificationInfo.setRevisionProvider((CDORevisionProvider)this);
        this.commitNotificationInfo.setLockChangeInfo(this.lockChangeInfo);
        if (success) {
            this.commitNotificationInfo.setCommitInfo(this.createCommitInfo());
        } else {
            this.commitNotificationInfo.setCommitInfo(this.createFailureCommitInfo());
        }
        this.repository.sendCommitNotification(this.commitNotificationInfo);
    }

    @Override
    public CDOCommitInfo createCommitInfo() {
        String userID = this.transaction.getSession().getUserID();
        CDOCommitData commitData = this.createCommitData();
        InternalCDOCommitInfoManager commitInfoManager = this.repository.getCommitInfoManager();
        return commitInfoManager.createCommitInfo(this.branch, this.timeStamp, this.previousTimeStamp, userID, this.commitComment, this.commitMergeSource, commitData);
    }

    public CDOCommitInfo createFailureCommitInfo() {
        InternalCDOCommitInfoManager commitInfoManager = this.repository.getCommitInfoManager();
        return new FailureCommitInfo(commitInfoManager, this.timeStamp, this.previousTimeStamp);
    }

    protected CDOCommitData createCommitData() {
        IndexedList.ArrayBacked<CDOPackageUnit> newPackageUnitsCollection = new IndexedList.ArrayBacked<CDOPackageUnit>(){

            protected CDOPackageUnit[] getArray() {
                return TransactionCommitContext.this.newPackageUnits;
            }
        };
        IndexedList.ArrayBacked<CDOIDAndVersion> newObjectsCollection = new IndexedList.ArrayBacked<CDOIDAndVersion>(){

            protected CDOIDAndVersion[] getArray() {
                return TransactionCommitContext.this.newObjects;
            }
        };
        IndexedList.ArrayBacked<CDORevisionKey> changedObjectsCollection = new IndexedList.ArrayBacked<CDORevisionKey>(){

            protected CDORevisionKey[] getArray() {
                return TransactionCommitContext.this.dirtyObjectDeltas;
            }
        };
        IndexedList<CDOIDAndVersion> detachedObjectsCollection = new IndexedList<CDOIDAndVersion>(){

            public CDOIDAndVersion get(int i) {
                if (TransactionCommitContext.this.cachedDetachedRevisions[i] != null) {
                    return TransactionCommitContext.this.cachedDetachedRevisions[i];
                }
                return CDOIDUtil.createIDAndVersion((CDOID)TransactionCommitContext.this.detachedObjects[i], (int)0);
            }

            public int size() {
                return TransactionCommitContext.this.detachedObjects.length;
            }
        };
        return CDOCommitInfoUtil.createCommitData((List)newPackageUnitsCollection, (List)newObjectsCollection, (List)changedObjectsCollection, (List)detachedObjectsCollection);
    }

    protected void adjustForCommit() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
        int n = this.newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
            newPackageUnit.setTimeStamp(this.timeStamp);
            ++n2;
        }
        internalCDOPackageUnitArray = this.newObjects;
        n = this.newObjects.length;
        n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newObject = internalCDOPackageUnitArray[n2];
            newObject.adjustForCommit(this.branch, this.timeStamp);
            ++n2;
        }
    }

    protected void lockObjects() throws InterruptedException {
        block14: {
            this.lockedObjects.clear();
            this.lockedTargets = null;
            try {
                CDOFeatureDeltaVisitorImpl deltaTargetLocker = null;
                if (this.ensuringReferentialIntegrity && !this.serializingCommits) {
                    final HashSet<CDOID> newIDs = new HashSet<CDOID>();
                    int i = 0;
                    while (i < this.newObjects.length) {
                        InternalCDORevision newRevision = this.newObjects[i];
                        CDOID newID = newRevision.getID();
                        if (newID instanceof CDOIDObject) {
                            newIDs.add(newID);
                        }
                        ++i;
                    }
                    final boolean supportingBranches = this.repository.isSupportingBranches();
                    deltaTargetLocker = new CDOFeatureDeltaVisitorImpl(){

                        public void visit(CDOAddFeatureDelta delta) {
                            TransactionCommitContext.this.lockTarget(delta.getValue(), newIDs, supportingBranches);
                        }

                        public void visit(CDOSetFeatureDelta delta) {
                            TransactionCommitContext.this.lockTarget(delta.getValue(), newIDs, supportingBranches);
                        }
                    };
                    CDOReferenceAdjuster revisionTargetLocker = new CDOReferenceAdjuster(){

                        public Object adjustReference(Object value, EStructuralFeature feature, int index) {
                            TransactionCommitContext.this.lockTarget(value, newIDs, supportingBranches);
                            return value;
                        }
                    };
                    int i2 = 0;
                    while (i2 < this.newObjects.length) {
                        InternalCDORevision newRevision = this.newObjects[i2];
                        newRevision.adjustReferences(revisionTargetLocker);
                        ++i2;
                    }
                }
                int i = 0;
                while (i < this.dirtyObjectDeltas.length) {
                    InternalCDORevisionDelta delta = this.dirtyObjectDeltas[i];
                    CDOID id = delta.getID();
                    Object key = this.lockManager.getLockKey(id, this.branch);
                    this.lockedObjects.add(key);
                    ++i;
                }
                if (deltaTargetLocker != null) {
                    i = 0;
                    while (i < this.dirtyObjectDeltas.length) {
                        InternalCDORevisionDelta delta = this.dirtyObjectDeltas[i];
                        delta.accept((CDOFeatureDeltaVisitor)deltaTargetLocker);
                        ++i;
                    }
                }
                i = 0;
                while (i < this.detachedObjects.length) {
                    CDOID id = this.detachedObjects[i];
                    Object key = this.lockManager.getLockKey(id, this.branch);
                    this.lockedObjects.add(key);
                    ++i;
                }
                if (this.lockedObjects.isEmpty()) break block14;
                try {
                    long timeout = this.optimisticLockingTimeout == -2L ? this.repository.getOptimisticLockingTimeout() : this.optimisticLockingTimeout;
                    this.lockManager.lock(this.transaction, this.lockedObjects, IRWLockManager.LockType.WRITE, 1, timeout, false, false, null, null);
                }
                catch (Exception ex) {
                    throw new RollbackException(1, (Throwable)ex);
                }
                if (this.lockedTargets != null) {
                    for (CDOID id : this.lockedTargets) {
                        CDORevision revision = this.transaction.getRevision(id);
                        if (revision != null && !(revision instanceof DetachedCDORevision)) continue;
                        throw new RollbackException(4, "Attempt by " + this.transaction + " to introduce a stale reference");
                    }
                }
            }
            catch (RuntimeException ex) {
                this.lockedObjects.clear();
                this.lockedTargets = null;
                throw ex;
            }
        }
    }

    protected void lockTarget(Object value, Set<CDOID> newIDs, boolean supportingBranches) {
        if (value instanceof CDOIDObject) {
            CDOIDObject id = (CDOIDObject)value;
            if (id.isNull()) {
                return;
            }
            if (newIDs.contains(id)) {
                return;
            }
            if (this.detachedObjectTypes != null && this.detachedObjectTypes.containsKey(id)) {
                throw new IllegalStateException("This commit deletes object " + id + " and adds a reference at the same time");
            }
            Object key = this.lockManager.getLockKey((CDOID)id, this.branch);
            this.lockedObjects.add(key);
            if (this.lockedTargets == null) {
                this.lockedTargets = new ArrayList<CDOID>();
            }
            this.lockedTargets.add((CDOID)id);
        }
    }

    protected void computeDirtyObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.dirtyObjectDeltas.length);
            ArrayList<InternalCDORevisionDelta> conflicts = new ArrayList<InternalCDORevisionDelta>();
            int i = 0;
            while (i < this.dirtyObjectDeltas.length) {
                InternalCDORevision newRevision = this.computeDirtyObject(this.dirtyObjectDeltas[i]);
                if (newRevision == null) {
                    conflicts.add(this.dirtyObjectDeltas[i]);
                } else if (!newRevision.isWritable()) {
                    throw new NoPermissionException((Object)newRevision, Boolean.valueOf(true));
                }
                this.dirtyObjects[i] = newRevision;
                monitor.worked();
                ++i;
            }
            if (!conflicts.isEmpty()) {
                this.dirtyObjects = new InternalCDORevision[this.dirtyObjectDeltas.length];
                this.mergeConflicts(conflicts);
            }
            if (!conflicts.isEmpty()) {
                throw new RollbackException(2, "Attempt by " + this.transaction + " to modify historical revisions: " + conflicts);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected InternalCDORevision computeDirtyObject(InternalCDORevisionDelta delta) {
        InternalCDORevision oldRevision;
        block6: {
            CDOID id = delta.getID();
            oldRevision = (InternalCDORevision)this.transaction.getRevision(id);
            if (oldRevision == null) {
                throw new RollbackException(0, "Revision " + id + " not found by " + this.transaction);
            }
            this.repository.ensureChunks(oldRevision, -1);
            this.oldRevisions.put(id, oldRevision);
            if (oldRevision.getBranch() == delta.getBranch() && oldRevision.getVersion() == delta.getVersion()) break block6;
            return null;
        }
        try {
            InternalCDORevision newRevision = oldRevision.copy();
            newRevision.adjustForCommit(this.branch, this.timeStamp);
            delta.applyTo((CDORevision)newRevision);
            return newRevision;
        }
        catch (RollbackException ex) {
            throw ex;
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            String rollbackMessage = ex.getMessage();
            if (rollbackMessage == null) {
                rollbackMessage = ex.getClass().getName();
            }
            throw new RollbackException(0, rollbackMessage);
        }
    }

    @Override
    public void modify(Consumer<IStoreAccessor.CommitContext.ModificationContext> modifier) {
        InternalCDORevision copy;
        int n;
        if (!this.allowModify) {
            throw new UnsupportedOperationException("Commit modification not allowed");
        }
        ArrayList<InternalCDORevision> _newObjects = new ArrayList<InternalCDORevision>();
        if (this.newObjects != null) {
            InternalCDORevision[] internalCDORevisionArray = this.newObjects;
            n = this.newObjects.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                copy = revision.copy();
                if (copy instanceof BaseCDORevision) {
                    ((BaseCDORevision)copy).unfreeze();
                }
                _newObjects.add(copy);
                ++n2;
            }
        }
        ArrayList<CDORevisionDelta> _changedObjects = new ArrayList<CDORevisionDelta>();
        if (this.dirtyObjectDeltas != null) {
            copy = this.dirtyObjectDeltas;
            int n3 = ((InternalCDORevisionDelta[])copy).length;
            n = 0;
            while (n < n3) {
                InternalCDORevision revisionDelta = copy[n];
                _changedObjects.add(revisionDelta.copy());
                ++n;
            }
        }
        ArrayList<CDOIDAndVersion> _detachedObjects = new ArrayList<CDOIDAndVersion>();
        if (this.detachedObjects != null) {
            int i = 0;
            while (i < this.detachedObjects.length) {
                CDOID id = this.detachedObjects[i];
                CDOBranchVersion branchVersion = this.detachedObjectVersions[i];
                _detachedObjects.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)branchVersion.getVersion()));
                ++i;
            }
        }
        final CDOChangeSetData changeSetData = CDORevisionUtil.createChangeSetData(_newObjects, _changedObjects, _detachedObjects);
        final AtomicBoolean canceled = new AtomicBoolean();
        IStoreAccessor.CommitContext.ModificationContext modificationContext = new IStoreAccessor.CommitContext.ModificationContext(){

            @Override
            public CDOChangeSetData getChangeSetData() {
                return changeSetData;
            }

            @Override
            public void cancelModification() {
                canceled.set(true);
            }
        };
        modifier.accept(modificationContext);
        if (!canceled.get()) {
            this.overrideCommitData(changeSetData, true);
        }
    }

    protected void mergeConflicts(List<InternalCDORevisionDelta> conflicts) {
        CDOChangeSetData result;
        ICommitConflictResolver commitConflictResolver = this.repository.getCommitConflictResolver();
        if (commitConflictResolver != null && (result = commitConflictResolver.resolveConflicts(this, conflicts)) != null) {
            this.overrideCommitData(result, false);
        }
    }

    protected void overrideCommitData(CDOChangeSetData newChangeSetData, boolean force) {
        if (this.originalCommmitData == null) {
            this.originalCommmitData = new CDOProtocol.CommitData(this.newObjects, this.dirtyObjectDeltas, this.detachedObjects);
        }
        ArrayList<InternalCDORevision> newObjectsList = new ArrayList<InternalCDORevision>();
        List idAndVersions = newChangeSetData.getNewObjects();
        if (idAndVersions != null) {
            for (CDOIDAndVersion idAndVersion : idAndVersions) {
                if (!(idAndVersion instanceof InternalCDORevision)) continue;
                InternalCDORevision newObject = (InternalCDORevision)idAndVersion;
                if (!force && !newObject.getID().isTemporary()) continue;
                newObjectsList.add(newObject);
            }
        }
        this.newObjects = newObjectsList.toArray(new InternalCDORevision[newObjectsList.size()]);
        ArrayList<CDOID> detachedObjectsList = new ArrayList<CDOID>();
        ArrayList<CDOBranchVersion> detachedObjectVersionsList = new ArrayList<CDOBranchVersion>();
        this.detachedObjectTypes = new HashMap<CDOID, EClass>();
        List idAndVersions2 = newChangeSetData.getDetachedObjects();
        if (idAndVersions2 != null) {
            for (CDOIDAndVersion idAndVersion : idAndVersions2) {
                CDOID id = idAndVersion.getID();
                InternalCDORevision oldObject = (InternalCDORevision)this.transaction.getRevision(id);
                if (oldObject == null) continue;
                detachedObjectsList.add(id);
                detachedObjectVersionsList.add(oldObject.getBranch().getVersion(oldObject.getVersion()));
                this.detachedObjectTypes.put(id, oldObject.getEClass());
            }
        }
        this.detachedObjects = detachedObjectsList.toArray(new CDOID[detachedObjectsList.size()]);
        this.detachedObjectVersions = detachedObjectVersionsList.toArray(new CDOBranchVersion[detachedObjectVersionsList.size()]);
        ArrayList<InternalCDORevisionDelta> dirtyObjectDeltasList = new ArrayList<InternalCDORevisionDelta>();
        ArrayList<InternalCDORevision> dirtyObjectsList = new ArrayList<InternalCDORevision>();
        InternalCDORevisionManager revisionManager = this.repository.getRevisionManager();
        List revisionKeys = newChangeSetData.getChangedObjects();
        if (revisionKeys != null) {
            for (CDORevisionKey revisionKey : revisionKeys) {
                if (!(revisionKey instanceof InternalCDORevisionDelta)) continue;
                InternalCDORevisionDelta ancestorDelta = (InternalCDORevisionDelta)revisionKey;
                CDOID id = ancestorDelta.getID();
                InternalCDORevision ancestorRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)ancestorDelta, -1, true);
                InternalCDORevision newRevision = ancestorRevision.copy();
                ancestorDelta.applyTo((CDORevision)newRevision);
                InternalCDORevision oldRevision = (InternalCDORevision)this.transaction.getRevision(id);
                newRevision.setVersion(oldRevision.getVersion());
                newRevision.adjustForCommit(this.branch, this.timeStamp);
                InternalCDORevisionDelta dirtyObjectDelta = newRevision.compare((CDORevision)oldRevision);
                dirtyObjectDeltasList.add(dirtyObjectDelta);
                dirtyObjectsList.add(newRevision);
            }
        }
        this.dirtyObjectDeltas = dirtyObjectDeltasList.toArray(new InternalCDORevisionDelta[dirtyObjectDeltasList.size()]);
        this.dirtyObjects = dirtyObjectsList.toArray(new InternalCDORevision[dirtyObjectsList.size()]);
    }

    protected void checkContainmentCycles() {
        if (this.lastTreeRestructuringCommit == 0L) {
            return;
        }
        if (this.lastUpdateTime == 0L) {
            return;
        }
        if (this.lastTreeRestructuringCommit <= this.lastUpdateTime) {
            return;
        }
        HashSet<CDOID> objectsThatReachTheRoot = new HashSet<CDOID>();
        int i = 0;
        while (i < this.dirtyObjectDeltas.length) {
            InternalCDORevision revision;
            InternalCDORevisionDelta revisionDelta = this.dirtyObjectDeltas[i];
            CDOFeatureDelta containerDelta = revisionDelta.getFeatureDelta((EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE);
            if (containerDelta != null && !this.isTheRootReachable(revision = this.dirtyObjects[i], objectsThatReachTheRoot, new HashSet<CDOID>())) {
                throw new RollbackException(3, "Attempt by " + this.transaction + " to introduce a containment cycle");
            }
            ++i;
        }
    }

    protected boolean isTheRootReachable(InternalCDORevision revision, Set<CDOID> objectsThatReachTheRoot, Set<CDOID> visited) {
        CDOID id = revision.getID();
        if (!visited.add(id)) {
            return false;
        }
        if (!objectsThatReachTheRoot.add(id)) {
            return true;
        }
        CDOID containerID = (CDOID)revision.getContainerID();
        if (CDOIDUtil.isNull((CDOID)containerID)) {
            return true;
        }
        InternalCDORevision containerRevision = this.getRevision(containerID);
        return this.isTheRootReachable(containerRevision, objectsThatReachTheRoot, visited);
    }

    protected void checkXRefs() {
        if (this.ensuringReferentialIntegrity && this.detachedObjectTypes != null) {
            XRefContext context = new XRefContext();
            this.xRefs = context.getXRefs(this.accessor);
            if (!this.xRefs.isEmpty()) {
                throw new RollbackException(4, "Attempt by " + this.transaction + " to introduce a stale reference");
            }
        }
    }

    protected void checkUnitMoves() {
        InternalUnitManager unitManager;
        List<InternalCDORevisionDelta> unitMoves;
        String checkUnitMoves;
        if (this.repository.isSupportingUnits() && this.isTreeRestructuring() && "true".equalsIgnoreCase(checkUnitMoves = this.repository.getProperties().get("checkUnitMoves")) && !(unitMoves = (unitManager = this.repository.getUnitManager()).getUnitMoves(this.dirtyObjectDeltas, (CDORevisionProvider)this.transaction, this)).isEmpty()) {
            StringBuilder builder = new StringBuilder("Attempt by " + this.transaction + " to move objects between units: ");
            CDOIDUtil.write((StringBuilder)builder, unitMoves);
            throw new RollbackException(6, builder.toString());
        }
    }

    @Override
    public synchronized void rollback(String message) {
        if (this.rollbackMessage == null) {
            block7: {
                this.rollbackMessage = message;
                if (this.accessor != null) {
                    try {
                        try {
                            this.accessor.rollback();
                        }
                        catch (RuntimeException ex) {
                            OM.LOG.warn("Problem while rolling back the transaction", (Throwable)ex);
                            this.repository.failCommit(this.timeStamp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        this.repository.failCommit(this.timeStamp);
                        throw throwable;
                    }
                    this.repository.failCommit(this.timeStamp);
                }
            }
            this.releaseImplicitLocks();
        }
    }

    @Override
    public IStoreAccessor getAccessor() {
        return this.accessor;
    }

    protected void updateInfraStructure(OMMonitor monitor) {
        try {
            try {
                monitor.begin(9.0);
                this.addNewPackageUnits(monitor.fork());
                this.addRevisions((CDORevision[])this.newObjects, monitor.fork());
                this.addRevisions((CDORevision[])this.dirtyObjects, monitor.fork());
                this.reviseDetachedObjects(monitor.fork());
                InternalCDOCommitInfoManager commitInfoManager = this.repository.getCommitInfoManager();
                commitInfoManager.setLastCommitOfBranch(this.branch, this.timeStamp);
                this.releaseImplicitLocks();
                monitor.worked();
                CDOLockOwner lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this.transaction);
                this.acquireLocksOnNewObjects(lockOwner);
                monitor.worked();
                this.autoReleaseExplicitLocks(lockOwner);
                monitor.worked();
                if (!this.lockDeltas.isEmpty()) {
                    CDOBranchPoint branchPoint = this.getBranchPoint();
                    this.lockChangeInfo = CDOLockUtil.createLockChangeInfo((CDOBranchPoint)branchPoint, (CDOLockOwner)lockOwner, (Collection)this.lockDeltas, (Collection)this.lockStates);
                }
                this.repository.notifyWriteAccessHandlers(this.transaction, this, false, monitor.fork());
            }
            catch (Throwable t) {
                this.handleException(t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void releaseImplicitLocks() {
        if (!this.lockedObjects.isEmpty()) {
            this.lockManager.unlock(this.transaction, this.lockedObjects, IRWLockManager.LockType.WRITE, 1, false, false, null, null);
            this.lockedObjects.clear();
        }
    }

    protected void acquireLocksOnNewObjects(CDOLockOwner lockOwner) throws InterruptedException {
        boolean mapIDs = this.transaction.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
        this.lockDeltas.setOperation(CDOLockChangeInfo.Operation.LOCK);
        CDOLockState[] cDOLockStateArray = this.locksOnNewObjects;
        int n = this.locksOnNewObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockState lockStateOnNewObject = cDOLockStateArray[n2];
            Object target = lockStateOnNewObject.getLockedObject();
            if (mapIDs) {
                CDOIDAndBranch idAndBranch = target instanceof CDOIDAndBranch ? (CDOIDAndBranch)target : null;
                CDOID id = idAndBranch != null ? ((CDOIDAndBranch)target).getID() : (CDOID)target;
                CDOID newID = this.idMappings.get(id);
                CheckUtil.checkNull((Object)newID, (String)"newID");
                target = idAndBranch != null ? CDOIDUtil.createIDAndBranch((CDOID)newID, (CDOBranch)idAndBranch.getBranch()) : newID;
            }
            IRWLockManager.LockType[] lockTypeArray = ALL_LOCK_TYPES;
            int n3 = ALL_LOCK_TYPES.length;
            int n4 = 0;
            while (n4 < n3) {
                IRWLockManager.LockType type = lockTypeArray[n4];
                if (lockStateOnNewObject.isLocked(type, lockOwner, false)) {
                    Set<Object> objects = Collections.singleton(target);
                    this.lockManager.lock(this.transaction, objects, type, 1, -1L, false, true, this.lockDeltas, this.lockStates);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void autoReleaseExplicitLocks(CDOLockOwner lockOwner) throws InterruptedException {
        Object target;
        CDOID id;
        ArrayList<Object> targets = new ArrayList<Object>();
        CDOID[] cDOIDArray = this.idsToUnlock;
        int n = this.idsToUnlock.length;
        int n2 = 0;
        while (n2 < n) {
            id = cDOIDArray[n2];
            target = this.lockManager.getLockKey(id, this.branch);
            targets.add(target);
            ++n2;
        }
        cDOIDArray = this.detachedObjects;
        n = this.detachedObjects.length;
        n2 = 0;
        while (n2 < n) {
            id = cDOIDArray[n2];
            target = this.lockManager.getLockKey(id, this.branch);
            if (this.lockManager.hasLock(IRWLockManager.LockType.WRITE, this.transaction, target)) {
                targets.add(target);
            }
            ++n2;
        }
        this.lockDeltas.setOperation(CDOLockChangeInfo.Operation.UNLOCK);
        this.lockManager.unlock(this.transaction, targets, null, -1, false, true, this.lockDeltas, this.lockStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewPackageUnits(OMMonitor monitor) {
        InternalCDOPackageRegistry repositoryPackageRegistry;
        InternalCDOPackageRegistry internalCDOPackageRegistry = repositoryPackageRegistry = this.repository.getPackageRegistry(false);
        synchronized (internalCDOPackageRegistry) {
            try {
                monitor.begin((double)this.newPackageUnits.length);
                int i = 0;
                while (i < this.newPackageUnits.length) {
                    InternalCDOPackageUnit packageUnit = this.newPackageUnits[i];
                    packageUnit.setState(CDOPackageUnit.State.LOADED);
                    repositoryPackageRegistry.putPackageUnit(packageUnit);
                    monitor.worked();
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void addRevisions(CDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevisionManager revisionManager = this.repository.getRevisionManager();
            int i = 0;
            while (i < revisions.length) {
                if (revisions[i] != null) {
                    revisions[i] = revisionManager.internRevision(revisions[i]);
                }
                monitor.worked();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void reviseDetachedObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.cachedDetachedRevisions.length);
            long revised = this.getBranchPoint().getTimeStamp() - 1L;
            InternalCDORevision[] internalCDORevisionArray = this.cachedDetachedRevisions;
            int n = this.cachedDetachedRevisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                if (revision != null) {
                    revision.setRevised(revised);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void detachObjects(OMMonitor monitor) {
        int size = this.detachedObjects.length;
        this.cachedDetachedRevisions = new InternalCDORevision[size];
        CDOID[] detachedObjects = this.getDetachedObjects();
        try {
            monitor.begin((double)size);
            InternalCDORevisionCache cache = this.repository.getRevisionManager().getCache();
            int i = 0;
            while (i < size) {
                CDOID id = detachedObjects[i];
                this.cachedDetachedRevisions[i] = (InternalCDORevision)cache.getRevision(id, (CDOBranchPoint)this.transaction);
                monitor.worked();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeAccessor(OMMonitor monitor) {
        this.accessor.write(this, monitor);
    }

    public String toString() {
        return MessageFormat.format("TransactionCommitContext[{0}, {1}, {2}]", this.transaction.getSession(), this.transaction, CDOCommonUtil.formatTimeStamp((long)this.timeStamp));
    }

    @Override
    @Deprecated
    public boolean isAutoReleaseLocksEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setAutoReleaseLocksEnabled(boolean on) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> getPostCommmitLockStates() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void setTimeStamp(long timeStamp) {
        throw new UnsupportedOperationException();
    }

    protected static final class RollbackException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final byte rollbackReason;
        private final String rollbackMessage;

        public RollbackException(byte rollbackReason, String rollbackMessage) {
            this.rollbackReason = rollbackReason;
            this.rollbackMessage = rollbackMessage;
        }

        public RollbackException(byte rollbackReason, Throwable cause) {
            super(cause);
            this.rollbackReason = rollbackReason;
            this.rollbackMessage = cause.getMessage();
        }

        public byte getRollbackReason() {
            return this.rollbackReason;
        }

        public String getRollbackMessage() {
            return this.rollbackMessage;
        }
    }

    public static final class TransactionPackageRegistry
    extends CDOPackageRegistryImpl {
        private static final long serialVersionUID = 1L;

        public TransactionPackageRegistry(InternalCDOPackageRegistry repositoryPackageRegistry) {
            this.delegateRegistry = repositoryPackageRegistry;
            this.setPackageLoader(repositoryPackageRegistry.getPackageLoader());
        }

        public synchronized void putPackageUnit(InternalCDOPackageUnit packageUnit) {
            LifecycleUtil.checkActive((Object)((Object)this));
            packageUnit.setPackageRegistry((InternalCDOPackageRegistry)this);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n = internalCDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                EPackage ePackage = packageInfo.getEPackage();
                this.basicPut(ePackage.getNsURI(), ePackage);
                ++n2;
            }
            this.resetInternalCaches();
        }

        protected void disposePackageUnits() {
        }

        public Collection<Object> values() {
            Collection values1 = super.values();
            Collection values2 = this.delegateRegistry.values();
            if (values1.isEmpty()) {
                return values2;
            }
            if (values2.isEmpty()) {
                return values1;
            }
            HashSet<Object> union = new HashSet<Object>();
            union.addAll(values1);
            union.addAll(values2);
            return union;
        }

        public String toString() {
            return "TransactionPackageRegistry";
        }
    }

    private final class XRefContext
    implements IStoreAccessor.QueryXRefsContext {
        private Map<EClass, List<EReference>> sourceCandidates = new HashMap<EClass, List<EReference>>();
        private Set<CDOID> detachedIDs = new HashSet<CDOID>();
        private Set<CDOID> dirtyIDs = new HashSet<CDOID>();
        private List<CDOIDReference> result = new ArrayList<CDOIDReference>();

        public XRefContext() {
            XRefsQueryHandler.collectSourceCandidates(TransactionCommitContext.this.transaction, TransactionCommitContext.this.detachedObjectTypes.values(), this.sourceCandidates);
            CDOID[] cDOIDArray = TransactionCommitContext.this.detachedObjects;
            int n = cDOIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                this.detachedIDs.add(id);
                ++n2;
            }
            cDOIDArray = TransactionCommitContext.this.dirtyObjects;
            n = cDOIDArray.length;
            n2 = 0;
            while (n2 < n) {
                CDOID revision = cDOIDArray[n2];
                this.dirtyIDs.add(revision.getID());
                ++n2;
            }
        }

        public List<CDOIDReference> getXRefs(IStoreAccessor accessor) {
            accessor.queryXRefs(this);
            this.checkDirtyObjects();
            return this.result;
        }

        private void checkDirtyObjects() {
            final CDOID[] dirtyID = new CDOID[1];
            CDOReferenceAdjuster dirtyObjectChecker = new CDOReferenceAdjuster(){

                public Object adjustReference(Object targetID, EStructuralFeature feature, int index) {
                    if (!(feature instanceof EReference && ((EReference)feature).isContainer() || !XRefContext.this.detachedIDs.contains(targetID))) {
                        XRefContext.this.result.add(new CDOIDReference((CDOID)targetID, dirtyID[0], feature, index));
                    }
                    return targetID;
                }
            };
            InternalCDORevision[] internalCDORevisionArray = TransactionCommitContext.this.dirtyObjects;
            int n = internalCDORevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision dirtyObject = internalCDORevisionArray[n2];
                dirtyID[0] = dirtyObject.getID();
                dirtyObject.adjustReferences(dirtyObjectChecker);
                ++n2;
            }
        }

        public long getTimeStamp() {
            return 0L;
        }

        public CDOBranch getBranch() {
            return TransactionCommitContext.this.branch;
        }

        @Override
        public Map<CDOID, EClass> getTargetObjects() {
            return TransactionCommitContext.this.detachedObjectTypes;
        }

        @Override
        public EReference[] getSourceReferences() {
            return new EReference[0];
        }

        @Override
        public Map<EClass, List<EReference>> getSourceCandidates() {
            return this.sourceCandidates;
        }

        @Override
        public int getMaxResults() {
            return -1;
        }

        @Override
        public boolean addXRef(CDOID targetID, CDOID sourceID, EReference sourceReference, int sourceIndex) {
            if (CDOIDUtil.isNull((CDOID)targetID)) {
                return true;
            }
            if (this.detachedIDs.contains(sourceID)) {
                return true;
            }
            if (this.dirtyIDs.contains(sourceID)) {
                return true;
            }
            this.result.add(new CDOIDReference(targetID, sourceID, (EStructuralFeature)sourceReference, sourceIndex));
            return true;
        }
    }
}

