/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;

public class ChangeTagIndication
extends CDOServerWriteIndication {
    private final AtomicInteger modCount = new AtomicInteger();
    private CDOBranchPoint result;

    public ChangeTagIndication(CDOServerProtocol protocol) {
        super(protocol, (short)64);
    }

    @Override
    protected void prepareStoreThreadLocal() {
        StoreThreadLocal.setSession((InternalSession)this.getSession());
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.modCount.set(in.readXInt());
        String oldName = in.readString();
        String newName = in.readString();
        CDOBranchPoint branchPoint = in.readBoolean() ? in.readCDOBranchPoint() : null;
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        this.result = branchManager.changeTagWithModCount(this.modCount, oldName, newName, branchPoint);
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        if (this.result != null) {
            out.writeXInt(this.modCount.get());
            out.writeCDOBranchPoint(this.result);
        } else {
            out.writeXInt(-1);
        }
    }
}

