/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.net4j.util.io.IStreamWrapper;

public abstract class DelegatingStreamWrapper
implements IStreamWrapper {
    private IStreamWrapper delegate;

    public DelegatingStreamWrapper(IStreamWrapper delegate) {
        this.delegate = delegate;
    }

    public IStreamWrapper getDelegate() {
        return this.delegate;
    }

    @Override
    public InputStream wrapInputStream(InputStream in) throws IOException {
        return this.doWrapInputStream(this.delegate.wrapInputStream(in));
    }

    @Override
    public OutputStream wrapOutputStream(OutputStream out) throws IOException {
        return this.doWrapOutputStream(this.delegate.wrapOutputStream(out));
    }

    @Override
    public void finishInputStream(InputStream in) throws IOException {
        this.delegate.finishInputStream(in);
        this.doFinishInputStream(in);
    }

    @Override
    public void finishOutputStream(OutputStream out) throws IOException {
        this.delegate.finishOutputStream(out);
        this.doFinishOutputStream(out);
    }

    protected abstract InputStream doWrapInputStream(InputStream var1) throws IOException;

    protected abstract OutputStream doWrapOutputStream(OutputStream var1) throws IOException;

    protected abstract void doFinishInputStream(InputStream var1) throws IOException;

    protected abstract void doFinishOutputStream(OutputStream var1) throws IOException;
}

