/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CreateViewConstantAction
extends DDLConstantAction {
    private final String tableName;
    private final String schemaName;
    private final String viewText;
    private final int tableType;
    private final int checkOption;
    private final ColumnInfo[] columnInfo;
    private final ProviderInfo[] providerInfo;
    private final UUID compSchemaId;

    CreateViewConstantAction(String schemaName, String tableName, int tableType, String viewText, int checkOption, ColumnInfo[] columnInfo, ProviderInfo[] providerInfo, UUID compSchemaId) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.viewText = viewText;
        this.checkOption = checkOption;
        this.columnInfo = columnInfo;
        this.providerInfo = providerInfo;
        this.compSchemaId = compSchemaId;
        SanityManager.ASSERT(schemaName != null, "Schema name is null");
    }

    public String toString() {
        return this.constructToString("CREATE VIEW ", this.tableName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = DDLConstantAction.getSchemaDescriptorForCreate(dd, activation, this.schemaName);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TableDescriptor td = ddg.newTableDescriptor(this.tableName, sd, this.tableType, 'R');
        dd.addDescriptor(td, sd, 1, false, tc);
        UUID toid = td.getUUID();
        TupleDescriptor[] cdlArray = new ColumnDescriptor[this.columnInfo.length];
        int index = 1;
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, index++, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, td, null, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoincCycle);
            cdlArray[ix] = columnDescriptor;
        }
        dd.addDescriptorArray(cdlArray, td, 2, false, tc);
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        for (int i = 0; i < cdlArray.length; ++i) {
            cdl.add(cdlArray[i]);
        }
        ViewDescriptor vd = ddg.newViewDescriptor(toid, this.tableName, this.viewText, this.checkOption, this.compSchemaId == null ? lcc.getDefaultSchema().getUUID() : this.compSchemaId);
        for (int ix = 0; ix < this.providerInfo.length; ++ix) {
            Provider provider = (Provider)this.providerInfo[ix].getDependableFinder().getDependable(dd, this.providerInfo[ix].getObjectId());
            dm.addDependency(vd, provider, lcc.getContextManager());
        }
        this.storeViewTriggerDependenciesOnPrivileges(activation, vd);
        dd.addDescriptor(vd, sd, 8, true, tc);
    }
}

