/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.lissome.bundle.OM;
import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.server.internal.lissome.db.IndexReader;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class IndexWriter
extends IndexReader {
    private static final ContextTracer TRACER = new ContextTracer(OM.INDEX, IndexWriter.class);
    protected PreparedStatement addCommitInfoStatement;
    protected PreparedStatement addObjectStatement;
    protected PreparedStatement reviseOldRevisionsStatement;
    protected PreparedStatement createBranchStatement;
    private Set<PreparedStatement> batches = new HashSet<PreparedStatement>();

    public IndexWriter(Index index) {
        super(index);
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void commit() {
        try {
            try {
                for (PreparedStatement stmt : this.batches) {
                    stmt.executeBatch();
                }
                this.connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            this.batches.clear();
        }
    }

    protected void execute(PreparedStatement stmt) throws SQLException {
        this.index.trace(TRACER, stmt);
        stmt.addBatch();
        this.batches.add(stmt);
    }

    public void addCommitInfo(CDOBranchPoint branchPoint, long pointer) {
        if (TRACER.isEnabled()) {
            TRACER.format("addCommitInfo: {0}, {1}", new Object[]{branchPoint, pointer});
        }
        try {
            if (this.addCommitInfoStatement == null) {
                String sql = this.index.commitInfos.sqlAddCommitInfo();
                this.addCommitInfoStatement = this.connection.prepareStatement(sql);
            }
            int column = 0;
            long timeStamp = branchPoint.getTimeStamp();
            this.addCommitInfoStatement.setLong(++column, timeStamp);
            if (this.supportingBranches) {
                CDOBranch branch = branchPoint.getBranch();
                int branchID = branch.getID();
                this.addCommitInfoStatement.setInt(++column, branchID);
            }
            this.addCommitInfoStatement.setLong(++column, pointer);
            this.execute(this.addCommitInfoStatement);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void addObjects(InternalCDORevision[] newRevisions, long[] pointers) {
        if (TRACER.isEnabled()) {
            TRACER.format("addObjects: {0}, {1}", new Object[]{Arrays.asList(newRevisions), Arrays.asList(new long[][]{pointers})});
        }
        try {
            if (this.addObjectStatement == null) {
                String sql = this.index.objects.sqlAddRevision();
                this.addObjectStatement = this.connection.prepareStatement(sql);
            }
            int i = 0;
            while (i < newRevisions.length) {
                InternalCDORevision revision = newRevisions[i];
                long pointer = pointers[i];
                boolean detached = revision instanceof DetachedCDORevision;
                int column = 0;
                CDOID oid = revision.getID();
                this.index.setCDOID(this.addObjectStatement, ++column, oid);
                if (this.supportingBranches) {
                    int branchID = revision.getBranch().getID();
                    this.addObjectStatement.setInt(++column, branchID);
                }
                if (this.supportingAudits) {
                    long time = revision.getTimeStamp();
                    this.addObjectStatement.setLong(++column, time);
                    long revised = revision.getRevised();
                    this.addObjectStatement.setLong(++column, revised);
                    int version = revision.getVersion();
                    if (detached) {
                        version = -version;
                    }
                    this.addObjectStatement.setInt(++column, version);
                }
                int cid = this.getStore().getMetaID(revision.getEClass());
                this.addObjectStatement.setInt(++column, cid);
                CDOID containerID = detached ? CDOID.NULL : (CDOID)revision.getContainerID();
                this.index.setCDOID(this.addObjectStatement, ++column, containerID);
                if (!detached && revision.isResourceNode()) {
                    String name = (String)revision.data().get((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, 0);
                    if (name == null) {
                        name = CDOURIUtil.SEGMENT_SEPARATOR;
                    }
                    this.addObjectStatement.setString(++column, name);
                } else {
                    this.addObjectStatement.setNull(++column, DBType.VARCHAR.getCode());
                }
                this.addObjectStatement.setLong(++column, pointer);
                this.execute(this.addObjectStatement);
                ++i;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void updateObjects(InternalCDORevision[] newRevisions, long[] pointers) {
        if (TRACER.isEnabled()) {
            TRACER.format("updateObjects: {0}, {1}", new Object[]{Arrays.asList(newRevisions), Arrays.asList(new long[][]{pointers})});
        }
        if (this.supportingAudits) {
            this.reviseOldRevisions(newRevisions);
            this.addObjects(newRevisions, pointers);
        }
    }

    protected void reviseOldRevisions(InternalCDORevision[] newRevisions) {
        if (TRACER.isEnabled()) {
            TRACER.format("reviseOldRevisions: {0}", new Object[]{Arrays.asList(newRevisions)});
        }
        try {
            if (this.reviseOldRevisionsStatement == null) {
                String sql = this.index.objects.sqlReviseOldRevisions();
                this.reviseOldRevisionsStatement = this.connection.prepareStatement(sql);
            }
            int i = 0;
            while (i < newRevisions.length) {
                InternalCDORevision revision = newRevisions[i];
                int column = 0;
                long revised = revision.getTimeStamp() - 1L;
                this.reviseOldRevisionsStatement.setLong(++column, revised);
                CDOID oid = revision.getID();
                this.index.setCDOID(this.reviseOldRevisionsStatement, ++column, oid);
                if (this.supportingBranches) {
                    int branchID = revision.getBranch().getID();
                    this.reviseOldRevisionsStatement.setInt(++column, branchID);
                }
                int version = Math.abs(revision.getVersion()) - 1;
                this.reviseOldRevisionsStatement.setInt(++column, version);
                this.execute(this.reviseOldRevisionsStatement);
                ++i;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void detachObjects(CDOBranchPoint branchPoint, CDOID[] ids, InternalCDORevision[] detachedRevisions, long[] detachedObjectPointers) {
        if (TRACER.isEnabled()) {
            TRACER.format("detachObjects: {0}, {1}", new Object[]{Arrays.asList(ids), branchPoint});
        }
        if (!this.supportingAudits) {
            throw new UnsupportedOperationException();
        }
        this.updateObjects(detachedRevisions, detachedObjectPointers);
    }

    protected long readPointerNonAudit(CDOID id) {
        throw new UnsupportedOperationException();
    }

    public void createBranch(int branchID, String name, CDOBranchPoint base, long pointer) {
        if (TRACER.isEnabled()) {
            TRACER.format("createBranch: {0}, {1}, {2}", new Object[]{branchID, name, base});
        }
        try {
            if (this.createBranchStatement == null) {
                String sql = this.index.branches.sqlCreateBranch();
                this.createBranchStatement = this.connection.prepareStatement(sql);
            }
            this.createBranchStatement.setInt(1, branchID);
            this.createBranchStatement.setString(2, name);
            this.createBranchStatement.setInt(3, base.getBranch().getID());
            this.createBranchStatement.setLong(4, base.getTimeStamp());
            this.execute(this.createBranchStatement);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }
}

