/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.h2.command.Prepared;
import org.h2.command.QueryScope;
import org.h2.command.query.ForUpdate;
import org.h2.command.query.QueryOrderBy;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.IsolationLevel;
import org.h2.engine.SessionLocal;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.CTE;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.DerivedTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

public abstract class Query
extends Prepared {
    ArrayList<Expression> expressions;
    Expression[] expressionArray;
    ArrayList<QueryOrderBy> orderList;
    SortOrder sort;
    Expression fetchExpr;
    boolean fetchPercent;
    boolean withTies;
    Expression offsetExpr;
    boolean distinct;
    int[] inPredicateSortTypes;
    int visibleColumnCount;
    int resultColumnCount;
    private boolean noCache;
    private long lastLimit;
    private long lastEvaluated;
    private ResultInterface lastResult;
    private Boolean lastExists;
    private Value[] lastParameters;
    private int[] lastInPredicateSortTypes;
    private boolean cacheableChecked;
    private boolean neverLazy;
    boolean checkInit;
    boolean isPrepared;
    private QueryScope outerQueryScope;
    private LinkedHashMap<String, Table> withClause;

    Query(SessionLocal sessionLocal) {
        super(sessionLocal);
    }

    public void setNeverLazy(boolean bl) {
        this.neverLazy = bl;
    }

    public boolean isNeverLazy() {
        return this.neverLazy;
    }

    public abstract boolean isUnion();

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
        localResult.done();
        return localResult;
    }

    protected abstract ResultInterface queryWithoutCache(long var1, ResultTarget var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInterface queryWithoutCacheLazyCheck(long l, ResultTarget resultTarget) {
        boolean bl;
        boolean bl2 = bl = this.neverLazy && this.session.isLazyQueryExecution();
        if (bl) {
            this.session.setLazyQueryExecution(false);
        }
        try {
            ResultInterface resultInterface = this.queryWithoutCache(l, resultTarget);
            return resultInterface;
        }
        finally {
            if (bl) {
                this.session.setLazyQueryExecution(true);
            }
        }
    }

    public abstract void init();

    @Override
    public final void prepare() {
        if (!this.checkInit) {
            throw DbException.getInternalError("not initialized");
        }
        if (this.isPrepared) {
            return;
        }
        this.prepareExpressions();
        this.preparePlan();
    }

    public abstract void prepareExpressions();

    public abstract void preparePlan();

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public void setOrder(ArrayList<QueryOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    public ForUpdate getForUpdate() {
        return null;
    }

    public abstract void setForUpdate(ForUpdate var1);

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TypeInfo getRowDataType() {
        if (this.visibleColumnCount == 1) {
            return this.expressionArray[0].getType();
        }
        return TypeInfo.getTypeInfo(41, -1L, -1, new ExtTypeInfoRow(this.expressionArray, this.visibleColumnCount));
    }

    public abstract void mapColumns(ColumnResolver var1, int var2, boolean var3);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    public abstract void updateAggregate(SessionLocal var1, int var2);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinctIfPossible() {
        if (!this.isAnyDistinct() && this.offsetExpr == null && this.fetchExpr == null) {
            this.distinct = true;
        }
    }

    public boolean isStandardDistinct() {
        return this.distinct;
    }

    public boolean isAnyDistinct() {
        return this.distinct;
    }

    public boolean isInPredicateResult() {
        return this.inPredicateSortTypes != null;
    }

    public void setInPredicateResult() {
        if (this.inPredicateSortTypes == null) {
            this.inPredicateSortTypes = new int[0];
        }
    }

    public void setInPredicateResultSortTypes(int[] nArray) {
        this.inPredicateSortTypes = nArray;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean getNoCache() {
        if (!this.cacheableChecked) {
            if (this.getMaxDataModificationId() == Long.MAX_VALUE || !this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
                this.noCache = true;
            }
            this.cacheableChecked = true;
        }
        return this.noCache;
    }

    private static boolean sameParameters(Value[] valueArray, Value[] valueArray2) {
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray2[i];
            Value value2 = valueArray[i];
            if (value == null || value.equals(value2)) continue;
            return false;
        }
        return true;
    }

    private Value[] getParameterValues() {
        ArrayList<Parameter> arrayList = this.getParameters();
        if (arrayList == null) {
            return Value.EMPTY_VALUES;
        }
        int n = arrayList.size();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Parameter parameter = arrayList.get(i);
            valueArray[i] = parameter != null ? parameter.getParamValue() : null;
        }
        return valueArray;
    }

    @Override
    public final ResultInterface query(long l) {
        return this.query(l, null);
    }

    public final ResultInterface query(long l, ResultTarget resultTarget) {
        if (this.isUnion()) {
            return this.queryWithoutCacheLazyCheck(l, resultTarget);
        }
        this.fireBeforeSelectTriggers();
        if (this.getNoCache() || !this.getDatabase().getOptimizeReuseResults() || this.session.isLazyQueryExecution() && !this.neverLazy) {
            return this.queryWithoutCacheLazyCheck(l, resultTarget);
        }
        boolean bl = this.session.getTransaction().getIsolationLevel() != IsolationLevel.READ_UNCOMMITTED && !this.isUpdatedInCurrentTransaction();
        Value[] valueArray = this.getParameterValues();
        long l2 = this.session.getStatementModificationDataId();
        long l3 = this.getMaxDataModificationId();
        if (this.lastResult != null && !this.lastResult.isClosed() && bl && l3 <= this.lastEvaluated && l == this.lastLimit && Query.sameParameters(valueArray, this.lastParameters) && Arrays.equals(this.inPredicateSortTypes, this.lastInPredicateSortTypes)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.closeLastResult();
        ResultInterface resultInterface = this.queryWithoutCacheLazyCheck(l, resultTarget);
        if (bl && l3 <= l2) {
            this.lastParameters = valueArray;
            this.lastResult = resultInterface;
            this.lastInPredicateSortTypes = this.inPredicateSortTypes;
            this.lastEvaluated = l2;
            this.lastLimit = l;
        } else {
            this.resetLastResult();
        }
        this.lastExists = null;
        return resultInterface;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    public final boolean exists() {
        if (this.isUnion()) {
            return this.executeExists();
        }
        this.fireBeforeSelectTriggers();
        if (this.getNoCache() || !this.getDatabase().getOptimizeReuseResults()) {
            return this.executeExists();
        }
        Value[] valueArray = this.getParameterValues();
        long l = this.session.getStatementModificationDataId();
        long l2 = this.getMaxDataModificationId();
        if (this.lastExists != null && l2 <= this.lastEvaluated && Query.sameParameters(valueArray, this.lastParameters)) {
            return this.lastExists;
        }
        boolean bl = this.executeExists();
        if (l2 <= l) {
            this.lastParameters = valueArray;
            this.lastExists = bl;
            this.lastEvaluated = l;
        } else {
            this.resetLastResult();
        }
        this.lastResult = null;
        return bl;
    }

    private boolean isUpdatedInCurrentTransaction() {
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        this.collectDependencies(hashSet);
        for (DbObject dbObject : hashSet) {
            Table table;
            if (!(dbObject instanceof Table) || !this.session.isUpdatedInCurrentTransaction(table = (Table)dbObject)) continue;
            return true;
        }
        return false;
    }

    private boolean executeExists() {
        ResultInterface resultInterface = this.queryWithoutCacheLazyCheck(1L, null);
        boolean bl = resultInterface.hasNext();
        resultInterface.close();
        return bl;
    }

    boolean initOrder(ArrayList<String> arrayList, boolean bl, ArrayList<TableFilter> arrayList2) {
        Iterator<QueryOrderBy> iterator = this.orderList.iterator();
        while (iterator.hasNext()) {
            QueryOrderBy queryOrderBy = iterator.next();
            Expression expression = queryOrderBy.expression;
            if (expression == null) continue;
            if (expression.isConstant()) {
                iterator.remove();
                continue;
            }
            int n = this.initExpression(arrayList, expression, bl, arrayList2);
            queryOrderBy.columnIndexExpr = ValueExpression.get(ValueInteger.get(n + 1));
            queryOrderBy.expression = this.expressions.get(n).getNonAliasExpression();
        }
        if (this.orderList.isEmpty()) {
            this.orderList = null;
            return false;
        }
        return true;
    }

    int initExpression(ArrayList<String> arrayList, Expression expression, boolean bl, ArrayList<TableFilter> arrayList2) {
        Object object;
        Database database = this.getDatabase();
        if (expression instanceof ExpressionColumn) {
            object = (ExpressionColumn)expression;
            String string = ((ExpressionColumn)object).getOriginalTableAliasName();
            String string2 = ((ExpressionColumn)object).getOriginalColumnName();
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Object object3;
                Expression expression2;
                Expression expression3 = this.expressions.get(i);
                if (expression3 instanceof ExpressionColumn) {
                    expression2 = (ExpressionColumn)expression3;
                    if (!database.equalsIdentifiers(string2, ((ExpressionColumn)expression2).getColumnName(this.session, i))) continue;
                    if (string == null) {
                        return i;
                    }
                    object3 = ((ExpressionColumn)expression2).getOriginalTableAliasName();
                    if (object3 != null) {
                        if (!database.equalsIdentifiers((String)object3, string)) continue;
                        return i;
                    }
                    if (arrayList2 == null) continue;
                    for (TableFilter tableFilter : arrayList2) {
                        if (!database.equalsIdentifiers(tableFilter.getTableAlias(), string)) continue;
                        return i;
                    }
                    continue;
                }
                if (!(expression3 instanceof Alias)) continue;
                if (string == null && database.equalsIdentifiers(string2, expression3.getAlias(this.session, i))) {
                    return i;
                }
                expression2 = expression3.getNonAliasExpression();
                if (!(expression2 instanceof ExpressionColumn)) continue;
                object3 = expression2;
                String string3 = ((Expression)object).getSQL(0, 2);
                String string4 = ((Expression)object3).getSQL(0, 2);
                String string5 = ((ExpressionColumn)object3).getColumnName(this.session, i);
                if (!database.equalsIdentifiers(string2, string5) || !database.equalsIdentifiers(string3, string4)) continue;
                return i;
            }
        } else if (arrayList != null) {
            object = expression.getSQL(0, 2);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!database.equalsIdentifiers(arrayList.get(i), (String)object)) continue;
                return i;
            }
        }
        if (arrayList == null || bl && !database.getMode().allowUnrelatedOrderByExpressionsInDistinctQueries && !Query.checkOrderOther(this.session, expression, arrayList)) {
            throw DbException.get(90068, expression.getTraceSQL());
        }
        int n = this.expressions.size();
        this.expressions.add(expression);
        arrayList.add(expression.getSQL(0, 2));
        return n;
    }

    private static boolean checkOrderOther(SessionLocal sessionLocal, Expression expression, ArrayList<String> arrayList) {
        if (expression == null || expression.isConstant()) {
            return true;
        }
        String string = expression.getSQL(0, 2);
        for (String string2 : arrayList) {
            if (!sessionLocal.getDatabase().equalsIdentifiers(string, string2)) continue;
            return true;
        }
        int n = expression.getSubexpressionCount();
        if (!expression.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR)) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Query.checkOrderOther(sessionLocal, expression.getSubexpression(i), arrayList)) continue;
            return false;
        }
        return true;
    }

    void prepareOrder(ArrayList<QueryOrderBy> arrayList, int n) {
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            QueryOrderBy queryOrderBy = arrayList.get(i);
            boolean bl = false;
            Value value = queryOrderBy.columnIndexExpr.getValue(null);
            if (value == ValueNull.INSTANCE) {
                n3 = 0;
            } else {
                n3 = value.getInt();
                if (n3 < 0) {
                    bl = true;
                    n3 = -n3;
                }
                if (--n3 < 0 || n3 >= n) {
                    throw DbException.get(90068, Integer.toString(n3 + 1));
                }
            }
            nArray[i] = n3;
            int n4 = queryOrderBy.sortType;
            if (bl) {
                n4 ^= 1;
            }
            nArray2[i] = n4;
        }
        this.sort = new SortOrder(this.session, nArray, nArray2, arrayList);
        this.orderList = null;
    }

    void cleanupOrder() {
        int[] nArray = this.sort.getQueryColumnIndexes();
        int n = nArray.length;
        int n2 = 0;
        for (int n3 : nArray) {
            if (!this.expressions.get(n3).isConstant()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 == n) {
            this.sort = null;
            return;
        }
        int n4 = n - n2;
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = this.sort.getSortTypes();
        ArrayList<QueryOrderBy> arrayList = this.sort.getOrderList();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            if (!this.expressions.get(nArray[n5]).isConstant()) {
                nArray2[n6] = nArray[n5];
                nArray3[n6] = nArray4[n5];
                ++n6;
            } else {
                arrayList.remove(n6);
            }
            ++n5;
        }
        this.sort = new SortOrder(this.session, nArray2, nArray3, arrayList);
    }

    @Override
    public int getType() {
        return 66;
    }

    public void setOffset(Expression expression) {
        this.offsetExpr = expression;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setFetch(Expression expression) {
        this.fetchExpr = expression;
    }

    public Expression getFetch() {
        return this.fetchExpr;
    }

    public void setFetchPercent(boolean bl) {
        this.fetchPercent = bl;
    }

    public boolean isFetchPercent() {
        return this.fetchPercent;
    }

    public void setWithTies(boolean bl) {
        this.withTies = bl;
    }

    public boolean isWithTies() {
        return this.withTies;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = Utils.newSmallArrayList();
        }
        this.parameters.add(parameter);
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(expressionVisitor);
        return Math.max(expressionVisitor.getMaxDataModificationId(), this.session.getSnapshotDataModificationId());
    }

    public QueryScope getOuterQueryScope() {
        return this.outerQueryScope;
    }

    public void setOuterQueryScope(QueryScope queryScope) {
        this.outerQueryScope = queryScope;
    }

    public void setWithClause(LinkedHashMap<String, Table> linkedHashMap) {
        this.withClause = linkedHashMap;
    }

    protected void writeWithList(StringBuilder stringBuilder, int n) {
        if (this.withClause != null) {
            boolean bl = false;
            for (Table object : this.withClause.values()) {
                if (!((CTE)object).isRecursive()) continue;
                bl = true;
                break;
            }
            stringBuilder.append("WITH ");
            if (bl) {
                stringBuilder.append(" RECURSIVE ");
            }
            boolean bl2 = false;
            for (Table table : this.withClause.values()) {
                if (!bl2) {
                    bl2 = true;
                } else {
                    stringBuilder.append(",\n");
                }
                table.getSQL(stringBuilder, n).append('(');
                Column.writeColumns(stringBuilder, table.getColumns(), n).append(") AS (\n");
                StringUtils.indent(stringBuilder, ((CTE)table).getQuerySQL(), 4, true).append(')');
            }
            stringBuilder.append('\n');
        }
    }

    void appendEndOfQueryToSQL(StringBuilder stringBuilder, int n, Expression[] expressionArray) {
        int n2;
        if (this.sort != null) {
            this.sort.getSQL(stringBuilder.append("\nORDER BY "), expressionArray, this.visibleColumnCount, n);
        } else if (this.orderList != null) {
            stringBuilder.append("\nORDER BY ");
            n2 = this.orderList.size();
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                this.orderList.get(i).getSQL(stringBuilder, n);
            }
        }
        if (this.offsetExpr != null) {
            String string = this.offsetExpr.getSQL(n, 2);
            stringBuilder.append("\nOFFSET ").append(string).append("1".equals(string) ? " ROW" : " ROWS");
        }
        if (this.fetchExpr != null) {
            stringBuilder.append("\nFETCH ").append(this.offsetExpr != null ? "NEXT" : "FIRST");
            String string = this.fetchExpr.getSQL(n, 2);
            int n3 = n2 = this.fetchPercent || !"1".equals(string) ? 1 : 0;
            if (n2 != 0) {
                stringBuilder.append(' ').append(string);
                if (this.fetchPercent) {
                    stringBuilder.append(" PERCENT");
                }
            }
            stringBuilder.append(n2 == 0 ? " ROW" : " ROWS").append(this.withTies ? " WITH TIES" : " ONLY");
        }
    }

    OffsetFetch getOffsetFetch(long l) {
        boolean bl;
        long l2;
        long l3;
        if (this.offsetExpr != null) {
            Value value = this.offsetExpr.getValue(this.session);
            if (value == ValueNull.INSTANCE || (l3 = value.getLong()) < 0L) {
                throw DbException.getInvalidValueException("result OFFSET", value);
            }
        } else {
            l3 = 0L;
        }
        long l4 = l2 = l == 0L ? -1L : l;
        if (this.fetchExpr != null) {
            long l5;
            Value value = this.fetchExpr.getValue(this.session);
            if (value == ValueNull.INSTANCE || (l5 = value.getLong()) < 0L) {
                throw DbException.getInvalidValueException("result FETCH", value);
            }
            long l6 = l2 = l2 < 0L ? l5 : Math.min(l5, l2);
        }
        if (bl = this.fetchPercent) {
            if (l2 > 100L) {
                throw DbException.getInvalidValueException("result FETCH PERCENT", l2);
            }
            if (l2 == 0L) {
                bl = false;
            }
        }
        return new OffsetFetch(l3, l2, bl);
    }

    LocalResult finishResult(LocalResult localResult, long l, long l2, boolean bl, ResultTarget resultTarget) {
        if (l != 0L) {
            localResult.setOffset(l);
        }
        if (l2 >= 0L) {
            localResult.setLimit(l2);
            localResult.setFetchPercent(bl);
            if (this.withTies) {
                localResult.setWithTies(this.sort);
            }
        }
        localResult.done();
        if (this.inPredicateSortTypes != null) {
            localResult = this.convertToInPredicateValueListIfNecessary(localResult);
        }
        if (resultTarget != null) {
            while (localResult.next()) {
                resultTarget.addRow(localResult.currentRow());
            }
            localResult.close();
            return null;
        }
        return localResult;
    }

    private LocalResult convertToInPredicateValueListIfNecessary(LocalResult localResult) {
        block5: {
            if (this.distinct) {
                int n;
                int[] nArray;
                if (this.inPredicateSortTypes == null) {
                    return localResult;
                }
                if (this.sort != null && (nArray = this.sort.getSortTypes()).length >= (n = this.inPredicateSortTypes.length)) {
                    for (int i = 0; i < n; ++i) {
                        if ((nArray[i] & 1) == (this.inPredicateSortTypes[i] & 1)) {
                            continue;
                        }
                        break block5;
                    }
                    return localResult;
                }
            }
        }
        return this.convertToInPredicateValueList(localResult);
    }

    LocalResult convertToInPredicateValueList(ResultInterface resultInterface) {
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
        localResult.setInPredicateValueListResult(this.inPredicateSortTypes);
        resultInterface.reset();
        while (resultInterface.next()) {
            localResult.addRow(resultInterface.currentRow());
        }
        resultInterface.close();
        localResult.done();
        return localResult;
    }

    public Table toTable(String string, Column[] columnArray, ArrayList<Parameter> arrayList, boolean bl, Query query) {
        this.setParameterList(new ArrayList<Parameter>(arrayList));
        if (!this.checkInit) {
            this.init();
        }
        return new DerivedTable(bl ? this.getDatabase().getSystemSession() : this.session, string, columnArray, this, query);
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        this.isEverything(expressionVisitor);
    }

    public boolean isConstantQuery() {
        return !(this.hasOrder() || this.offsetExpr != null && !this.offsetExpr.isConstant() || this.fetchExpr != null && !this.fetchExpr.isConstant());
    }

    public Expression getIfSingleRow() {
        return null;
    }

    @Override
    public boolean isRetryable() {
        ForUpdate forUpdate = this.getForUpdate();
        return forUpdate == null || forUpdate.getType() == ForUpdate.Type.SKIP_LOCKED;
    }

    @Override
    public void invalidateCachedResult(Table table) {
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        this.collectDependencies(hashSet);
        if (hashSet.contains(table)) {
            this.resetLastResult();
        }
    }

    private void resetLastResult() {
        this.lastParameters = null;
        this.lastResult = null;
        this.lastInPredicateSortTypes = null;
        this.lastLimit = 0L;
        this.lastEvaluated = 0L;
        this.lastExists = null;
    }

    static final class OffsetFetch {
        final long offset;
        final long fetch;
        final boolean fetchPercent;

        OffsetFetch(long l, long l2, boolean bl) {
            this.offset = l;
            this.fetch = l2;
            this.fetchPercent = bl;
        }
    }
}

