/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;

public class CDOFetchRuleManagerThreadLocal
implements CDOFetchRuleManager {
    private static final ThreadLocal<CDOFetchRuleManager> THREAD_LOCAL = new ThreadLocal();

    public static CDOFetchRuleManager getCurrent() {
        return THREAD_LOCAL.get();
    }

    public static void join(CDOFetchRuleManager fetchRulemanager) {
        THREAD_LOCAL.set(fetchRulemanager);
    }

    public static void leave() {
        THREAD_LOCAL.remove();
    }

    @Override
    public CDOID getContext() {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getContext() : null;
    }

    @Override
    public List<CDOFetchRule> getFetchRules(Collection<CDOID> ids) {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getFetchRules(ids) : null;
    }

    @Override
    public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getCollectionLoadingPolicy() : null;
    }
}

