/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.tests;

import java.io.File;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.derby.EmbeddedDerbyAdapter;
import org.eclipse.net4j.db.tests.AbstractDBTest;
import org.eclipse.net4j.util.io.IOUtil;

public class DerbyTest
extends AbstractDBTest {
    private File dbFolder;

    @Override
    protected IDBAdapter createAdapter() {
        return new EmbeddedDerbyAdapter();
    }

    @Override
    protected DataSource createDataSource() {
        this.dbFolder = this.createTempFolder("derby_");
        this.deleteDBFolder();
        DerbyTest.msg((Object)("Using DB folder: " + this.dbFolder.getAbsolutePath()));
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName(this.dbFolder.getAbsolutePath());
        dataSource.setCreateDatabase("create");
        return dataSource;
    }

    @Override
    protected void doTearDown() throws Exception {
        this.deleteDBFolder();
        super.doTearDown();
    }

    private void deleteDBFolder() {
        IOUtil.delete((File)this.dbFolder);
    }
}

