/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.examples.extlibrary.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtil {
    private static Map<String, MessageConsole> nameToConsole = new HashMap<String, MessageConsole>();
    private static Map<String, MessageConsoleStream> nameToStream = new HashMap<String, MessageConsoleStream>();

    public static synchronized MessageConsole registerConsole(String name) {
        if (nameToConsole.get(name) == null) {
            MessageConsole console = new MessageConsole(name, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            nameToConsole.put(name, console);
        }
        return nameToConsole.get(name);
    }

    public static synchronized void unregisterConsole(String name) {
        if (nameToConsole.containsKey(name)) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{(IConsole)nameToConsole.get(name)});
            nameToConsole.remove(name);
        }
    }

    private static synchronized MessageConsoleStream getDefaultStream(String name) {
        if (nameToStream.get(name) == null) {
            MessageConsole console = ConsoleUtil.registerConsole(name);
            MessageConsoleStream defaultStream = console.newMessageStream();
            nameToStream.put(name, defaultStream);
        }
        return nameToStream.get(name);
    }

    public static void println(String name, String msg) {
        MessageConsoleStream defaultStream = ConsoleUtil.getDefaultStream(name);
        defaultStream.println(msg);
    }

    public static void showConsole(String name) {
        MessageConsole console = ConsoleUtil.registerConsole(name);
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
    }
}

