/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.ext.widgets.reference.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.ext.widgets.reference.api.IEEFExtReferenceViewerFilterProvider;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.Messages;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class EEFExtEObjectCreationPage
extends WizardPage {
    private EObject target;
    private EReference eReference;
    private EditingContextAdapter editingContextAdapter;
    private ComposedAdapterFactory composedAdapterFactory;
    private ComboViewer eClassInstanceComboViewer;
    private ISelectionChangedListener eClassInstanceComboViewerListener;
    private TreeViewer eContainerTreeViewer;
    private ISelectionChangedListener eContainerTreeViewerListener;
    private ComboViewer eContainementReferenceComboViewer;
    private ISelectionChangedListener eContainmentReferenceComboViewerListener;

    public EEFExtEObjectCreationPage(EObject target, EReference eReference, EditingContextAdapter editingContextAdapter) {
        super(Messages.ReferenceCreationWizardPage_title);
        this.target = target;
        this.eReference = eReference;
        this.editingContextAdapter = editingContextAdapter;
        this.setTitle(Messages.ReferenceCreationWizardPage_title);
        this.setDescription(Messages.ReferenceCreationWizardPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        GridLayout gridLayout = new GridLayout(2, false);
        control.setLayout((Layout)gridLayout);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        if (this.eReference.isContainment()) {
            this.createEObjectEClassComboViewer(control);
            this.initializeContainmentInput(this.target, this.eReference);
        } else {
            this.createContainerTreeViewer(control);
            this.createContainmentFeatureComboViewer(control);
            this.createEObjectEClassComboViewer(control);
            this.initializeNonContainmentInput();
        }
        this.determinePageCompletion();
    }

    private void initializeContainmentInput(EObject eObject, EReference eContainementReference) {
        ArrayList<Object> values = new ArrayList<Object>();
        Adapter adapter = this.composedAdapterFactory.adapt((Notifier)eObject, IEditingDomainItemProvider.class);
        if (adapter instanceof IEditingDomainItemProvider) {
            IEditingDomainItemProvider itemProviderAdapter = (IEditingDomainItemProvider)adapter;
            Collection newChildDescriptors = itemProviderAdapter.getNewChildDescriptors((Object)eObject, this.editingContextAdapter.getEditingDomain(), null);
            for (Object newChildDescriptor : newChildDescriptors) {
                if (!(newChildDescriptor instanceof CommandParameter)) continue;
                CommandParameter commandParameter = (CommandParameter)newChildDescriptor;
                Object value = commandParameter.getValue();
                if (!commandParameter.getEReference().equals(eContainementReference) || !(value instanceof EObject) || !this.eReference.getEReferenceType().isSuperTypeOf(((EObject)value).eClass())) continue;
                values.add(commandParameter.getValue());
            }
        }
        this.eClassInstanceComboViewer.setInput(values);
        if (values.size() > 0) {
            this.eClassInstanceComboViewer.setSelection((ISelection)new StructuredSelection(values.get(0)));
        } else {
            this.eClassInstanceComboViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    private void initializeNonContainmentInput() {
        this.eContainerTreeViewer.setInput((Object)this.editingContextAdapter.getEditingDomain().getResourceSet());
    }

    private void createContainerTreeViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ReferenceCreationWizardPage_eContainerSelectionLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.eContainerTreeViewer = new TreeViewer(new Tree(parent, 67588));
        this.eContainerTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.eContainerTreeViewer)));
        this.eContainerTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.composedAdapterFactory));
        this.eContainerTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.eContainerTreeViewer.setAutoExpandLevel(2);
        List<ViewerFilter> viewFilters = EEFExtReferenceUIPlugin.getPlugin().getViewFilters(IEEFExtReferenceViewerFilterProvider.ContextKind.CONTAINER_SELECTION);
        this.eContainerTreeViewer.setFilters(viewFilters.toArray(new ViewerFilter[viewFilters.size()]));
        this.eContainerTreeViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EEFExtEObjectCreationPage.this.handleEContainerSelectionChanged();
            }
        };
        this.eContainerTreeViewer.addSelectionChangedListener(this.eContainerTreeViewerListener);
    }

    protected void handleEContainerSelectionChanged() {
        EObject eContainer = this.getEObject((StructuredViewer)this.eContainerTreeViewer);
        if (eContainer != null) {
            List<EReference> eReferences = this.getValidContainmentReferences(eContainer);
            this.eContainementReferenceComboViewer.setInput(eReferences);
            if (eReferences.size() > 0) {
                this.eContainementReferenceComboViewer.setSelection((ISelection)new StructuredSelection((Object)eReferences.get(0)));
            } else {
                this.eContainementReferenceComboViewer.setSelection((ISelection)new StructuredSelection());
                this.eClassInstanceComboViewer.setSelection((ISelection)new StructuredSelection());
            }
        } else {
            this.eContainementReferenceComboViewer.setSelection((ISelection)new StructuredSelection());
            this.eClassInstanceComboViewer.setSelection((ISelection)new StructuredSelection());
        }
        this.determinePageCompletion();
    }

    private EObject getEObject(StructuredViewer viewer) {
        IStructuredSelection structuredSelection;
        Object object;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return (EObject)object;
        }
        return null;
    }

    private List<EReference> getValidContainmentReferences(EObject eObject) {
        ArrayList<EReference> eReferences = new ArrayList<EReference>();
        EList eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eAllStructuralFeatures) {
            EReference reference;
            if (!(eStructuralFeature instanceof EReference) || !(reference = (EReference)eStructuralFeature).isContainment() || !reference.getEReferenceType().isSuperTypeOf(this.eReference.getEReferenceType())) continue;
            eReferences.add(reference);
        }
        return eReferences;
    }

    private void createContainmentFeatureComboViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ReferenceCreationWizardPage_eContainerToUseLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.eContainementReferenceComboViewer = new ComboViewer(new Combo(parent, 12));
        this.eContainementReferenceComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory));
        this.eContainementReferenceComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eContainementReferenceComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.eContainmentReferenceComboViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EEFExtEObjectCreationPage.this.handleEContainmentReferenceSelectionChange();
            }
        };
        this.eContainementReferenceComboViewer.addSelectionChangedListener(this.eContainmentReferenceComboViewerListener);
    }

    private void handleEContainmentReferenceSelectionChange() {
        EObject eContainmentReference;
        EObject eContainer = this.getEObject((StructuredViewer)this.eContainerTreeViewer);
        if (eContainer != null && (eContainmentReference = this.getEObject((StructuredViewer)this.eContainementReferenceComboViewer)) instanceof EReference) {
            this.initializeContainmentInput(eContainer, (EReference)eContainmentReference);
        }
        this.determinePageCompletion();
    }

    private void createEObjectEClassComboViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ReferenceCreationWizardPage_eClassToCreateLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.eClassInstanceComboViewer = new ComboViewer(new Combo(parent, 12));
        this.eClassInstanceComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory){

            public String getText(Object object) {
                String result = super.getText(object);
                if (Util.isBlank((String)result) && object instanceof EObject) {
                    AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)EEFExtEObjectCreationPage.this.composedAdapterFactory);
                    result = labelProvider.getText((Object)((EObject)object).eClass());
                }
                return result;
            }
        });
        this.eClassInstanceComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eClassInstanceComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.eClassInstanceComboViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EEFExtEObjectCreationPage.this.determinePageCompletion();
            }
        };
        this.eClassInstanceComboViewer.addSelectionChangedListener(this.eClassInstanceComboViewerListener);
    }

    private void determinePageCompletion() {
        this.setMessage(null);
        boolean isPageComplete = false;
        if (this.eReference.isContainment()) {
            isPageComplete = this.isCompleteViewer(true, (StructuredViewer)this.eClassInstanceComboViewer, Messages.ReferenceCreationWizardPage_missingEClassToCreate);
        } else {
            String message = MessageFormat.format(Messages.ReferenceCreationWizardPage_missingEContainer, this.eReference.getEReferenceType().getName());
            isPageComplete = this.isCompleteViewer(true, (StructuredViewer)this.eContainerTreeViewer, message);
            isPageComplete = this.isCompleteViewer(isPageComplete, (StructuredViewer)this.eContainementReferenceComboViewer, Messages.ReferenceCreationWizardPage_missingContainmentEReference);
            isPageComplete = this.isCompleteViewer(isPageComplete, (StructuredViewer)this.eClassInstanceComboViewer, Messages.ReferenceCreationWizardPage_missingEClassToCreate);
        }
        this.setPageComplete(isPageComplete);
    }

    private boolean isCompleteViewer(boolean isCurrentlyComplete, StructuredViewer viewer, String errorMessage) {
        boolean isComplete = isCurrentlyComplete;
        if (isCurrentlyComplete) {
            boolean isViewerComplete = this.getEObject(viewer) != null;
            boolean bl = isComplete = isComplete && isViewerComplete;
            if (!isViewerComplete) {
                this.setMessage(errorMessage, 3);
            }
        }
        return isComplete;
    }

    public void performFinish(IProgressMonitor monitor) {
        EObject eObject = this.getEObject((StructuredViewer)this.eClassInstanceComboViewer);
        if (eObject != null) {
            if (this.eReference.isContainment() && this.eReference.isMany()) {
                this.performFinishMultiValuedContainmentReference(eObject);
            } else if (this.eReference.isContainment() && !this.eReference.isMany()) {
                this.performFinistMonoValuedContainmentReference(eObject);
            } else if (!this.eReference.isContainment() && this.eReference.isMany()) {
                this.performFinistMultiValuedNonContainmentReference(eObject);
            } else if (!this.eReference.isContainment() && !this.eReference.isMany()) {
                this.performFinistMonoValuedNonContainmentReference(eObject);
            }
        }
    }

    private void performFinishMultiValuedContainmentReference(EObject value) {
        this.eContainmentAdd(this.target, this.eReference, value);
    }

    private void performFinistMonoValuedContainmentReference(EObject value) {
        this.target.eSet((EStructuralFeature)this.eReference, (Object)value);
    }

    private void performFinistMultiValuedNonContainmentReference(EObject value) {
        EObject eContainer = this.getEObject((StructuredViewer)this.eContainerTreeViewer);
        EObject eContainmentReferenceEObject = this.getEObject((StructuredViewer)this.eContainementReferenceComboViewer);
        if (eContainer != null && eContainmentReferenceEObject instanceof EReference) {
            EReference eContainmentReference = (EReference)eContainmentReferenceEObject;
            if (eContainmentReference.isMany()) {
                this.eContainmentAdd(eContainer, (EReference)eContainmentReferenceEObject, value);
            } else {
                eContainer.eSet((EStructuralFeature)eContainmentReference, (Object)value);
            }
            this.eContainmentAdd(this.target, this.eReference, value);
        }
    }

    private void performFinistMonoValuedNonContainmentReference(EObject value) {
        EObject eContainer = this.getEObject((StructuredViewer)this.eContainerTreeViewer);
        EObject eContainmentReferenceEObject = this.getEObject((StructuredViewer)this.eContainementReferenceComboViewer);
        if (eContainer != null && eContainmentReferenceEObject instanceof EReference) {
            EReference eContainmentReference = (EReference)eContainmentReferenceEObject;
            if (eContainmentReference.isMany()) {
                this.eContainmentAdd(eContainer, (EReference)eContainmentReferenceEObject, value);
            } else {
                eContainer.eSet((EStructuralFeature)eContainmentReference, (Object)value);
            }
            this.target.eSet((EStructuralFeature)this.eReference, (Object)value);
        }
    }

    private void eContainmentAdd(EObject eContainer, EReference eContainmentReference, EObject eObject) {
        Object value = eContainer.eGet((EStructuralFeature)eContainmentReference);
        if (value instanceof EList) {
            EList objects = (EList)value;
            objects.add((Object)eObject);
        }
    }

    public void dispose() {
        super.dispose();
        this.composedAdapterFactory.dispose();
        this.eClassInstanceComboViewer.removeSelectionChangedListener(this.eClassInstanceComboViewerListener);
    }
}

