/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.ColorModeHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeActionEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeTypeEditPart;
import org.eclipse.emf.henshin.diagram.edit.policies.HenshinTextSelectionEditPolicy;
import org.eclipse.emf.henshin.diagram.edit.policies.NodeGraphicalEditPolicy;
import org.eclipse.emf.henshin.diagram.edit.policies.NodeItemSemanticEditPolicy;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.provider.util.HenshinColorMode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class NodeEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 3001;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private RuleEditHelper.RuleListener ruleListener;

    public NodeEditPart(View view) {
        super(view);
    }

    public void addSemanticListeners() {
        super.addSemanticListeners();
        Node node = (Node)this.getNotationView().getElement();
        this.ruleListener = new RuleEditHelper.RuleListener((EObject)node){

            public void notifyChanged(Notification event) {
                super.notifyChanged(event);
                if (event.getEventType() == 8) {
                    return;
                }
                if (NodeEditPart.this.isActive() && NodeEditPart.this.getNotationView().getElement() instanceof Node && NodeEditPart.this.getParent() != null) {
                    NodeEditPart.this.refreshVisuals();
                }
            }
        };
    }

    public void removeSemanticListeners() {
        super.removeSemanticListeners();
        if (this.ruleListener != null) {
            this.ruleListener.dispose();
            this.ruleListener = null;
        }
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        IGraphicalEditPart actionLabel = this.getChildBySemanticHint(String.valueOf(5003));
        if (actionLabel instanceof NodeActionEditPart) {
            actionLabel.refresh();
        }
        ArrayList cons = new ArrayList();
        cons.addAll(this.getSourceConnections());
        cons.addAll(this.getTargetConnections());
        for (Object con : cons) {
            if (!(con instanceof EdgeEditPart)) continue;
            ((EdgeEditPart)((Object)con)).refresh();
        }
    }

    public void refreshForegroundColor() {
        HenshinColorMode.Color color = ColorModeHelper.getActionColor(this.getNotationView(), true);
        if (color != null) {
            this.setForegroundColor(ColorModeHelper.getSWTColor(color));
        } else {
            super.refreshForegroundColor();
        }
    }

    public void refreshBackgroundColor() {
        HenshinColorMode.Color color = ColorModeHelper.getActionColor(this.getNotationView(), false);
        if (color != null) {
            this.setBackgroundColor(ColorModeHelper.getSWTColor(color));
        } else {
            super.refreshBackgroundColor();
        }
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("GraphicalNodeEditPolicy");
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeGraphicalEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    public boolean shouldDrawShadow() {
        Action action = this.getNodeAction();
        return action != null && action.isMulti();
    }

    public Action getNodeAction() {
        Node node = this.getNode();
        if (node != null) {
            return node.getAction();
        }
        return null;
    }

    public Node getNode() {
        return (Node)this.getNotationView().getElement();
    }

    protected void createDefaultEditPoliciesGen() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new NodeItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        ConstrainedToolbarLayoutEditPolicy lep = new ConstrainedToolbarLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child.getEditPolicy((Object)"PrimaryDrag Policy") == null && child instanceof ITextAwareEditPart) {
                    return new HenshinTextSelectionEditPolicy();
                }
                return super.createChildEditPolicy(child);
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new NodeFigure();
        return this.primaryShape;
    }

    public NodeFigure getPrimaryShape() {
        return (NodeFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof NodeTypeEditPart) {
            ((NodeTypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getNodeTypeLabel());
            return true;
        }
        if (childEditPart instanceof NodeActionEditPart) {
            ((NodeActionEditPart)childEditPart).setLabel(this.getPrimaryShape().getNodeActionLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof NodeTypeEditPart) {
            return true;
        }
        return childEditPart instanceof NodeActionEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
        return result;
    }

    protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodeFigure() {
        org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(HenshinVisualIDRegistry.getType(5002));
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(HenshinElementTypes.Edge_4001);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof NodeEditPart) {
            types.add(HenshinElementTypes.Edge_4001);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == HenshinElementTypes.Edge_4001) {
            types.add(HenshinElementTypes.Node_3001);
        }
        return types;
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(HenshinElementTypes.Edge_4001);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == HenshinElementTypes.Edge_4001) {
            types.add(HenshinElementTypes.Node_3001);
        }
        return types;
    }

    public EditPart getTargetEditPart(Request request) {
        CreateElementRequestAdapter adapter;
        IElementType type;
        if (request instanceof CreateViewAndElementRequest && (type = (IElementType)(adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter()).getAdapter(IElementType.class)) == HenshinElementTypes.Attribute_3002) {
            return this.getChildBySemanticHint(HenshinVisualIDRegistry.getType(7002));
        }
        return super.getTargetEditPart(request);
    }

    public class NodeFigure
    extends RectangleFigure {
        private WrappingLabel fNodeActionLabel;
        private WrappingLabel fNodeTypeLabel;
        public static final int SHADOW_WIDTH = 5;

        public NodeFigure() {
            ToolbarLayout layoutThis = new ToolbarLayout();
            layoutThis.setStretchMinorAxis(true);
            layoutThis.setMinorAlignment(0);
            layoutThis.setSpacing(0);
            layoutThis.setVertical(true);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.createContents();
        }

        private void createContents() {
            this.fNodeActionLabel = new WrappingLabel();
            this.fNodeActionLabel.setText("none");
            this.fNodeActionLabel.setBorder((Border)new MarginBorder(NodeEditPart.this.getMapMode().DPtoLP(0), NodeEditPart.this.getMapMode().DPtoLP(2), NodeEditPart.this.getMapMode().DPtoLP(0), NodeEditPart.this.getMapMode().DPtoLP(2)));
            this.add((IFigure)this.fNodeActionLabel);
            this.fNodeTypeLabel = new WrappingLabel();
            this.fNodeTypeLabel.setText("Node");
            this.fNodeTypeLabel.setBorder((Border)new MarginBorder(NodeEditPart.this.getMapMode().DPtoLP(0), NodeEditPart.this.getMapMode().DPtoLP(2), NodeEditPart.this.getMapMode().DPtoLP(0), NodeEditPart.this.getMapMode().DPtoLP(2)));
            this.add((IFigure)this.fNodeTypeLabel);
        }

        public WrappingLabel getNodeActionLabel() {
            return this.fNodeActionLabel;
        }

        public WrappingLabel getNodeTypeLabel() {
            return this.fNodeTypeLabel;
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension pref = super.getPreferredSize(wHint, hHint);
            if (NodeEditPart.this.shouldDrawShadow()) {
                pref.width += 5;
                pref.height += 5;
            }
            return pref;
        }

        protected void fillShape(Graphics graphics) {
            if (NodeEditPart.this.shouldDrawShadow()) {
                Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
                graphics.fillRectangle(r.x, r.y, r.width - 5, r.height - 5);
                graphics.fillRectangle(r.x + 5, r.y + 5, r.width, r.height);
            } else {
                super.fillShape(graphics);
            }
        }

        protected void outlineShape(Graphics graphics) {
            if (NodeEditPart.this.shouldDrawShadow()) {
                float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
                int inset1 = (int)Math.floor(lineInset);
                int inset2 = (int)Math.ceil(lineInset);
                Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
                r.x += inset1;
                r.y += inset1;
                r.width -= inset1 + inset2;
                r.height -= inset1 + inset2;
                graphics.drawRectangle(r.x, r.y, r.width - 5, r.height - 5);
                graphics.setForegroundColor(this.getShadowColor());
                graphics.drawLine(r.x + 5, r.y + r.height - 5, r.x + 5, r.y + r.height);
                graphics.drawLine(r.x + r.width - 5, r.y + 5, r.x + r.width, r.y + 5);
                graphics.drawLine(r.x + 5, r.y + r.height, r.x + r.width, r.y + r.height);
                graphics.drawLine(r.x + r.width, r.y + 5, r.x + r.width, r.y + r.height);
                graphics.setForegroundColor(this.getForegroundColor());
            } else {
                super.outlineShape(graphics);
            }
        }

        public Color getShadowColor() {
            Color c = this.getForegroundColor();
            return new Color(c.getDevice(), Math.min(255, c.getRed() + (255 - c.getRed()) / 2), Math.min(255, c.getGreen() + (255 - c.getGreen()) / 2), Math.min(255, c.getBlue() + (255 - c.getBlue()) / 2));
        }
    }
}

