/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.mutualexclusion;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class ALAPBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/mutualexclusion";
    static final int GRAPH_SIZE_MIN = 1000;
    static final int GRAPH_SIZE_MAX = 10000;
    static final int STEP = 1000;
    static final int ITERATIONS = 3;

    public static void run(String path) {
        System.out.println("***************** Alap Transformation Sequence***************");
        System.out.println("Memory allocated:" + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "Mb");
        System.out.println("GRAPH_SIZE_MIN:1000");
        System.out.println("GRAPH_SIZE_MAX:10000");
        System.out.println("STEP:1000");
        System.out.println("ITERATIONS:3 , first iteration is not included into evaluation");
        System.out.println("*************************************************************");
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("mutualexclusion.henshin", false);
        EObject container = resourceSet.getEObject("initialgraph.xmi");
        Rule newRule = (Rule)module.getUnit("newRule");
        Unit alap2Unit = module.getUnit("alap2");
        int graphSize = 1000;
        while (graphSize <= 10000) {
            long sum = 0L;
            int j = 0;
            while (j < 3) {
                EObject container2 = EcoreUtil.copy((EObject)container);
                EGraphImpl graph = new EGraphImpl(container2);
                EngineImpl engine = new EngineImpl();
                UnitApplicationImpl unitAppl = new UnitApplicationImpl((Engine)engine);
                unitAppl.setEGraph((EGraph)graph);
                RuleApplicationImpl ruleAppl = new RuleApplicationImpl((Engine)engine);
                ruleAppl.setEGraph((EGraph)graph);
                long startTime = System.currentTimeMillis();
                ruleAppl.setRule(newRule);
                int i = 0;
                while (i < graphSize - 2) {
                    ruleAppl.execute(null);
                    ++i;
                }
                unitAppl.setUnit(alap2Unit);
                unitAppl.execute(null);
                long finishTime = System.currentTimeMillis();
                if (j != 0) {
                    sum = sum + finishTime - startTime;
                }
                ++j;
            }
            System.out.println("Graph size: " + graphSize + "  average time:" + sum / 2L);
            graphSize += 1000;
        }
    }

    public static void main(String[] args) {
        ALAPBenchmark.run(PATH);
    }
}

