/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.script.ScriptEngine;
import org.eclipse.emf.henshin.interpreter.matching.conditions.AttributeCondition;

public class ConditionHandler {
    final Collection<AttributeCondition> attributeConditions = new ArrayList<AttributeCondition>();
    final Map<String, Collection<AttributeCondition>> involvedConditions = new HashMap<String, Collection<AttributeCondition>>();
    final Collection<String> assignedParameters = new HashSet<String>();
    final ScriptEngine scriptEngine;

    public ConditionHandler(Map<String, Collection<String>> conditionParameters, ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
        for (String condition : conditionParameters.keySet()) {
            Collection<String> usedParameters = conditionParameters.get(condition);
            AttributeCondition attCondition = new AttributeCondition(condition, usedParameters, scriptEngine);
            this.attributeConditions.add(attCondition);
            for (String usedParameter : usedParameters) {
                Collection<AttributeCondition> conditionList = this.involvedConditions.get(usedParameter);
                if (conditionList == null) {
                    conditionList = new ArrayList<AttributeCondition>();
                    this.involvedConditions.put(usedParameter, conditionList);
                }
                conditionList.add(attCondition);
            }
        }
    }

    public boolean setParameter(String paramName, Object value) {
        boolean result = true;
        if (this.assignedParameters.add(paramName)) {
            this.scriptEngine.put(paramName, value);
            Collection<AttributeCondition> conditionList = this.involvedConditions.get(paramName);
            if (conditionList != null) {
                for (AttributeCondition condition : conditionList) {
                    condition.parameters.remove(paramName);
                    boolean bl = result = result && condition.eval();
                }
            }
        }
        return result;
    }

    public void unsetParameter(String paramName) {
        Collection<AttributeCondition> conditionList;
        if (this.assignedParameters.remove(paramName) && (conditionList = this.involvedConditions.get(paramName)) != null) {
            for (AttributeCondition condition : this.involvedConditions.get(paramName)) {
                condition.parameters.add(paramName);
            }
        }
    }

    public boolean isSet(String paramName) {
        return this.assignedParameters.contains(paramName);
    }

    public Object getParameter(String paramName) {
        return this.scriptEngine.get(paramName);
    }

    public Map<String, Object> getParameterValues() {
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        for (String paramName : this.assignedParameters) {
            paramValues.put(paramName, this.scriptEngine.get(paramName));
        }
        return paramValues;
    }
}

