/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;

public class TypeConstraint
implements UnaryConstraint {
    public final EClass type;
    public final boolean strictTyping;

    public TypeConstraint(EClass type, boolean strictTyping) {
        this.type = type;
        this.strictTyping = strictTyping;
    }

    @Override
    public boolean check(DomainSlot slot) {
        return !slot.locked || this.isValid(slot.value);
    }

    protected boolean isValid(EObject value) {
        return this.strictTyping ? this.type == value.eClass() : this.type.isSuperTypeOf(value.eClass());
    }

    public boolean initDomain(DomainSlot slot, EGraph graph) {
        if (slot.domain == null) {
            slot.domain = graph.getDomain(this.type, this.strictTyping);
            return !slot.domain.isEmpty();
        }
        if (slot.domain.isEmpty()) {
            return false;
        }
        int size = slot.domain.size();
        int i = size - 1;
        while (i >= 0) {
            EObject object = slot.domain.get(i);
            if (object == null || !this.isValid(object)) {
                slot.domain.remove(i);
            }
            --i;
        }
        return !slot.domain.isEmpty();
    }

    public boolean instantiationPossible(DomainSlot slot, EGraph graph) {
        return slot.locked ? this.isValid(slot.value) : graph.getDomainSize(this.type, this.strictTyping) > 0;
    }
}

