/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.henshin.diagram.part.HenshinCreationWizardPage;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorUtil;
import org.eclipse.emf.henshin.diagram.part.Messages;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.presentation.ImportPackagesWizardPage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class HenshinCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected HenshinCreationWizardPage diagramModelFilePage;
    protected HenshinCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;
    private ImportPackagesWizardPage importPackagesPage;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.HenshinCreationWizardTitle);
        this.setDefaultPageImageDescriptor(HenshinDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewHenshinWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new HenshinCreationWizardPage("DiagramModelFile", this.getSelection(), "henshin_diagram");
        this.diagramModelFilePage.setTitle(Messages.HenshinCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.HenshinCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new HenshinCreationWizardPage("DomainModelFile", this.getSelection(), "henshin"){
            private boolean activated;
            {
                this.activated = false;
            }

            public boolean isPageComplete() {
                return this.activated && super.isPageComplete();
            }

            public void setVisible(boolean visible) {
                if (visible) {
                    this.activated = true;
                    String fileName = HenshinCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".henshin_diagram".length());
                    this.setFileName(HenshinDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "henshin"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.HenshinCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.HenshinCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
        this.importPackagesPage = new ImportPackagesWizardPage("importPackages");
        this.addPage((IWizardPage)this.importPackagesPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                HenshinCreationWizard.this.diagram = HenshinDiagramEditorUtil.createDiagram(HenshinCreationWizard.this.diagramModelFilePage.getURI(), HenshinCreationWizard.this.domainModelFilePage.getURI(), monitor);
                final ResourceSet resourceSet = HenshinCreationWizard.this.diagram.getResourceSet();
                Diagram theDiagram = (Diagram)HenshinCreationWizard.this.diagram.getContents().get(0);
                final Module module = (Module)theDiagram.getElement();
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)theDiagram);
                if (editingDomain != null) {
                    AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Import Packages", null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            for (URI uri : (this).HenshinCreationWizard.this.importPackagesPage.getPackageURIs()) {
                                EObject object = resourceSet.getEObject(uri, true);
                                if (!(object instanceof EPackage)) continue;
                                module.getImports().add((Object)((EPackage)object));
                            }
                            try {
                                module.eResource().save(null);
                                (this).HenshinCreationWizard.this.diagram.save(null);
                            }
                            catch (IOException e) {
                                throw new ExecutionException("Error saving Henshin model/diagram", (Throwable)e);
                            }
                            return CommandResult.newOKCommandResult();
                        }
                    };
                    try {
                        command.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        HenshinDiagramEditorPlugin.getInstance().logError("Error creating diagram", e);
                    }
                }
                if (HenshinCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && HenshinCreationWizard.this.diagram != null) {
                    try {
                        HenshinDiagramEditorUtil.openDiagram(HenshinCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)HenshinCreationWizard.this.getContainer().getShell(), (String)Messages.HenshinCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.HenshinCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                HenshinDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

