/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.commands.GraphComplexUnsetCommand;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.provider.ModelElementItemProvider;
import org.eclipse.emf.henshin.provider.trans.NestedConditionMappingItemProvider;

public class NestedConditionItemProvider
extends ModelElementItemProvider {
    public static final int MAX_UNFOLD_MAPPINGS = 5;

    public NestedConditionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.NESTED_CONDITION__CONCLUSION);
            this.childrenFeatures.add(HenshinPackage.Literals.NESTED_CONDITION__MAPPINGS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/NestedCondition"));
    }

    public Collection<?> getChildren(Object object) {
        Collection childrenList = super.getChildren(object);
        NestedCondition nc = (NestedCondition)object;
        if (nc.getMappings().size() > 5) {
            childrenList.removeAll((Collection<?>)nc.getMappings());
            childrenList.add(new NestedConditionMappingItemProvider(this.adapterFactory, (EObject)nc));
        }
        return childrenList;
    }

    @Override
    public String getText(Object object) {
        return this.getString("_UI_NestedCondition_type");
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(NestedCondition.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                this.notifyMappedNodes(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    private void notifyMappedNodes(Notification notification) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        switch (notification.getEventType()) {
            case 4: {
                mappings.add((Mapping)notification.getOldValue());
                break;
            }
            case 3: {
                mappings.add((Mapping)notification.getNewValue());
                break;
            }
            case 5: {
                mappings.addAll((Collection)notification.getNewValue());
                break;
            }
            case 6: {
                mappings.addAll((Collection)notification.getOldValue());
            }
        }
        if (!mappings.isEmpty()) {
            for (Mapping mapping : mappings) {
                if (mapping.getImage() != null) {
                    this.notifyNodeForRefresh(notification, mapping.getImage());
                }
                if (mapping.getOrigin() == null) continue;
                this.notifyNodeForRefresh(notification, mapping.getOrigin());
            }
        }
    }

    private void notifyNodeForRefresh(Notification notification, Node node) {
        if (node != null) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)node, Node.class);
            ViewerNotification notif = new ViewerNotification(notification, (Object)node, false, true);
            adapter.fireNotifyChanged((Notification)notif);
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.NESTED_CONDITION__CONCLUSION, HenshinFactory.eINSTANCE.createGraph()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.NESTED_CONDITION__MAPPINGS, HenshinFactory.eINSTANCE.createMapping()));
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == HenshinPackage.eINSTANCE.getNestedCondition_Conclusion()) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == HenshinPackage.Literals.NESTED_CONDITION__CONCLUSION && value == SetCommand.UNSET_VALUE) {
            return new GraphComplexUnsetCommand(domain, owner, feature);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }
}

