/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.editor.commands.RemoveNegationCommand;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Not;

public class NegateFormulaCommand
extends AbstractOverrideableCommand {
    protected Formula formula;
    protected Not not;
    protected Collection<?> affectedObjects;

    public NegateFormulaCommand(EditingDomain domain, Formula formula) {
        super(domain);
        this.formula = formula;
    }

    protected boolean prepare() {
        if (this.formula instanceof Not) {
            RemoveNegationCommand removeNegationCmd = new RemoveNegationCommand();
            removeNegationCmd.setNot((Not)this.formula);
            this.setOverride((Command)removeNegationCmd);
        } else if (this.formula.eContainer() instanceof Not) {
            RemoveNegationCommand removeNegationCmd = new RemoveNegationCommand();
            removeNegationCmd.setNot((Not)this.formula.eContainer());
            this.setOverride((Command)removeNegationCmd);
        }
        return true;
    }

    public void doExecute() {
        this.not = HenshinFactory.eINSTANCE.createNot();
        this.doRedo();
    }

    public void doRedo() {
        this.formula.eContainer().eSet(this.formula.eContainingFeature(), (Object)this.not);
        this.not.setChild(this.formula);
        this.affectedObjects = Collections.singleton(this.not);
    }

    public void doUndo() {
        this.not.eContainer().eSet(this.not.eContainingFeature(), (Object)this.formula);
        this.affectedObjects = Collections.singleton(this.formula);
    }

    public boolean doCanUndo() {
        return true;
    }

    public Collection<?> doGetAffectedObjects() {
        return this.affectedObjects;
    }
}

