/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.giraph.GiraphLibraries;
import org.eclipse.emf.henshin.giraph.GiraphRuleData;
import org.eclipse.emf.henshin.giraph.GiraphUtil;
import org.eclipse.emf.henshin.giraph.GiraphValidator;
import org.eclipse.emf.henshin.giraph.templates.BuildJarLaunchTemplate;
import org.eclipse.emf.henshin.giraph.templates.CompileXmlTemplate;
import org.eclipse.emf.henshin.giraph.templates.GetLibsXmlTemplate;
import org.eclipse.emf.henshin.giraph.templates.GiraphRuleTemplate;
import org.eclipse.emf.henshin.giraph.templates.HenshinUtilTemplate;
import org.eclipse.emf.henshin.giraph.templates.InstallHadoopXmlTemplate;
import org.eclipse.emf.henshin.giraph.templates.LaunchConfTemplate;
import org.eclipse.emf.henshin.giraph.templates.LaunchEnvXmlTemplate;
import org.eclipse.emf.henshin.giraph.templates.LaunchXmlTemplate;
import org.eclipse.emf.henshin.giraph.templates.PomXmlTemplate;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class GiraphGenerator
extends GiraphValidator {
    protected int refreshJobs = 0;

    public GiraphGenerator() {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                if ("Refreshing resources...".equalsIgnoreCase(event.getJob().getName())) {
                    ++GiraphGenerator.this.refreshJobs;
                }
            }
        });
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException {
        IFile jsonFile;
        String inputCode;
        String buildJarLaunch;
        String installHadoopXml;
        String launchConf;
        String launchXml;
        String launchEnvXml;
        String pomXml;
        String compileXml;
        String utilCode;
        String giraphCode;
        String getLibsXml;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Generating Giraph Project", this.testEnvironment ? 40 : 30);
        monitor.subTask("Executing Templates...");
        try {
            IVMInstall jvm = JavaRuntime.getDefaultVMInstall();
            String javaHome = jvm.getInstallLocation().getAbsolutePath();
            Map<Rule, GiraphRuleData> ruleData = GiraphUtil.generateRuleData(this.mainUnit);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("javaHome", javaHome);
            args.put("ruleData", ruleData);
            args.put("mainUnit", this.mainUnit);
            args.put("className", this.className);
            args.put("inputName", this.inputName);
            args.put("packageName", this.packageName);
            args.put("projectName", this.projectName);
            args.put("hostName", GiraphGenerator.getHostName());
            args.put("masterLogging", this.masterLogging);
            args.put("vertexLogging", this.vertexLogging);
            args.put("useUUIDs", this.useUUIDs);
            args.put("segmentCount", 1);
            args.put("stairCount", 3);
            getLibsXml = new GetLibsXmlTemplate().generate(args);
            giraphCode = new GiraphRuleTemplate().generate(args);
            utilCode = new HenshinUtilTemplate().generate(args);
            compileXml = new CompileXmlTemplate().generate(args);
            pomXml = new PomXmlTemplate().generate(args);
            launchEnvXml = new LaunchEnvXmlTemplate().generate(args);
            launchXml = new LaunchXmlTemplate().generate(args);
            launchConf = new LaunchConfTemplate().generate(args);
            installHadoopXml = new InstallHadoopXmlTemplate().generate(args);
            buildJarLaunch = new BuildJarLaunchTemplate().generate(args);
            inputCode = this.inputGraph != null ? GiraphUtil.getInstanceCode(this.inputGraph) : null;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.henshin.giraph", 0, "Error executing templates: " + e.getMessage(), (Throwable)e));
        }
        monitor.worked(1);
        monitor.subTask("Initializing Project...");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(this.projectName);
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        monitor.worked(1);
        IFolder binFolder = this.createFolder((IContainer)project, "bin");
        javaProject.setOutputLocation(binFolder.getFullPath(), null);
        IFolder srcFolder = this.createFolder((IContainer)project, "src");
        IFolder mainFolder = this.createFolder((IContainer)srcFolder, "main");
        IFolder testFolder = this.createFolder((IContainer)srcFolder, "test");
        IFolder javaFolder = this.createFolder((IContainer)mainFolder, "java");
        IFolder javaTestFolder = this.createFolder((IContainer)testFolder, "java");
        IFolder assemblyFolder = this.createFolder((IContainer)mainFolder, "assembly");
        IFolder libFolder = this.createFolder((IContainer)project, "lib");
        IFolder externalToolBuildersFolder = this.createFolder((IContainer)project, ".externalToolBuilders");
        IFolder inputFolder = this.createFolder((IContainer)project, "input");
        this.createFolder((IContainer)project, "output");
        IFolder launchFolder = this.createFolder((IContainer)project, "launch");
        monitor.worked(1);
        IFile getLibsXmlFile = this.writeFile((IContainer)libFolder, "get-libs.xml", getLibsXml);
        monitor.worked(1);
        monitor.subTask("Fetching Giraph and Hadoop Libraries...");
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(getLibsXmlFile.getLocation().toOSString());
        runner.setArguments("-Dmessage=\"Fetching Giraph and Hadoop Libraries\" -verbose");
        runner.run((IProgressMonitor)new SubProgressMonitor(monitor, 5));
        monitor.subTask("Generating Code...");
        ArrayList<IFile> libraries = new ArrayList<IFile>();
        ArrayList<IFile> sourceAttachments = new ArrayList<IFile>();
        for (Map.Entry<URI, URI> lib : GiraphLibraries.LIBRARIES.entrySet()) {
            libraries.add(libFolder.getFile(lib.getKey().lastSegment()));
            sourceAttachments.add(lib.getValue() != null ? libFolder.getFile(lib.getValue().lastSegment()) : null);
        }
        this.setupClassPath(javaProject, new IFolder[]{javaFolder, javaTestFolder}, libraries.toArray(new IFile[0]), sourceAttachments.toArray(new IFile[0]));
        IPackageFragmentRoot packRoot = javaProject.getPackageFragmentRoot((IResource)javaFolder);
        IPackageFragment pack = packRoot.createPackageFragment(this.packageName, false, null);
        IFile javaUnitFile = this.writeFile((IContainer)((IFolder)pack.getResource()), String.valueOf(this.className) + ".java", giraphCode);
        monitor.worked(1);
        this.writeFile((IContainer)((IFolder)pack.getResource()), "HenshinUtil.java", utilCode);
        monitor.worked(1);
        if (inputCode != null && !(jsonFile = inputFolder.getFile((IPath)new Path(String.valueOf(this.inputName) + ".json"))).exists()) {
            this.writeFile(jsonFile, inputCode);
        }
        monitor.worked(1);
        this.writeFile((IContainer)launchFolder, String.valueOf(this.className) + ".xml", launchXml);
        this.writeFile((IContainer)launchFolder, String.valueOf(this.className) + ".launch", launchConf);
        monitor.worked(1);
        this.writeFile((IContainer)assemblyFolder, "compile.xml", compileXml);
        monitor.worked(1);
        this.writeFile((IContainer)project, "pom.xml", pomXml);
        monitor.worked(1);
        this.writeFile((IContainer)project, "launch-env.xml", launchEnvXml);
        monitor.worked(1);
        this.writeFile((IContainer)externalToolBuildersFolder, "build-jar.launch", buildJarLaunch);
        monitor.worked(1);
        int refreshJobsBefore = this.refreshJobs;
        this.removeExternalToolBuilder(project, "build-jar.launch");
        this.addExternalToolBuilder(project, "build-jar.launch", true);
        monitor.worked(1);
        if (this.testEnvironment) {
            monitor.subTask("Installing Hadoop Test Environment...");
            IFolder testenvFolder = this.createFolder((IContainer)project, "testenv");
            IFile installHadoop = this.writeFile((IContainer)testenvFolder, "install-hadoop.xml", installHadoopXml);
            runner = new AntRunner();
            runner.setBuildFileLocation(installHadoop.getLocation().toOSString());
            runner.setArguments("-Dmessage=\"Installing Hadoop Test Environment\" -verbose");
            runner.run((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        monitor.subTask("Building Jar...");
        subMonitor.beginTask("Building Jar...", 900);
        int i = 0;
        while (i < 900) {
            if (this.refreshJobs > refreshJobsBefore) break;
            subMonitor.worked(1);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        subMonitor.done();
        monitor.done();
        return javaUnitFile;
    }

    protected void addExternalToolBuilder(IProject project, String name, boolean append) throws CoreException {
        ICommand[] oldCommands;
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = oldCommands = description.getBuildSpec();
        int n = oldCommands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand com = iCommandArray[n2];
            String val = (String)com.getArguments().get("LaunchConfigHandle");
            if (val != null && val.endsWith(name)) {
                return;
            }
            ++n2;
        }
        ICommand[] newCommands = new ICommand[oldCommands.length + 1];
        System.arraycopy(oldCommands, 0, newCommands, append ? 0 : 1, oldCommands.length);
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        Map commandArgs = command.getArguments();
        commandArgs.put("LaunchConfigHandle", "<project>/.externalToolBuilders/" + name);
        command.setArguments(commandArgs);
        command.setBuilding(6, true);
        newCommands[append ? newCommands.length - 1 : 0] = command;
        description.setBuildSpec(newCommands);
        project.setDescription(description, null);
    }

    protected IFolder createFolder(IContainer parent, String name) throws CoreException {
        IFolder folder = parent.getFolder((IPath)new Path(name));
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        return folder;
    }

    protected void removeExternalToolBuilder(IProject project, String name) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] oldCommands = description.getBuildSpec();
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
        ICommand[] iCommandArray = oldCommands;
        int n = oldCommands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand com = iCommandArray[n2];
            String val = (String)com.getArguments().get("LaunchConfigHandle");
            if (val == null || !val.endsWith(name)) {
                newCommands.add(com);
            }
            ++n2;
        }
        description.setBuildSpec(newCommands.toArray(new ICommand[0]));
        project.setDescription(description, null);
    }

    protected void setupClassPath(IJavaProject javaProject, IFolder[] sourceFolders, IFile[] libraries, IFile[] sourceAttachments) throws CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        entries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7")));
        IFolder[] iFolderArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder sourceFolder = iFolderArray[n2];
            entries.add(JavaCore.newSourceEntry((IPath)javaProject.getPackageFragmentRoot((IResource)sourceFolder).getPath()));
            ++n2;
        }
        int i = 0;
        while (i < libraries.length) {
            entries.add(JavaCore.newLibraryEntry((IPath)libraries[i].getFullPath(), sourceAttachments[i] != null ? sourceAttachments[i].getFullPath() : null, null));
            ++i;
        }
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), true, null);
    }

    protected IFile writeFile(IContainer container, String fileName, String content) throws CoreException {
        IFile file = container.getFile((IPath)new Path(fileName));
        this.writeFile(file, content);
        return file;
    }

    protected void writeFile(IFile file, String content) throws CoreException {
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 1, null);
        } else {
            file.create((InputStream)new ByteArrayInputStream(content.getBytes()), 1, null);
        }
    }
}

