/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueEObject;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueObject;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugTarget;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugValue;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugVariable;

public class DebugValueList
extends HenshinDebugValue {
    private List<?> valueList;

    public DebugValueList(IDebugTarget target, EGraph graph, String declaredType, List<?> valueList) {
        super(target, graph, declaredType);
        if (declaredType == null) {
            throw new IllegalArgumentException("declaredType must not be null");
        }
        this.valueString = String.valueOf(declaredType) + "[" + valueList.size() + "]";
        this.actualType = String.valueOf(declaredType) + "[]";
        this.valueList = valueList;
        this.childrenVariables = new HenshinDebugVariable[valueList.size()];
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        if (this.hasVariables()) {
            int i = 0;
            while (i < this.valueList.size()) {
                Object listElem = this.valueList.get(i);
                EObject valueEObj = (EObject)listElem;
                List<EObject> domain = this.graph.getDomain(valueEObj.eClass(), false);
                int index = domain.indexOf(valueEObj);
                this.childrenVariables[i] = listElem instanceof List ? new HenshinDebugVariable((HenshinDebugTarget)this.getDebugTarget(), "[" + i + "]", new DebugValueList((HenshinDebugTarget)this.getDebugTarget(), this.graph, this.declaredType, this.valueList)) : (listElem instanceof EObject ? new HenshinDebugVariable((HenshinDebugTarget)this.getDebugTarget(), "[" + i + "]", new DebugValueEObject((HenshinDebugTarget)this.getDebugTarget(), this.graph, this.declaredType, (EObject)listElem, index)) : new HenshinDebugVariable((HenshinDebugTarget)this.getDebugTarget(), "[" + i + "]", new DebugValueObject((HenshinDebugTarget)this.getDebugTarget(), this.graph, this.declaredType, listElem, index)));
                ++i;
            }
            return this.childrenVariables;
        }
        return new IVariable[0];
    }
}

