/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.info;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.info.ConditionInfo;
import org.eclipse.emf.henshin.interpreter.info.RuleChangeInfo;
import org.eclipse.emf.henshin.interpreter.info.VariableInfo;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class RuleInfo {
    private Rule rule;
    private VariableInfo variableInfo;
    private RuleChangeInfo changeInfo;
    private ConditionInfo conditionInfo;
    private Set<Node> postponed;

    public RuleInfo(Rule rule, EngineImpl engine) {
        this.rule = rule;
        this.postponed = this.computePostponed();
        this.conditionInfo = new ConditionInfo(rule);
        this.variableInfo = new VariableInfo(this, engine);
        this.changeInfo = new RuleChangeInfo(rule);
    }

    private Set<Node> computePostponed() {
        HashSet<Node> result = new HashSet<Node>();
        for (Rule r : this.rule.getMultiRules()) {
            for (Mapping m : r.getMultiMappings()) {
                if (!m.getOrigin().getGraph().isLhs()) continue;
                result.add(m.getOrigin());
            }
        }
        return result;
    }

    public Rule getRule() {
        return this.rule;
    }

    public VariableInfo getVariableInfo() {
        return this.variableInfo;
    }

    public RuleChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public ConditionInfo getConditionInfo() {
        return this.conditionInfo;
    }

    public Collection<Node> getPostponed() {
        return this.postponed;
    }

    public void updateCached() {
        this.variableInfo.updateCached();
    }
}

