/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.compact;

import java.text.ParseException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.compact.CNode;
import org.eclipse.emf.henshin.model.compact.CUnit;

public class CRule
extends CUnit {
    protected CRule(String name) {
        super(HenshinFactory.eINSTANCE.createRule(name));
    }

    protected CRule(Rule rule) {
        super(rule);
    }

    public CNode createNode(EClass classifier, Action action) {
        Node node = this.getUnit().createNode(classifier);
        node.setAction(action);
        if (action.isMulti()) {
            this.restoreParameterKindsInMultiRules();
        }
        return new CNode(node);
    }

    public CNode createNode(String classifier) {
        return this.createNode(this.getEClassByName(classifier), new Action(Action.Type.PRESERVE));
    }

    public CNode createNode(String classifier, String action) {
        try {
            return this.createNode(this.getEClassByName(classifier), Action.parse(action));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(String.valueOf(action) + " is not a valid Action");
        }
    }

    public CNode createNode(String classifier, Action action) {
        return this.createNode(this.getEClassByName(classifier), action);
    }

    public CNode createNode(EClass classifier) {
        return this.createNode(classifier, new Action(Action.Type.PRESERVE));
    }

    public CNode createNode(EClass classifier, String action) {
        try {
            return this.createNode(classifier, Action.parse(action));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(String.valueOf(action) + " is not a valid Action");
        }
    }

    public CRule createAttributeCondition(String name, String value) {
        AttributeCondition cond = HenshinFactory.eINSTANCE.createAttributeCondition();
        cond.setName(name);
        cond.setConditionText(value);
        this.getUnit().getAttributeConditions().add((Object)cond);
        return this;
    }

    public CRule setPreConditionFormula(Formula formula) {
        this.getUnit().getLhs().setFormula(formula);
        return this;
    }

    public NestedCondition getPAC(String name) {
        return this.getCondition(name, true);
    }

    public Not getNAC(String name) {
        NestedCondition nc = this.getCondition(name, false);
        Not not = (Not)nc.eContainer();
        return not;
    }

    private NestedCondition getCondition(String name, boolean positive) {
        NestedCondition res = null;
        res = positive ? this.getUnit().getLhs().getPAC(name) : this.getUnit().getLhs().getNAC(name);
        if (res == null) {
            throw new RuntimeException("Could not find any Condition named: " + name);
        }
        return res;
    }

    protected void restoreParameterKindsInMultiRules() {
        EList<Rule> multis = this.getUnit().getAllMultiRules();
        for (Parameter p : this.getUnit().getParameters()) {
            for (Rule r : multis) {
                r.getParameter(p.getName()).setKind(p.getKind());
            }
        }
    }

    @Override
    public Rule getUnit() {
        return (Rule)super.getUnit();
    }

    @Override
    public void setUnit(Unit rule) {
        try {
            Rule cfr_ignored_0 = (Rule)rule;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Given Unit is not a Rule!");
        }
        super.setUnit(rule);
    }
}

