/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.core;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.emf.henshin.model.impl.MappingListImpl;

public class Lefter {
    private Rule rule;
    private HenshinFactory factory;
    public boolean enableOptimizer = false;

    public Lefter(Rule rule) {
        this.rule = rule;
        this.factory = HenshinPackage.eINSTANCE.getHenshinFactory();
    }

    public void left() {
        switch (this.leftRecursive((EObject)this.rule.getLhs(), HenshinPackage.eINSTANCE.getGraph_Formula(), this.rule.getRhs().getFormula(), this.rule.getMappings())) {
            case COLLAPSES_FALSE: {
                this.rule.getLhs().setFormula(null);
                throw new RuntimeException("Rule is not applicable since the application condition collapses to false.");
            }
            case COLLAPSES_TRUE: {
                this.rule.getLhs().setFormula(null);
                break;
            }
        }
        this.rule.getRhs().setFormula(null);
    }

    private boolean hasMoreThanOneContainer(Graph graph) {
        EList<Edge> containmentEdges = this.getEdgesTypedContainment(graph);
        int i = 0;
        while (i < containmentEdges.size() - 1) {
            int j = i + 1;
            while (j < containmentEdges.size()) {
                if (((Edge)containmentEdges.get(i)).getTarget() == ((Edge)containmentEdges.get(j)).getTarget()) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private EList<Edge> getEdgesTypedContainment(Graph graph) {
        BasicEList containmentEdges = new BasicEList();
        for (Edge edge : graph.getEdges()) {
            if (!edge.getType().isContainment()) continue;
            containmentEdges.add((Object)edge);
        }
        return containmentEdges;
    }

    private DanglingConditionResult leftNestedCondition(EObject parent, EReference parentReference, NestedCondition right, MappingList mapping) {
        Node copy;
        this.assertInjectivityAndTotality(right);
        NestedCondition left = this.factory.createNestedCondition();
        parent.eSet((EStructuralFeature)parentReference, (Object)left);
        Graph lhs = left.getHost();
        Graph newLhs = this.factory.createGraph();
        left.setConclusion(newLhs);
        Graph newRhs = right.getConclusion();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        MappingList lm = left.getMappings();
        MappingList rm = right.getMappings();
        for (Node node : lhs.getNodes()) {
            Node copy2 = (Node)copier.copy((EObject)node);
            newLhs.getNodes().add((Object)copy2);
            lm.add(node, copy2);
        }
        newLhs.getEdges().addAll(copier.copyAll((Collection)lhs.getEdges()));
        copier.copyReferences();
        MappingListImpl newMapping = new MappingListImpl();
        for (Mapping map : mapping) {
            Node l = lm.getImage(map.getOrigin(), newLhs);
            Node r = rm.getImage(map.getImage(), newRhs);
            newMapping.add(l, r);
        }
        for (Node node : newRhs.getNodes()) {
            if (rm.getOrigin(node) == null) {
                copy = (Node)EcoreUtil.copy((EObject)node);
                newLhs.getNodes().add((Object)copy);
                newMapping.add(copy, node);
                continue;
            }
            if (this.enableOptimizer && this.hasMoreThanOneContainer(newRhs)) {
                System.out.println("The graph has nodes with more than one container is removed:");
                System.out.print(newLhs.getNodes());
                return DanglingConditionResult.COLLAPSES_FALSE;
            }
            Node origin = newMapping.getOrigin(node);
            if (origin != null && node != null && origin.getType().getName() != node.getType().getName()) {
                newMapping.remove(origin, node);
                origin.setType(node.getType());
                newMapping.add(origin, node);
            }
            for (Attribute attr : node.getAttributes()) {
                if (rm.getOrigin(attr) != null) continue;
                Attribute attrOrigin = newMapping.getOrigin(attr);
                if (attrOrigin == null && origin != null) {
                    Attribute copy3 = (Attribute)EcoreUtil.copy((EObject)attr);
                    origin.getAttributes().add((Object)copy3);
                    continue;
                }
                return DanglingConditionResult.COLLAPSES_FALSE;
            }
        }
        for (Edge edge : newRhs.getEdges()) {
            if (rm.getOrigin(edge) != null) continue;
            if (newMapping.getOrigin(edge) == null) {
                copy = (Edge)EcoreUtil.copy((EObject)edge);
                Node sourceOrigin = newMapping.getOrigin(edge.getSource());
                Node targetOrigin = newMapping.getOrigin(edge.getTarget());
                if (sourceOrigin == null || targetOrigin == null) {
                    return DanglingConditionResult.COLLAPSES_FALSE;
                }
                copy.setSource(sourceOrigin);
                copy.setTarget(targetOrigin);
                newLhs.getEdges().add((Object)copy);
                continue;
            }
            return DanglingConditionResult.COLLAPSES_FALSE;
        }
        switch (this.leftRecursive((EObject)newLhs, HenshinPackage.eINSTANCE.getGraph_Formula(), newRhs.getFormula(), (MappingList)newMapping)) {
            case COLLAPSES_FALSE: {
                return DanglingConditionResult.COLLAPSES_FALSE;
            }
            case COLLAPSES_TRUE: {
                newLhs.setFormula(null);
                return DanglingConditionResult.NO_COLLAPS;
            }
        }
        return DanglingConditionResult.NO_COLLAPS;
    }

    private void assertInjectivityAndTotality(NestedCondition condition) {
        MappingList mappings = condition.getMappings();
        HashSet originNodes = new HashSet();
        originNodes.addAll(condition.getHost().getNodes());
        HashSet imageNodes = new HashSet();
        imageNodes.addAll(condition.getConclusion().getNodes());
        for (Mapping mapping : mappings) {
            if (!originNodes.remove(mapping.getOrigin())) {
                throw new RuntimeException("Mapping for non-existing node or two mappings for one node");
            }
            if (imageNodes.remove(mapping.getImage())) continue;
            throw new RuntimeException("Mapping to non-existing node or not injective");
        }
        if (!originNodes.isEmpty()) {
            throw new RuntimeException("Not total");
        }
    }

    private DanglingConditionResult leftRecursive(EObject parent, EReference parentReference, Formula formula, MappingList mappings) {
        if (formula == null) {
            return DanglingConditionResult.NO_COLLAPS;
        }
        if (formula instanceof Not) {
            return this.leftNot(parent, parentReference, (Not)formula, mappings);
        }
        if (formula instanceof And) {
            return this.leftAnd(parent, parentReference, (And)formula, mappings);
        }
        if (formula instanceof Or) {
            return this.leftOr(parent, parentReference, (Or)formula, mappings);
        }
        if (formula instanceof Xor) {
            return this.leftXor(parent, parentReference, (Xor)formula, mappings);
        }
        if (formula instanceof NestedCondition) {
            return this.leftNestedCondition(parent, parentReference, (NestedCondition)formula, mappings);
        }
        throw new IllegalArgumentException();
    }

    private DanglingConditionResult leftNot(EObject parent, EReference parentReference, Not formula, MappingList mappings) {
        Not lefted = this.factory.createNot();
        parent.eSet((EStructuralFeature)parentReference, (Object)lefted);
        return this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getUnaryFormula_Child(), formula.getChild(), mappings).negate();
    }

    private DanglingConditionResult leftAnd(EObject parent, EReference parentReference, And formula, MappingList mappings) {
        And lefted = this.factory.createAnd();
        parent.eSet((EStructuralFeature)parentReference, (Object)lefted);
        DanglingConditionResult leftResult = this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getBinaryFormula_Left(), formula.getLeft(), mappings);
        if (leftResult == DanglingConditionResult.COLLAPSES_FALSE) {
            return DanglingConditionResult.COLLAPSES_FALSE;
        }
        DanglingConditionResult rightResult = this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getBinaryFormula_Right(), formula.getRight(), mappings);
        if (rightResult == DanglingConditionResult.COLLAPSES_FALSE) {
            return DanglingConditionResult.COLLAPSES_FALSE;
        }
        if (leftResult == DanglingConditionResult.COLLAPSES_TRUE) {
            parent.eSet((EStructuralFeature)parentReference, (Object)lefted.getRight());
            return rightResult;
        }
        if (rightResult == DanglingConditionResult.COLLAPSES_TRUE) {
            parent.eSet((EStructuralFeature)parentReference, (Object)lefted.getLeft());
            return leftResult;
        }
        return DanglingConditionResult.NO_COLLAPS;
    }

    private DanglingConditionResult leftOr(EObject parent, EReference parentReference, Or formula, MappingList mappings) {
        Or lefted = this.factory.createOr();
        parent.eSet((EStructuralFeature)parentReference, (Object)lefted);
        DanglingConditionResult leftResult = this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getBinaryFormula_Left(), formula.getLeft(), mappings);
        if (leftResult == DanglingConditionResult.COLLAPSES_TRUE) {
            return DanglingConditionResult.COLLAPSES_TRUE;
        }
        DanglingConditionResult rightResult = this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getBinaryFormula_Right(), formula.getRight(), mappings);
        if (rightResult == DanglingConditionResult.COLLAPSES_TRUE) {
            return DanglingConditionResult.COLLAPSES_TRUE;
        }
        if (leftResult == DanglingConditionResult.COLLAPSES_FALSE) {
            parent.eSet((EStructuralFeature)parentReference, (Object)lefted.getRight());
            return rightResult;
        }
        if (rightResult == DanglingConditionResult.COLLAPSES_FALSE) {
            parent.eSet((EStructuralFeature)parentReference, (Object)lefted.getLeft());
            return leftResult;
        }
        return DanglingConditionResult.NO_COLLAPS;
    }

    private DanglingConditionResult leftXor(EObject parent, EReference parentReference, Xor formula, MappingList mappings) {
        Xor lefted = this.factory.createXor();
        parent.eSet((EStructuralFeature)parentReference, (Object)lefted);
        DanglingConditionResult leftResult = this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getBinaryFormula_Left(), formula.getLeft(), mappings);
        DanglingConditionResult rightResult = this.leftRecursive((EObject)lefted, HenshinPackage.eINSTANCE.getBinaryFormula_Right(), formula.getRight(), mappings);
        if (rightResult == DanglingConditionResult.COLLAPSES_FALSE) {
            parent.eSet((EStructuralFeature)parentReference, (Object)lefted.getLeft());
            return leftResult;
        }
        if (rightResult == DanglingConditionResult.COLLAPSES_TRUE) {
            Not negatedlefted = this.factory.createNot();
            negatedlefted.setChild(lefted.getLeft());
            parent.eSet((EStructuralFeature)parentReference, (Object)negatedlefted);
            return leftResult.negate();
        }
        if (leftResult == DanglingConditionResult.COLLAPSES_FALSE) {
            parent.eSet((EStructuralFeature)parentReference, (Object)lefted.getRight());
            return rightResult;
        }
        if (leftResult == DanglingConditionResult.COLLAPSES_TRUE) {
            Not negatedlefted = this.factory.createNot();
            negatedlefted.setChild(lefted.getRight());
            parent.eSet((EStructuralFeature)parentReference, (Object)negatedlefted);
            return rightResult.negate();
        }
        return DanglingConditionResult.NO_COLLAPS;
    }

    private static enum DanglingConditionResult {
        COLLAPSES_TRUE,
        COLLAPSES_FALSE,
        NO_COLLAPS;


        public DanglingConditionResult negate() {
            switch (this) {
                case COLLAPSES_FALSE: {
                    return COLLAPSES_TRUE;
                }
                case COLLAPSES_TRUE: {
                    return COLLAPSES_FALSE;
                }
            }
            return this;
        }
    }
}

