/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.ocl2gc.util;

import graph.Graph;
import java.util.Set;
import morphisms.Mapping;
import morphisms.Pair;
import nestedcondition.Morphism;
import nestedcondition.NestedconditionFactory;
import nestedcondition.NodeMapping;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.JointPairs;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.MorphismPair;

public class MorphismHelper {
    public static EList<MorphismPair> getCompleteMorphisms(Graph p, Graph c) {
        BasicEList morphismPairs = new BasicEList();
        Set<Pair> pairs = JointPairs.getJointInclusions(p, c);
        for (Pair pair : pairs) {
            MorphismPair morphismPair = new MorphismPair(p, c);
            morphismPair.setResultGraph(pair.getA().getCodomain());
            morphismPair.setMorphismP(MorphismHelper.convertMorphism(pair.getA()));
            morphismPair.setMorphismC(MorphismHelper.convertMorphism(pair.getB()));
            morphismPairs.add((Object)morphismPair);
        }
        return morphismPairs;
    }

    private static Morphism convertMorphism(morphisms.Morphism graphmorphism) {
        NestedconditionFactory factory = NestedconditionFactory.eINSTANCE;
        Morphism ecoremorphism = factory.createMorphism();
        ecoremorphism.setFrom(graphmorphism.getDomain());
        ecoremorphism.setTo(graphmorphism.getCodomain());
        for (Mapping m : graphmorphism.getMappings()) {
            NodeMapping nm = factory.createNodeMapping();
            nm.setOrigin(m.getOrigin());
            nm.setImage(m.getImage());
            ecoremorphism.getNodeMappings().add((Object)nm);
        }
        return ecoremorphism;
    }
}

