/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import nestedcondition.NestedConstraint;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.tool.commands.GC2AppCondCommand;
import org.eclipse.emf.henshin.ocl2ac.tool.optimizer.IntegrationChecker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class WizardGC2AppCond
extends Shell {
    private static final String HENSHIN = ".henshin";
    private Table tableNestedConstraints;
    private Table tableRules;
    private NestedConstraint selectedNestedConstraint = null;
    private Rule selectedRule = null;
    private IFile henshinFile = null;
    private IFile constraintFile = null;
    private final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyz0123456789";

    public WizardGC2AppCond(Display display, final IFile henshinFile, final HashMap<Integer, NestedConstraint> hashmapAllNestedconstraints, final HashMap<Integer, Rule> hashmapAllRules, IFile constraintFile) {
        super(display, 1264);
        this.henshinFile = henshinFile;
        this.constraintFile = constraintFile;
        this.setLayout((Layout)new RowLayout(256));
        Group groupNGCs = new Group((Composite)this, 0);
        groupNGCs.setLayout((Layout)new RowLayout(256));
        groupNGCs.setLayoutData((Object)new RowData(489, 240));
        groupNGCs.setText("Nested Graph Constraints");
        Label lblngc = new Label((Composite)groupNGCs, 0);
        lblngc.setText("Please select a nested graph constraint");
        this.tableNestedConstraints = new Table((Composite)groupNGCs, 67584);
        this.tableNestedConstraints.setLayoutData((Object)new RowData(452, 180));
        this.tableNestedConstraints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.tableNestedConstraints.setHeaderVisible(true);
        this.tableNestedConstraints.setLinesVisible(true);
        TableColumn clnID_NC = new TableColumn(this.tableNestedConstraints, 0);
        clnID_NC.setWidth(46);
        clnID_NC.setText("ID");
        TableColumn clnName_NC = new TableColumn(this.tableNestedConstraints, 0);
        clnName_NC.setWidth(431);
        clnName_NC.setText("Nested Graph Constraint (C)");
        this.fillTableNestedConstraints(hashmapAllNestedconstraints);
        this.tableNestedConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardGC2AppCond.this.tableNestedConstraints.getItemCount() > 0) {
                    TableItem[] selectedItem = WizardGC2AppCond.this.tableNestedConstraints.getSelection();
                    Integer nestedConstraintID = Integer.parseInt(selectedItem[0].getText(0));
                    WizardGC2AppCond.this.selectedNestedConstraint = (NestedConstraint)hashmapAllNestedconstraints.get(nestedConstraintID);
                }
            }
        });
        Group groupRules = new Group((Composite)this, 0);
        groupRules.setLayoutData((Object)new RowData(490, 240));
        groupRules.setText("Rules");
        groupRules.setLayout((Layout)new RowLayout(256));
        Label lblRule = new Label((Composite)groupRules, 0);
        lblRule.setText("Please select a rule");
        this.tableRules = new Table((Composite)groupRules, 67584);
        this.tableRules.setLayoutData((Object)new RowData(452, 180));
        this.tableRules.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.tableRules.setHeaderVisible(true);
        this.tableRules.setLinesVisible(true);
        TableColumn clnID_rule = new TableColumn(this.tableRules, 0);
        clnID_rule.setWidth(48);
        clnID_rule.setText("ID");
        TableColumn clnName_Rule = new TableColumn(this.tableRules, 0);
        clnName_Rule.setWidth(429);
        clnName_Rule.setText("Rule (R)");
        this.fillTableRules(hashmapAllRules);
        Group groupButtons = new Group((Composite)this, 0);
        groupButtons.setLayoutData((Object)new RowData(490, 120));
        this.tableRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardGC2AppCond.this.tableRules.getItemCount() > 0) {
                    TableItem[] selectedItem = WizardGC2AppCond.this.tableRules.getSelection();
                    Integer ruleID = Integer.parseInt(selectedItem[0].getText(0));
                    WizardGC2AppCond.this.selectedRule = (Rule)hashmapAllRules.get(ruleID);
                }
            }
        });
        groupButtons.setLayout((Layout)new RowLayout(256));
        Button btnIntegrate = new Button((Composite)groupButtons, 0);
        btnIntegrate.setLayoutData((Object)new RowData(-1, 35));
        btnIntegrate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardGC2AppCond.this.selectedNestedConstraint != null && WizardGC2AppCond.this.selectedRule != null) {
                    System.out.println(WizardGC2AppCond.this.selectedNestedConstraint + "  " + WizardGC2AppCond.this.selectedRule);
                    GC2AppCondCommand ial = new GC2AppCondCommand(henshinFile);
                    WizardGC2AppCond.this.setNamesToRuleNodes(WizardGC2AppCond.this.selectedRule);
                    ial.enableOptimizer = false;
                    ial.integrateAndleft(WizardGC2AppCond.this.selectedNestedConstraint, WizardGC2AppCond.this.selectedRule);
                    long translationTime = ial.translationTime;
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
                    WizardGC2AppCond.this.close();
                }
            }
        });
        btnIntegrate.setText("Integrate");
        Button btnIntegrateAllConstraints = new Button((Composite)groupButtons, 0);
        btnIntegrateAllConstraints.setLayoutData((Object)new RowData(-1, 35));
        btnIntegrateAllConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardGC2AppCond.this.selectedRule != null) {
                    long translationTime = 0L;
                    WizardGC2AppCond.this.setNamesToRuleNodes(WizardGC2AppCond.this.selectedRule);
                    if (hashmapAllNestedconstraints != null) {
                        for (Integer key : hashmapAllNestedconstraints.keySet()) {
                            NestedConstraint nestedConstraint = (NestedConstraint)hashmapAllNestedconstraints.get(key);
                            GC2AppCondCommand ial = new GC2AppCondCommand(henshinFile);
                            ial.enableOptimizer = false;
                            ial.integrateAndleftInPlace(nestedConstraint, WizardGC2AppCond.this.selectedRule);
                            translationTime += ial.translationTime;
                        }
                    }
                    try {
                        WizardGC2AppCond.this.selectedRule.getModule().eResource().save(null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        System.err.println("Error on persisting the rule");
                    }
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
                    WizardGC2AppCond.this.close();
                }
            }
        });
        btnIntegrateAllConstraints.setText("Integrate all constraints \r\ninto a rule");
        Button btnCheckforintegration = new Button((Composite)groupButtons, 0);
        btnCheckforintegration.setLayoutData((Object)new RowData(-1, 35));
        btnCheckforintegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardGC2AppCond.this.selectedNestedConstraint != null && WizardGC2AppCond.this.selectedRule != null) {
                    IntegrationChecker op = new IntegrationChecker();
                    boolean mustIntegrate = op.mustIntegrate(WizardGC2AppCond.this.selectedRule, WizardGC2AppCond.this.selectedNestedConstraint);
                    if (mustIntegrate) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Info (required)", (String)"The constraint SHOULD be integrated into the rule.");
                        boolean yes = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)"Do you want to continue integrating it?");
                        if (yes) {
                            System.out.println("The constraint " + WizardGC2AppCond.this.selectedNestedConstraint.getName() + " should be integrated into rule " + WizardGC2AppCond.this.selectedRule.getName());
                            GC2AppCondCommand ial = new GC2AppCondCommand(henshinFile);
                            WizardGC2AppCond.this.setNamesToRuleNodes(WizardGC2AppCond.this.selectedRule);
                            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " enables " + ial.getClass().getName());
                            ial.enableOptimizer = true;
                            ial.integrateAndleft(WizardGC2AppCond.this.selectedNestedConstraint, WizardGC2AppCond.this.selectedRule);
                            long translationTime = ial.translationTime;
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
                            WizardGC2AppCond.this.close();
                        }
                    } else {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Info (not required)", (String)"There is NO need to integrate the selected constraint into the selected rule.");
                        WizardGC2AppCond.this.close();
                    }
                }
            }
        });
        btnCheckforintegration.setText("Construct Optimized Validity-Preserving AC (C, R)");
        Button btnIntegrateAllRequired = new Button((Composite)groupButtons, 0);
        btnIntegrateAllRequired.setLayoutData((Object)new RowData(-1, 35));
        btnIntegrateAllRequired.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardGC2AppCond.this.selectedRule != null) {
                    String infoRequiredConstraint = "";
                    int numberOfIntegrated = 0;
                    long translationTime = 0L;
                    WizardGC2AppCond.this.setNamesToRuleNodes(WizardGC2AppCond.this.selectedRule);
                    if (hashmapAllNestedconstraints != null) {
                        Iterator keySetIterator = hashmapAllNestedconstraints.keySet().iterator();
                        while (keySetIterator.hasNext()) {
                            IntegrationChecker op = new IntegrationChecker();
                            Integer key = (Integer)keySetIterator.next();
                            NestedConstraint nestedConstraint = (NestedConstraint)hashmapAllNestedconstraints.get(key);
                            boolean mustIntegrate = op.mustIntegrate(WizardGC2AppCond.this.selectedRule, nestedConstraint);
                            if (!mustIntegrate) continue;
                            infoRequiredConstraint = String.valueOf(infoRequiredConstraint) + nestedConstraint.getName() + System.lineSeparator();
                            System.out.println("(" + nestedConstraint.getName() + ") constraint is required for the rule (" + WizardGC2AppCond.this.selectedRule.getName() + ")");
                            System.out.println("The constraint " + WizardGC2AppCond.this.selectedNestedConstraint.getName() + " should be integrated into rule " + WizardGC2AppCond.this.selectedRule.getName());
                            GC2AppCondCommand ial = new GC2AppCondCommand(henshinFile);
                            WizardGC2AppCond.this.setNamesToRuleNodes(WizardGC2AppCond.this.selectedRule);
                            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " enables " + ial.getClass().getName());
                            ial.enableOptimizer = true;
                            ial.integrateAndleftInPlace(nestedConstraint, WizardGC2AppCond.this.selectedRule);
                            translationTime += ial.translationTime;
                            ++numberOfIntegrated;
                        }
                    }
                    try {
                        WizardGC2AppCond.this.selectedRule.getModule().eResource().save(null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        System.err.println("Error on persisting the rule");
                    }
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)." + System.lineSeparator() + System.lineSeparator() + "Number of the required constraints are (" + numberOfIntegrated + "):" + System.lineSeparator() + infoRequiredConstraint));
                    WizardGC2AppCond.this.close();
                }
            }
        });
        btnIntegrateAllRequired.setText("Construct Optimized Validity-Preserving AC (All Cs, R)");
        this.createContents();
        this.tableNestedConstraints.notifyListeners(13, new Event());
        this.tableRules.notifyListeners(13, new Event());
    }

    protected void createContents() {
        this.setText("Integrator Wizard");
        this.setSize(511, 728);
    }

    private void fillTableNestedConstraints(HashMap<Integer, NestedConstraint> hashmapAllNestedconstraints) {
        if (hashmapAllNestedconstraints != null) {
            this.tableNestedConstraints.removeAll();
            for (Integer key : hashmapAllNestedconstraints.keySet()) {
                TableItem item = new TableItem(this.tableNestedConstraints, 0);
                item.setText(0, key.toString());
                item.setText(1, hashmapAllNestedconstraints.get(key).getName());
            }
            this.tableNestedConstraints.select(0);
            TableItem[] selectedItem = this.tableNestedConstraints.getSelection();
            Integer ruleID = Integer.parseInt(selectedItem[0].getText(0));
            this.selectedNestedConstraint = hashmapAllNestedconstraints.get(ruleID);
        }
    }

    private void fillTableRules(HashMap<Integer, Rule> hashmapAllRules) {
        if (hashmapAllRules != null) {
            this.tableRules.removeAll();
            for (Integer key : hashmapAllRules.keySet()) {
                TableItem item = new TableItem(this.tableRules, 0);
                item.setText(0, key.toString());
                item.setText(1, hashmapAllRules.get(key).getName());
            }
            this.tableRules.select(0);
            TableItem[] selectedItem = this.tableRules.getSelection();
            Integer ruleID = Integer.parseInt(selectedItem[0].getText(0));
            this.selectedRule = hashmapAllRules.get(ruleID);
        }
    }

    private void setNamesToRuleNodes(Rule rule) {
        for (Mapping m : rule.getMappings()) {
            if (m.getImage() == null || m.getOrigin() == null || m.getImage().getName() != null || m.getOrigin().getName() != null) continue;
            String nodeName = "rp" + this.randomAlphaNumeric(3);
            m.getOrigin().setName(nodeName);
            m.getImage().setName(nodeName);
        }
        for (NestedCondition nc : rule.getLhs().getNestedConditions()) {
            for (Mapping ncM : nc.getMappings()) {
                if (ncM.getImage() == null || ncM.getOrigin() == null || ncM.getImage().getName() != null || ncM.getOrigin().getName() != null) continue;
                String nodeName = "rf" + this.randomAlphaNumeric(3);
                ncM.getOrigin().setName(nodeName);
                ncM.getImage().setName(nodeName);
            }
        }
        for (Node node : rule.getLhs().getNodes()) {
            if (node.getName() != null) continue;
            node.setName("rd" + this.randomAlphaNumeric(3));
        }
        for (Node node : rule.getRhs().getNodes()) {
            if (node.getName() != null) continue;
            node.setName("rc" + this.randomAlphaNumeric(3));
        }
    }

    private String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)"abcdefghijklmnopqrstuvwxyz0123456789".length());
            builder.append("abcdefghijklmnopqrstuvwxyz0123456789".charAt(character));
        }
        return builder.toString();
    }

    protected void checkSubclass() {
    }
}

