/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.parts.AttributeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.ModuleEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleEditPart;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroupDetectionResult;
import org.eclipse.emf.henshin.variability.ui.MergeClusteredRulesAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.notation.impl.ConnectorImpl;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class CloneGroupView
extends ViewPart {
    public static final String ID = "org.eclipse.emf.henshin.variability.ui.views.CloneGroupView";
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action highlightClonePartAction;
    private Action mergeClusteredRulesAction;
    private Action doubleClickAction;
    private ModuleEditPart selectedModuleEditPart;
    private CloneGroupDetectionResult cloneDetectionResult;
    private List<BorderedNodeFigure> presentBorderFigures;
    public Map<EdgeEditPart, Color> edgeColorCache;
    public Map<AttributeEditPart, Color> attributeColorCache;
    private TransactionalEditingDomain editingDomain;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.emf.henshin.variability.ui.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CloneGroupView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.highlightClonePartAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.highlightClonePartAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mergeClusteredRulesAction);
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.highlightClonePartAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mergeClusteredRulesAction);
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.highlightClonePartAction = new HighlightClonePartInRuleAction();
        this.highlightClonePartAction.setText("Show in Henshin Diagram Editor");
        this.highlightClonePartAction.setToolTipText("The corresponding model elements will be highlighted.");
        this.highlightClonePartAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.createClusteredRulesAction();
        this.doubleClickAction = new HighlightClonePartInRuleAction();
    }

    private void createClusteredRulesAction() {
        this.mergeClusteredRulesAction = new MergeClusteredRulesAction(this.cloneDetectionResult, this.editingDomain);
        this.mergeClusteredRulesAction.setText("Merge clones");
        this.mergeClusteredRulesAction.setToolTipText("Performs a cluster analysis and merges the rules based on the result of that analysis.");
        this.mergeClusteredRulesAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CloneGroupView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"CloneGroupView", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setContents(CloneGroupDetectionResult result) {
        this.cloneDetectionResult = result;
        this.viewer.setInput((Object)result.getCloneGroups());
        this.createClusteredRulesAction();
    }

    public void setContextDiagram(ModuleEditPart selectedModuleEditPart) {
        this.selectedModuleEditPart = selectedModuleEditPart;
    }

    public void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    class HighlightClonePartInRuleAction
    extends Action {
        HighlightClonePartInRuleAction() {
        }

        public void run() {
            ISelection selection = CloneGroupView.this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof TreeObject && ((TreeObject)obj).getModel() instanceof Rule) {
                TreeObject treeObject = (TreeObject)obj;
                Rule rule = (Rule)treeObject.getModel();
                RuleEditPart editPart = this.findRuleEditPart(CloneGroupView.this.selectedModuleEditPart, rule);
                CloneGroupView.this.selectedModuleEditPart.getViewer().reveal((EditPart)editPart);
                this.highlightRelevantElements(editPart, rule, (CloneGroup)treeObject.getParent().getModel());
            }
        }

        private void highlightRelevantElements(RuleEditPart editPart, Rule rule, CloneGroup cloneGroup) {
            this.resetColorCoding();
            for (Edge e : cloneGroup.getEdgeMappings().keySet()) {
                NodeEditPart sourceEditPart = (NodeEditPart)editPart.findEditPart((EditPart)editPart, (EObject)e.getSource().getActionNode());
                NodeEditPart targetEditPart = (NodeEditPart)editPart.findEditPart((EditPart)editPart, (EObject)e.getTarget().getActionNode());
                if (sourceEditPart != null) {
                    this.recolorEdge(sourceEditPart, e, true);
                    this.addBorderNode((GraphicalEditPart)sourceEditPart);
                }
                if (targetEditPart == null) continue;
                this.addBorderNode((GraphicalEditPart)targetEditPart);
                this.recolorEdge(targetEditPart, e, false);
            }
            for (Attribute a : cloneGroup.getAttributeMappings().keySet()) {
                this.recolorAttribute(editPart, a);
            }
        }

        private void recolorAttribute(RuleEditPart editPart, Attribute a) {
            AttributeEditPart attributeEditPart = (AttributeEditPart)editPart.findEditPart((EditPart)editPart, (EObject)a.getActionAttribute());
            if (attributeEditPart != null && attributeEditPart.getFigure().getForegroundColor() != ColorConstants.red) {
                CloneGroupView.this.attributeColorCache.put(attributeEditPart, attributeEditPart.getFigure().getForegroundColor());
                attributeEditPart.getFigure().setForegroundColor(ColorConstants.red);
            }
        }

        private void resetColorCoding() {
            if (CloneGroupView.this.presentBorderFigures != null) {
                for (BorderedNodeFigure borderedNodeFigure : CloneGroupView.this.presentBorderFigures) {
                    borderedNodeFigure.getParent().remove((IFigure)borderedNodeFigure);
                }
                for (EdgeEditPart edgeEditPart : CloneGroupView.this.edgeColorCache.keySet()) {
                    edgeEditPart.getFigure().setForegroundColor(CloneGroupView.this.edgeColorCache.get(edgeEditPart));
                }
                for (AttributeEditPart attributeEditPart : CloneGroupView.this.attributeColorCache.keySet()) {
                    attributeEditPart.getFigure().setForegroundColor(CloneGroupView.this.attributeColorCache.get(attributeEditPart));
                }
                CloneGroupView.this.presentBorderFigures.clear();
                CloneGroupView.this.edgeColorCache.clear();
                CloneGroupView.this.attributeColorCache.clear();
            } else {
                CloneGroupView.this.presentBorderFigures = new ArrayList<BorderedNodeFigure>();
                CloneGroupView.this.edgeColorCache = new HashMap<EdgeEditPart, Color>();
                CloneGroupView.this.attributeColorCache = new HashMap<AttributeEditPart, Color>();
            }
        }

        private void recolorEdge(NodeEditPart nodeEditPart, Edge e, boolean fromOrigin) {
            Edge actionEdge = e.getActionEdge();
            List connectionSet = fromOrigin ? nodeEditPart.getSourceConnections() : nodeEditPart.getTargetConnections();
            for (Object connection : connectionSet) {
                EdgeEditPart edgePart;
                EObject el;
                if (!(connection instanceof EdgeEditPart) || (el = ((ConnectorImpl)(edgePart = (EdgeEditPart)connection).getModel()).getElement()) != actionEdge || edgePart.getFigure().getForegroundColor() == ColorConstants.red) continue;
                CloneGroupView.this.edgeColorCache.put(edgePart, edgePart.getFigure().getForegroundColor());
                edgePart.getFigure().setForegroundColor(ColorConstants.red);
            }
        }

        private void addBorderNode(GraphicalEditPart editPart) {
            BorderedNodeFigure borderNodeSource = new BorderedNodeFigure((IFigure)new Label());
            borderNodeSource.setBorder((Border)new LineBorder(ColorConstants.red, 2));
            editPart.getFigure().add((IFigure)borderNodeSource);
            CloneGroupView.this.presentBorderFigures.add(borderNodeSource);
        }

        private RuleEditPart findRuleEditPart(ModuleEditPart selectedModuleEditPart, Rule rule) {
            for (Object part : selectedModuleEditPart.getChildren()) {
                if (!(part instanceof RuleEditPart) || ((ShapeImpl)((RuleEditPart)part).getModel()).getElement() != rule) continue;
                return (RuleEditPart)part;
            }
            return null;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class TreeObject
    implements IAdaptable {
        private String name;
        private TreeParent parent;
        private Object model;

        public Object getModel() {
            return this.model;
        }

        public void setModel(Object model) {
            this.model = model;
        }

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public <T> T getAdapter(Class<T> key) {
            return null;
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList<TreeObject> children;

        public TreeParent(String name) {
            super(name);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(CloneGroupView.this.getViewSite())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof List) {
                ArrayList<TreeParent> children = new ArrayList<TreeParent>();
                int index = 0;
                for (Object o : (List)parent) {
                    CloneGroup cg = (CloneGroup)o;
                    TreeParent tp = new TreeParent("Clone group " + ++index + ": " + cg.getRules().size() + " rules, " + cg.getNumberOfCommonEdges() + " common edges");
                    tp.setModel(cg);
                    children.add(tp);
                    for (Rule r : cg.getRules()) {
                        TreeObject leaf = new TreeObject("Rule " + r.getName());
                        leaf.setModel(r);
                        tp.addChild(leaf);
                    }
                }
                return children.toArray(new Object[children.size()]);
            }
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            if (parent instanceof List) {
                return !((List)parent).isEmpty();
            }
            return false;
        }

        private void initialize() {
            TreeParent root = new TreeParent("To see something here, use the \"Start Clone Detection\" context menu entry in the Henshin diagram editor.");
            this.invisibleRoot = new TreeParent("");
            this.invisibleRoot.addChild(root);
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

