/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mergeSuggestion.MergeNAC;
import mergeSuggestion.MergePAC;
import mergeSuggestion.MergeRule;
import mergeSuggestion.MergeRuleElement;
import mergeSuggestion.MergeSuggestion;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clustering.BasicMergeSuggestionBuilder;
import org.eclipse.emf.henshin.variability.mergein.clustering.CloneHierarchy;
import org.eclipse.emf.henshin.variability.mergein.clustering.SubCloneRelation;

public class HierarchicalMergeSuggestionBuilder
extends BasicMergeSuggestionBuilder {
    MergeSuggestion createFromCloneHierarchy(CloneHierarchy cloneHierarchy) {
        Set<CloneGroup> topCloneGroups = cloneHierarchy.getTopCloneGroups();
        MergeSuggestion basisSuggestion = this.createFromBasisClones(topCloneGroups);
        for (CloneGroup topCloneGroup : topCloneGroups) {
            Rule rule = topCloneGroup.getRules().iterator().next();
            MergeRule mergeRule = basisSuggestion.findMergeRule(rule);
            this.extendMergeRule(mergeRule, topCloneGroup, cloneHierarchy);
        }
        return basisSuggestion;
    }

    private void extendMergeRule(MergeRule mergeRule, CloneGroup basisGroup, CloneHierarchy cloneHierarchy) {
        if (cloneHierarchy.getSubClones(basisGroup) != null && !cloneHierarchy.getSubClones(basisGroup).isEmpty()) {
            HashSet<CloneGroup> remaining = new HashSet<CloneGroup>();
            HashSet<CloneGroup> considered = new HashSet<CloneGroup>();
            HashSet<CloneGroup> integrated = new HashSet<CloneGroup>();
            considered.add(basisGroup);
            remaining.addAll(cloneHierarchy.getSubClones(basisGroup));
            while (!remaining.isEmpty()) {
                CloneGroup next = this.getNextSubClone(remaining, considered, cloneHierarchy);
                if (next == null) {
                    throw new RuntimeException("Error during creation of merge suggestion. Possibly the sub-clone hierarchy was created in an ill-founded way.");
                }
                boolean integrate = true;
                for (CloneGroup groups : integrated) {
                    if (SubCloneRelation.isSubClone(groups, next)) continue;
                    integrate = false;
                }
                if (integrate) {
                    this.mergeIn(mergeRule, next);
                    integrated.add(next);
                }
                remaining.remove(next);
                considered.add(next);
            }
        }
    }

    private CloneGroup getNextSubClone(Set<CloneGroup> remaining, Set<CloneGroup> considered, CloneHierarchy cloneHierarchy) {
        CloneGroup candidate = null;
        for (CloneGroup cg : remaining) {
            if (!considered.containsAll(cloneHierarchy.getSuperClones(cg)) || candidate != null && cg.getSize() <= candidate.getSize()) continue;
            candidate = cg;
        }
        return candidate;
    }

    private void mergeIn(MergeRule mergeRule, CloneGroup subGroup) {
        MergeRule subGroupMergeRule = this.createFromBasisCloneGroup(subGroup);
        this.combineMergeRules(mergeRule, subGroupMergeRule, subGroup);
        for (Rule rule : subGroup.getRules()) {
            if (mergeRule.getRules().contains((Object)rule)) continue;
            mergeRule.getRules().add((Object)rule);
        }
    }

    private void combineMergeRules(MergeRule mergeRule, MergeRule subGroupMergeRule, CloneGroup subGroup) {
        mergeRule.getElements().addAll(subGroupMergeRule.getElements());
        HashMap<GraphElement, HashSet<GraphElement>> graph2set = new HashMap<GraphElement, HashSet<GraphElement>>();
        for (MergeRuleElement el : mergeRule.getElements()) {
            for (GraphElement ge : el.getReferenceElements()) {
                Set<Object> graphelems = (Set)graph2set.get(ge);
                if (graphelems == null) {
                    graphelems = new HashSet<GraphElement>();
                }
                graphelems.addAll((Collection<GraphElement>)el.getReferenceElements());
                for (GraphElement ge2 : el.getReferenceElements()) {
                    graph2set.put(ge2, (HashSet<GraphElement>)graphelems);
                }
            }
        }
        HashMap<GraphElement, HashSet<MergeRuleElement>> graph2ruleElem = new HashMap<GraphElement, HashSet<MergeRuleElement>>();
        for (MergeRuleElement el : mergeRule.getElements()) {
            for (GraphElement ge : el.getReferenceElements()) {
                HashSet<MergeRuleElement> ruleElems = (HashSet<MergeRuleElement>)graph2ruleElem.get(ge);
                if (ruleElems == null) {
                    ruleElems = new HashSet<MergeRuleElement>();
                    graph2ruleElem.put(ge, ruleElems);
                }
                ruleElems.add(el);
            }
        }
        for (Set graphElems : graph2set.values()) {
            MergeRuleElement master = (MergeRuleElement)((Set)graph2ruleElem.get(graphElems.iterator().next())).iterator().next();
            EList<GraphElement> masterRefElems = master.getReferenceElements();
            for (GraphElement ge : graphElems) {
                if (!masterRefElems.contains((Object)ge)) {
                    masterRefElems.add((Object)ge);
                }
                for (MergeRuleElement re : (Set)graph2ruleElem.get(ge)) {
                    if (re == master) continue;
                    mergeRule.getElements().remove((Object)re);
                }
            }
        }
        this.handleNACs(mergeRule, subGroupMergeRule);
    }

    private void handleNACs(MergeRule mergeRule, MergeRule subGroupMergeRule) {
        mergeRule.getMergeNacs().addAll(subGroupMergeRule.getMergeNacs());
        HashMap<Graph, HashSet<Graph>> nac2nacs = new HashMap<Graph, HashSet<Graph>>();
        for (MergeNAC mergeNac : mergeRule.getMergeNacs()) {
            for (Graph nac1 : mergeNac.getReferenceNACs()) {
                Set<Object> nacs = (Set)nac2nacs.get(nac1);
                if (nacs == null) {
                    nacs = new HashSet<Graph>();
                }
                nacs.addAll((Collection<Graph>)mergeNac.getReferenceNACs());
                for (Graph nac2 : mergeNac.getReferenceNACs()) {
                    nac2nacs.put(nac2, (HashSet<Graph>)nacs);
                }
            }
        }
        HashMap<Graph, HashSet<MergeNAC>> nac2mergeNacs = new HashMap<Graph, HashSet<MergeNAC>>();
        for (MergeNAC mergeNac : mergeRule.getMergeNacs()) {
            for (Graph nac : mergeNac.getReferenceNACs()) {
                HashSet<MergeNAC> mergeNacs = (HashSet<MergeNAC>)nac2mergeNacs.get(nac);
                if (mergeNacs == null) {
                    mergeNacs = new HashSet<MergeNAC>();
                    nac2mergeNacs.put(nac, mergeNacs);
                }
                mergeNacs.add(mergeNac);
            }
        }
        for (Set nacs : nac2nacs.values()) {
            MergeNAC master = (MergeNAC)((Set)nac2mergeNacs.get(nacs.iterator().next())).iterator().next();
            EList<Graph> masterNACs = master.getReferenceNACs();
            for (Iterator nac : masterNACs) {
                if (!masterNACs.contains((Object)nac)) {
                    masterNACs.add((Object)nac);
                }
                for (MergeNAC mergeNAC : (Set)nac2mergeNacs.get(nac)) {
                    if (mergeNAC == master) continue;
                    mergeRule.getMergeNacs().remove((Object)mergeNAC);
                }
            }
        }
        mergeRule.getMergePacs().addAll(subGroupMergeRule.getMergePacs());
        HashMap<Graph, HashSet<Graph>> pac2pacs = new HashMap<Graph, HashSet<Graph>>();
        for (MergePAC mergePac : mergeRule.getMergePacs()) {
            for (Graph pac1 : mergePac.getReferencePACs()) {
                Set<Object> pacs = (Set)pac2pacs.get(pac1);
                if (pacs == null) {
                    pacs = new HashSet<Graph>();
                }
                pacs.addAll((Collection<Graph>)mergePac.getReferencePACs());
                for (Graph pac2 : mergePac.getReferencePACs()) {
                    pac2pacs.put(pac2, (HashSet<Graph>)pacs);
                }
            }
        }
        HashMap<Graph, HashSet<MergePAC>> pac2mergePacs = new HashMap<Graph, HashSet<MergePAC>>();
        for (MergePAC mergePac : mergeRule.getMergePacs()) {
            for (Graph pac : mergePac.getReferencePACs()) {
                HashSet<MergePAC> mergePacs = (HashSet<MergePAC>)pac2mergePacs.get(pac);
                if (mergePacs == null) {
                    mergePacs = new HashSet<MergePAC>();
                    pac2mergePacs.put(pac, mergePacs);
                }
                mergePacs.add(mergePac);
            }
        }
        for (Set pacs : pac2pacs.values()) {
            MergePAC master = (MergePAC)((Set)pac2mergePacs.get(pacs.iterator().next())).iterator().next();
            EList<Graph> masterPACs = master.getReferencePACs();
            for (Graph pac : masterPACs) {
                if (!masterPACs.contains((Object)pac)) {
                    masterPACs.add((Object)pac);
                }
                for (MergePAC mergePAC : (Set)pac2mergePacs.get(pac)) {
                    if (mergePAC == master) continue;
                    mergeRule.getMergePacs().remove((Object)mergePAC);
                }
            }
        }
    }
}

