/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.server.AttributeInfo;
import org.eclipse.emf.cdo.server.ClassInfo;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.PackageInfo;
import org.eclipse.emf.cdo.server.ServerCDOProtocol;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribePackageIndication
extends AbstractIndicationWithResponse {
    private List<ClassInfo> infos;

    public short getSignalId() {
        return 2;
    }

    public void indicate() {
        int pid = this.getMapper().getNextPid();
        String packageName = this.receiveString();
        if (this.isDebugEnabled()) {
            this.debug("Described package " + packageName);
        }
        PackageInfo packageInfo = this.getMapper().getPackageManager().addPackage(pid, packageName);
        this.getMapper().insertPackage(packageInfo);
        this.infos = this.receiveClasses(packageInfo);
        this.getMapper().createAttributeTables(packageInfo);
    }

    public void respond() {
        this.transmitInt(this.infos.size());
        for (ClassInfo classInfo : this.infos) {
            if (this.isDebugEnabled()) {
                this.debug("Responding class " + classInfo.getName() + " = " + classInfo.getCID());
            }
            this.transmitInt(classInfo.getCID());
            this.transmitString(classInfo.getName());
        }
    }

    private List<ClassInfo> receiveClasses(PackageInfo packageInfo) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        int count = this.receiveInt();
        int i = 0;
        while (i < count) {
            int cid = this.getMapper().getNextCID();
            String name = this.receiveString();
            String parentName = this.receiveString();
            String tableName = this.receiveString();
            if (this.isDebugEnabled()) {
                this.debug("Described class " + name);
            }
            ClassInfo classInfo = packageInfo.addClass(cid, name, parentName, tableName);
            this.getMapper().insertClass(classInfo);
            this.receiveAttributes(classInfo);
            result.add(classInfo);
            ++i;
        }
        return result;
    }

    private void receiveAttributes(ClassInfo classInfo) {
        int count = this.receiveInt();
        int i = 0;
        while (i < count) {
            String name = this.receiveString();
            int featureId = this.receiveInt();
            int dataType = this.receiveInt();
            String columnName = this.receiveString();
            int columnType = this.receiveInt();
            if (this.isDebugEnabled()) {
                this.debug("Described attribute " + name);
            }
            AttributeInfo attributeInfo = classInfo.addAttribute(name, featureId, dataType, columnName, columnType);
            this.getMapper().insertAttribute(attributeInfo, classInfo.getCID());
            ++i;
        }
    }

    private Mapper getMapper() {
        return ((ServerCDOProtocol)this.getProtocol()).getMapper();
    }
}

