/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.dialogs.ExpansionType;
import org.eclipse.gmf.runtime.common.ui.dialogs.IShowRelatedElementsWithDetails;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectedType;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsPreset;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementTreeSelectionChangedAndMouseAndKeyListener;
import org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementsContentProvider;
import org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementsTriStateLabelProvider;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ShowRelatedElementsComposite
extends Composite {
    private TreeViewer viewer;
    private Composite expansionComposite;
    private Button consumerToSelection;
    private Button selectionToSupplier;
    private Button both;
    private Button allConnected;
    protected boolean showAllConnected = false;
    private Text levels;
    private Button expandIndefinitely;
    private SelectableElement rootElement;
    private boolean cachedExpandIndefinitely;
    private int cachedExpandLevels;
    private ExpansionType cachedExpansionType = ExpansionType.INCOMING;
    private Image showRelatedElementsImage1;
    private Image showRelatedElementsImage2;
    private Image showRelatedElementsImage3;
    private boolean needsExpansionControls;
    protected IShowRelatedElementsWithDetails detailsChangedListener;
    protected Composite contributedExpansionGroupComposite = null;
    private static final int DEFAULT_LEVELS = 1;
    protected int viewerWidth = -1;
    private List selectedSelectableElements;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsComposite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ShowRelatedElementsComposite(Composite parent, SelectableElement aRootElement, int preferredViewerWidth) {
        this(parent, aRootElement, true, preferredViewerWidth);
    }

    public ShowRelatedElementsComposite(Composite parent, SelectableElement aRootElement, boolean createExpansion, int preferredViewerWidth) {
        super(parent, 0);
        this.needsExpansionControls = createExpansion;
        this.rootElement = aRootElement.makeCopy();
        this.selectedSelectableElements = new ArrayList();
        SelectableElement.getAllChildrenOfType(this.rootElement, SelectedType.LEAVE, this.selectedSelectableElements);
        this.viewerWidth = preferredViewerWidth;
        this.createContents();
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                ShowRelatedElementsComposite.this.onDispose();
            }
        });
    }

    protected void createContents() {
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(2, false));
        this.createViewer();
        if (this.needsExpansionControls) {
            this.createExpansionControls();
        }
        this.reset();
        this.viewer.refresh();
    }

    public int getViewerWidth() {
        return this.viewerWidth;
    }

    protected void reset() {
        if (this.needsExpansionControls) {
            this.setBoth();
            this.setExpand(1);
        }
        SelectableElement.setSelectedTypeForSelecteableElementAndChildren(this.rootElement, SelectedType.SELECTED);
        if (!$assertionsDisabled && this.selectedSelectableElements == null) {
            throw new AssertionError();
        }
        Iterator it = this.selectedSelectableElements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!$assertionsDisabled && !(obj instanceof SelectableElement)) {
                throw new AssertionError();
            }
            SelectableElement.setSelectedTypeForSelecteableElementAndChildren((SelectableElement)obj, SelectedType.LEAVE);
        }
        this.viewer.expandToLevel(2);
        this.viewer.refresh();
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public Text getLevels() {
        return this.levels;
    }

    public boolean getExpandIndefinitely() {
        return this.cachedExpandIndefinitely;
    }

    public int getExpandLevel() {
        return this.cachedExpandLevels;
    }

    public ExpansionType getExpansionType() {
        return this.cachedExpansionType;
    }

    public boolean getConsumerToSelection() {
        return this.cachedExpansionType.equals((Object)ExpansionType.INCOMING) || this.cachedExpansionType.equals((Object)ExpansionType.BOTH);
    }

    public boolean getSelectionToSupplier() {
        return this.cachedExpansionType.equals((Object)ExpansionType.OUTGOING) || this.cachedExpansionType.equals((Object)ExpansionType.BOTH);
    }

    public boolean getAllConnected() {
        return this.cachedExpansionType.equals((Object)ExpansionType.ALL);
    }

    public List getSelectedRelationshipTypes() {
        if (this.rootElement == null) {
            return null;
        }
        return this.rootElement.getSelectedElementTypes();
    }

    protected void setTreeViewer(TreeViewer aViewer) {
        this.viewer = aViewer;
    }

    protected void createViewer() {
        Label label = new Label((Composite)this, 0);
        label.setText(CommonUIMessages.ShowRelatedElementsDialog_RelationshipTypes);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.setTreeViewer(new TreeViewer((Composite)this, 2564));
        gridData = new GridData(1808);
        gridData.widthHint = this.viewerWidth;
        gridData.horizontalSpan = 2;
        Tree tree = this.getTreeViewer().getTree();
        tree.setLayoutData((Object)gridData);
        this.getTreeViewer().setUseHashlookup(true);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new SelectableElementsTriStateLabelProvider());
        this.getTreeViewer().setContentProvider((IContentProvider)new SelectableElementsContentProvider());
        this.getTreeViewer().setInput((Object)this.rootElement);
        TreeItem[] treeItems = tree.getItems();
        if (!$assertionsDisabled && treeItems == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && treeItems.length != 1) {
            throw new AssertionError();
        }
        tree.setSelection(treeItems);
        SelectableElementTreeSelectionChangedAndMouseAndKeyListener listener = new SelectableElementTreeSelectionChangedAndMouseAndKeyListener(this.getTreeViewer()){

            protected void switchCheckType(SelectableElement element) {
                ShowRelatedElementsComposite.this.detailsChanged();
                if (element.getSelectedType() == SelectedType.LEAVE) {
                    element.setSelectedType(SelectedType.SELECTED);
                } else if (element.getSelectedType() == SelectedType.SELECTED) {
                    element.setSelectedType(SelectedType.LEAVE);
                }
            }
        };
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)listener);
        tree.addMouseListener((MouseListener)listener);
        tree.addKeyListener((KeyListener)listener);
    }

    protected void contributeToExpansionGroupComposite(Composite parent) {
    }

    protected void createExpansionControls() {
        this.expansionComposite = new Composite((Composite)this, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.expansionComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.expansionComposite.setLayout((Layout)gridLayout);
        new Label(this.expansionComposite, 0).setText(CommonUIMessages.ShowRelatedElementsDialog_ExpansionGroup_Text);
        this.consumerToSelection = new Button(this.expansionComposite, 16);
        this.consumerToSelection.setText(CommonUIMessages.ShowRelatedElementsDialog_Incoming);
        this.consumerToSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsComposite.this.detailsChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new Label(this.expansionComposite, 0);
        this.selectionToSupplier = new Button(this.expansionComposite, 16);
        this.selectionToSupplier.setText(CommonUIMessages.ShowRelatedElementsDialog_Outgoing);
        this.selectionToSupplier.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsComposite.this.detailsChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.showAllConnected) {
            new Label(this.expansionComposite, 0);
        }
        this.allConnected = new Button(this.expansionComposite, 16);
        this.allConnected.setText(CommonUIMessages.ShowRelatedElementsDialog_AllConnected);
        this.allConnected.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsComposite.this.detailsChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (!this.showAllConnected) {
            this.allConnected.setVisible(false);
        } else {
            new Label(this.expansionComposite, 0);
        }
        this.both = new Button(this.expansionComposite, 16);
        this.both.setText(CommonUIMessages.ShowRelatedElementsDialog_ExpansionGroup_RadioButton_Both);
        this.both.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsComposite.this.detailsChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.contributeToExpansionGroupComposite(this.expansionComposite);
        new Label(this.expansionComposite, 0).setText(CommonUIMessages.ShowRelatedElementsDialog_ExpansionGroup_Label_Levels);
        this.levels = new Text(this.expansionComposite, 2048);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.levels.setLayoutData((Object)gridData);
        this.levels.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ShowRelatedElementsComposite.this.detailsChanged();
            }
        });
        new Label(this.expansionComposite, 0);
        this.expandIndefinitely = new Button(this.expansionComposite, 32);
        this.expandIndefinitely.setText(CommonUIMessages.ShowRelatedElementsDialog_ExpansionGroup_CheckBox_Expand_Indefinitely);
        this.expandIndefinitely.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ShowRelatedElementsComposite.this.checkAndAskExpandIndefinitely();
                ShowRelatedElementsComposite.this.detailsChanged();
            }
        });
    }

    public String validate(boolean alert) {
        if (!this.validateLevels()) {
            if (alert) {
                this.performValidateFailed();
            }
            return CommonUIMessages.ShowRelatedElementsDialog_LevelsValidation_Message;
        }
        return null;
    }

    private boolean validateLevels() {
        if (this.levels.getText() == "") {
            return false;
        }
        try {
            int result = Integer.parseInt(this.levels.getText());
            return result >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void performValidateFailed() {
        MessageBox validate = new MessageBox(this.getShell(), 1);
        validate.setText(CommonUIMessages.ShowRelatedElementsDialog_LevelsValidation_Title);
        validate.setMessage(CommonUIMessages.ShowRelatedElementsDialog_LevelsValidation_Message);
        validate.open();
        this.levels.setFocus();
    }

    public void saveCachedValues() {
        if (!this.needsExpansionControls) {
            return;
        }
        this.cachedExpandIndefinitely = this.expandIndefinitely.getSelection();
        try {
            this.cachedExpandLevels = Integer.parseInt(this.levels.getText());
        }
        catch (NumberFormatException e) {
            CommonUIPlugin commonUIPlugin = CommonUIPlugin.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsComposite");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)commonUIPlugin, (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"saveCachedValues", (Throwable)e);
            this.cachedExpandLevels = 1;
        }
        if (this.consumerToSelection.getSelection()) {
            this.cachedExpansionType = ExpansionType.INCOMING;
        } else if (this.selectionToSupplier.getSelection()) {
            this.cachedExpansionType = ExpansionType.OUTGOING;
        } else if (this.both.getSelection()) {
            this.cachedExpansionType = ExpansionType.BOTH;
        } else if (this.allConnected.getSelection()) {
            this.cachedExpansionType = ExpansionType.ALL;
        }
    }

    public void checkAndAskExpandIndefinitely() {
        if (this.expandIndefinitely.getSelection()) {
            MessageBox messageBox = new MessageBox(this.getShell(), 196);
            messageBox.setText(CommonUIMessages.ShowRelatedElementsDialog_ExpandIndefinitelyMessageBox_Title);
            messageBox.setMessage(String.valueOf(CommonUIMessages.ShowRelatedElementsDialog_ExpandIndefinitelyMessageBox_Message_Sentence1) + "\n" + CommonUIMessages.ShowRelatedElementsDialog_ExpandIndefinitelyMessageBox_Message_Sentence2);
            if (messageBox.open() == 128) {
                this.expandIndefinitely.setSelection(false);
            }
        }
        this.levels.setEnabled(!this.expandIndefinitely.getSelection());
    }

    private void onDispose() {
        this.disposeImages();
    }

    private void disposeImages() {
        if (this.showRelatedElementsImage1 != null && !this.showRelatedElementsImage1.isDisposed()) {
            this.showRelatedElementsImage1.dispose();
        }
        if (this.showRelatedElementsImage2 != null && !this.showRelatedElementsImage2.isDisposed()) {
            this.showRelatedElementsImage2.dispose();
        }
        if (this.showRelatedElementsImage3 != null && !this.showRelatedElementsImage3.isDisposed()) {
            this.showRelatedElementsImage3.dispose();
        }
    }

    public void resetRootElement(SelectableElement newRootElement) {
        this.rootElement = newRootElement;
        this.viewer.setInput((Object)newRootElement);
        this.reset();
    }

    public void setBoth() {
        this.both.setSelection(true);
        this.consumerToSelection.setSelection(false);
        this.selectionToSupplier.setSelection(false);
        this.allConnected.setSelection(false);
    }

    public void setConsumerToSelection() {
        this.consumerToSelection.setSelection(true);
        this.both.setSelection(false);
        this.selectionToSupplier.setSelection(false);
        this.allConnected.setSelection(false);
    }

    public void setSelectionToSupplier() {
        this.selectionToSupplier.setSelection(true);
        this.both.setSelection(false);
        this.consumerToSelection.setSelection(false);
        this.allConnected.setSelection(false);
    }

    public void setAllConnected() {
        this.allConnected.setSelection(true);
        this.selectionToSupplier.setSelection(false);
        this.both.setSelection(false);
        this.consumerToSelection.setSelection(false);
    }

    public void setExpand(int expandLevels) {
        if (expandLevels >= 0) {
            if (!$assertionsDisabled && expandLevels > 99) {
                throw new AssertionError();
            }
            this.expandIndefinitely.setSelection(false);
            this.levels.setEnabled(true);
            this.levels.setText(Integer.toString(expandLevels));
        } else {
            this.expandIndefinitely.setSelection(true);
            this.levels.setEnabled(false);
        }
    }

    public void ExpandIndefinitely(boolean enable) {
        this.expandIndefinitely.setSelection(enable);
        this.levels.setEnabled(!enable);
    }

    public SelectableElement getRootElement() {
        return this.rootElement;
    }

    public void enableDirectionControls(boolean enable) {
        this.consumerToSelection.setEnabled(enable);
        this.both.setEnabled(enable);
        this.selectionToSupplier.setEnabled(enable);
    }

    public void enableExpandLevels(boolean enable) {
        this.expandIndefinitely.setEnabled(enable);
        this.levels.setEnabled(enable);
    }

    private boolean select(List list, SelectableElement selectableElement) {
        if (selectableElement.getNumberOfChildren() == 0) {
            if (list.contains(selectableElement.getHint())) {
                selectableElement.setSelectedType(SelectedType.SELECTED);
                return true;
            }
            selectableElement.setSelectedType(SelectedType.LEAVE);
            return false;
        }
        boolean childrenSelected = true;
        int i = 0;
        while (i < selectableElement.getNumberOfChildren()) {
            if (!this.select(list, selectableElement.getChild(i))) {
                childrenSelected = false;
            }
            ++i;
        }
        if (childrenSelected) {
            selectableElement.setSelectedType(SelectedType.SELECTED);
            return true;
        }
        selectableElement.setSelectedType(SelectedType.LEAVE);
        return false;
    }

    public void initializeSettings(boolean cts, boolean sts, int expandLevel, List selectedHints) {
        if (cts && sts) {
            this.setBoth();
        } else if (cts) {
            this.setConsumerToSelection();
        } else if (sts) {
            this.setSelectionToSupplier();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        this.setExpand(expandLevel);
        this.select(selectedHints, this.rootElement);
        this.viewer.refresh();
        this.expandIndefinitely.setFocus();
    }

    public void updateRelationships(ShowRelatedElementsPreset preset) {
        if (!$assertionsDisabled && this.rootElement == null) {
            throw new AssertionError();
        }
        if (preset == null) {
            this.reset();
            return;
        }
        SelectableElement.setSelectedTypeForSelecteableElementAndChildren(this.rootElement, SelectedType.LEAVE);
        SelectableElement.setSelectedTypeForMatchingSelecteableElementAndChildren(this.rootElement, SelectedType.SELECTED, preset.getIds());
        if (preset.getExpansionType() == ExpansionType.INCOMING.getOrdinal()) {
            this.setConsumerToSelection();
        } else if (preset.getExpansionType() == ExpansionType.OUTGOING.getOrdinal()) {
            this.setSelectionToSupplier();
        } else if (preset.getExpansionType() == ExpansionType.BOTH.getOrdinal()) {
            this.setBoth();
        } else if (preset.getExpansionType() == ExpansionType.ALL.getOrdinal()) {
            this.setAllConnected();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (preset.getLevels() == -1) {
            this.levels.setText("1");
            this.expandIndefinitely.setSelection(true);
            this.levels.setEnabled(false);
        } else {
            this.expandIndefinitely.setSelection(false);
            this.levels.setText(Integer.toString(preset.getLevels()));
            this.levels.setEnabled(true);
        }
        this.getTreeViewer().refresh();
    }

    public List getImmediateIds() {
        return this.getRootElement().getSelectedElementIds();
    }

    protected Object getImmediateCustomData() {
        return null;
    }

    protected int getImmediateExpansionLevels() {
        int numLevels = 0;
        if (this.expandIndefinitely.getSelection()) {
            numLevels = -1;
        } else {
            try {
                numLevels = Integer.parseInt(this.levels.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return numLevels;
    }

    protected int getImmediateExpansionType() {
        if (this.consumerToSelection.getSelection()) {
            return ExpansionType.INCOMING.getOrdinal();
        }
        if (this.selectionToSupplier.getSelection()) {
            return ExpansionType.OUTGOING.getOrdinal();
        }
        if (this.both.getSelection()) {
            return ExpansionType.BOTH.getOrdinal();
        }
        if (this.allConnected.getSelection()) {
            return ExpansionType.ALL.getOrdinal();
        }
        return -1;
    }

    public ShowRelatedElementsPreset getCurrentSettings() {
        return new ShowRelatedElementsPreset(null, false, this.getImmediateExpansionType(), this.getImmediateExpansionLevels(), this.getImmediateIds(), this.getImmediateCustomData());
    }

    public void detailsChanged() {
        if (this.detailsChangedListener != null) {
            this.detailsChangedListener.detailsChanged();
        }
    }

    public void setDetailsChangedListener(IShowRelatedElementsWithDetails newDetailsChangedListener) {
        this.detailsChangedListener = newDetailsChangedListener;
    }
}

