/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DefaultProvider;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstantSizeNode;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.AdvancedSubGraph;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.CompositeDirectedGraphLayout;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.VirtualNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;

public abstract class CompositeLayoutProvider
extends DefaultProvider {
    protected NodeList build_nodes(List selectedObjects, Map editPartToNodeDict, Subgraph rootGraph) {
        ListIterator li = selectedObjects.listIterator();
        NodeList nodes = new NodeList();
        while (li.hasNext()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
            boolean hasChildren = this.hasChildren(gep);
            if (gep instanceof IBorderItemEditPart || !(gep instanceof ShapeEditPart) && !(gep instanceof ShapeCompartmentEditPart)) continue;
            GraphicalEditPart ep = (GraphicalEditPart)gep;
            Point position = ep.getFigure().getBounds().getLocation();
            if (this.minX == -1) {
                this.minX = position.x;
                this.minY = position.y;
            } else {
                this.minX = Math.min(this.minX, position.x);
                this.minY = Math.min(this.minY, position.y);
            }
            ConstantSizeNode n = null;
            if (hasChildren && !(gep instanceof GroupEditPart)) {
                AdvancedSubGraph subGraph = null;
                subGraph = rootGraph != null ? new AdvancedSubGraph((Object)ep, rootGraph) : new AdvancedSubGraph((Object)ep);
                subGraph.setAutoSize(this.isAutoSizeOn(subGraph, (IGraphicalEditPart)ep));
                if (gep instanceof CompartmentEditPart) {
                    subGraph.setHasBufferedZone(true);
                }
                subGraph.setDirection(this.getLayoutDirection(ep));
                n = subGraph;
            } else {
                n = rootGraph != null ? new ConstantSizeNode((Object)ep, rootGraph) : new ConstantSizeNode((Object)ep);
            }
            this.adjustNodePadding((Node)n, editPartToNodeDict);
            Dimension size = ep.getFigure().getBounds().getSize();
            this.setNodeMetrics((Node)n, new Rectangle(position.x, position.y, size.width, size.height));
            editPartToNodeDict.put(ep, n);
            nodes.add((Object)n);
            if (hasChildren && !(gep instanceof GroupEditPart)) {
                this.build_nodes(gep.getChildren(), editPartToNodeDict, (Subgraph)n);
            }
            if (!(n instanceof ConstantSizeNode)) continue;
            this.build_borderNodes((org.eclipse.gef.GraphicalEditPart)gep, n, editPartToNodeDict);
        }
        return nodes;
    }

    protected int getLayoutDirection(GraphicalEditPart ep) {
        return 4;
    }

    private boolean isAutoSizeOn(AdvancedSubGraph subGraph, IGraphicalEditPart gEP) {
        if (gEP instanceof CompartmentEditPart && subGraph.getParent() instanceof AdvancedSubGraph) {
            if (((AdvancedSubGraph)subGraph.getParent()).isAutoSize()) {
                return true;
            }
        } else {
            org.eclipse.gmf.runtime.notation.Node node;
            LayoutConstraint contraint;
            View notationView = gEP.getNotationView();
            if (notationView != null && notationView instanceof org.eclipse.gmf.runtime.notation.Node && (contraint = (node = (org.eclipse.gmf.runtime.notation.Node)notationView).getLayoutConstraint()) instanceof Size) {
                Size size = (Size)contraint;
                return size.getHeight() == -1 && size.getWidth() == -1;
            }
        }
        return false;
    }

    protected DirectedGraphLayout createGraphLayout() {
        return new CompositeDirectedGraphLayout();
    }

    protected Command createNodeChangeBoundCommands(DirectedGraph g, Point diff) {
        CompoundCommand cc = new CompoundCommand("");
        NodeList list = new NodeList();
        NodeList subGraphs = ((CompoundDirectedGraph)g).nodes;
        list.addAll((Collection)subGraphs);
        for (Node element : subGraphs) {
            if (!(element instanceof Subgraph)) continue;
            list.addAll(this.getAllMembers((Subgraph)element));
        }
        this.createSubCommands(diff, list.listIterator(), cc);
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private Collection getAllMembers(Subgraph element) {
        NodeList list = new NodeList();
        list.addAll((Collection)element.members);
        for (Node node : element.members) {
            if (!(node instanceof Subgraph)) continue;
            list.addAll(this.getAllMembers((Subgraph)node));
        }
        return list;
    }

    protected Rectangle getNodeMetrics(Node n) {
        Rectangle rect = null;
        if (n.getParent() instanceof VirtualNode) {
            Subgraph parent = n.getParent();
            rect = new Rectangle(n.x + parent.x, n.y + parent.y, n.width, n.height);
        } else {
            rect = new Rectangle(n.x, n.y, n.width, n.height);
        }
        return this.translateFromGraph(rect);
    }

    protected void postProcessGraph(DirectedGraph g, Hashtable editPartToNodeDict) {
    }

    protected boolean hasChildren(IGraphicalEditPart gep) {
        List children = gep.getChildren();
        boolean hasChildren = false;
        if (!children.isEmpty()) {
            Iterator iter = children.iterator();
            while (iter.hasNext() && !hasChildren) {
                Object element = iter.next();
                hasChildren = !(element instanceof IBorderItemEditPart) && (element instanceof ShapeEditPart || element instanceof ShapeCompartmentEditPart) ? true : this.hasChildren((IGraphicalEditPart)element);
            }
        }
        return hasChildren;
    }

    protected void adjustNodePadding(Node node, Map editPartToNodeDict) {
        Insets padding = new Insets(this.getMapMode().DPtoLP(30));
        GraphicalEditPart ep = (GraphicalEditPart)node.data;
        GraphicalEditPart parent = (GraphicalEditPart)ep.getParent();
        if (parent != null && node.getParent() != null && editPartToNodeDict.get(parent) != node.getParent()) {
            IFigure thisFigure = parent.getFigure();
            IFigure parentFigure = ((GraphicalEditPart)node.getParent().data).getFigure();
            Point parentLocation = parentFigure.getBounds().getLocation();
            Point nodeLocation = thisFigure.getBounds().getLocation();
            thisFigure.translateToAbsolute((Translatable)nodeLocation);
            parentFigure.translateToAbsolute((Translatable)parentLocation);
            Dimension delta = nodeLocation.getDifference(parentLocation);
            Rectangle rect = this.translateToGraph(new Rectangle(delta.width, delta.height, 0, 0));
            padding.top += rect.y;
            padding.left += rect.x;
        }
        node.setPadding(padding);
        if (node instanceof ConstantSizeNode) {
            ConstantSizeNode cn = (ConstantSizeNode)node;
            cn.setMinIncomingPadding(this.getMapMode().DPtoLP(5));
            cn.setMinOutgoingPadding(this.getMapMode().DPtoLP(5));
        }
    }

    protected DirectedGraph createGraph() {
        return new CompoundDirectedGraph();
    }

    protected boolean shouldHandleConnectableListItems() {
        return true;
    }

    protected Command routeThrough(Edge edge, ConnectionEditPart connectEP, Node source, Node target, PointList points, Point diff) {
        Subgraph parent = source.getParent();
        if (parent == null) {
            parent = target.getParent();
        }
        if (parent != null) {
            Point parentLocation = this.getNodeMetrics((Node)parent).getLocation();
            points.translate(parentLocation.x, parentLocation.y);
        }
        return super.routeThrough(edge, connectEP, source, target, points, diff);
    }
}

