/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.m2m.atl.adt.ui.common.WorkspaceFileDialog;
import org.eclipse.m2m.atl.common.ATLLaunchConstants;
import org.eclipse.m2m.atl.core.ui.ATLCoreUIPlugin;
import org.eclipse.m2m.atl.core.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteAtlTab
extends AbstractLaunchConfigurationTab
implements ModifyListener {
    private Text textAtlFile;
    private Text textHost;
    private Text textPort;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Group moduleGroup = new Group(container, 0);
        moduleGroup.setLayout((Layout)new GridLayout(2, false));
        moduleGroup.setLayoutData((Object)new GridData(768));
        moduleGroup.setText(Messages.getString("MainAtlTab.ATL_MODULE"));
        this.textAtlFile = new Text((Composite)moduleGroup, 2052);
        this.textAtlFile.setLayoutData((Object)new GridData(768));
        Button browseWorkspace = new Button((Composite)moduleGroup, 131072);
        browseWorkspace.setText(Messages.getString("MainAtlTab.WORKSPACE"));
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(RemoteAtlTab.this.getShell(), ATLLaunchConstants.ATL_EXTENSIONS);
                dialog.open();
                Object result = dialog.getFirstResult();
                String ret = "";
                if (result != null && result instanceof IFile) {
                    IFile currentFile = (IFile)result;
                    ret = currentFile.getFullPath().toString();
                }
                RemoteAtlTab.this.textAtlFile.setText(ret);
            }
        });
        this.textAtlFile.addModifyListener((ModifyListener)this);
        Group connectionGroup = new Group(container, 0);
        connectionGroup.setLayout((Layout)new GridLayout(2, false));
        connectionGroup.setLayoutData((Object)new GridData(768));
        connectionGroup.setText(Messages.getString("RemoteAtlTab.CONNECTION_PROPERTIES"));
        Label labelHost = new Label((Composite)connectionGroup, 0);
        labelHost.setText(Messages.getString("RemoteAtlTab.HOST"));
        this.textHost = new Text((Composite)connectionGroup, 2052);
        this.textHost.addModifyListener((ModifyListener)this);
        this.textHost.setLayoutData((Object)new GridData(768));
        Label labelPort = new Label((Composite)connectionGroup, 0);
        labelPort.setText(Messages.getString("RemoteAtlTab.PORT"));
        this.textPort = new Text((Composite)connectionGroup, 2052);
        this.textPort.addModifyListener((ModifyListener)this);
        this.textPort.setLayoutData((Object)new GridData(768));
        this.canSave();
        this.setControl((Control)container);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.textAtlFile.setText(configuration.getAttribute("ATL File Name", ""));
            this.textPort.setText(configuration.getAttribute("Port", ""));
            this.textHost.setText(configuration.getAttribute("Host", ""));
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException coreException) {
            this.textAtlFile.setText("");
            this.textPort.setText("");
            this.textHost.setText("");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("ATL File Name", this.textAtlFile.getText());
        configuration.setAttribute("Port", this.textPort.getText());
        configuration.setAttribute("Host", this.textHost.getText());
    }

    public String getName() {
        return Messages.getString("RemoteAtlTab.ATL_REMOTE_CONFIGURATION");
    }

    public Image getImage() {
        return ATLCoreUIPlugin.getImage("atl_remote.gif");
    }

    public boolean canSave() {
        if (this.textAtlFile.getText().equals("")) {
            this.setErrorMessage(Messages.getString("RemoteAtlTab.SET_TRANSFORMATION"));
            return false;
        }
        try {
            if (!this.textPort.getText().equals("")) {
                Integer.parseInt(this.textPort.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString("RemoteAtlTab.PORT_NOT_INTEGER"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }
}

