/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.asm.lib;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.asm.lib.SOTSExpression2;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.LibExtension;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

public class ASMString
implements LibExtension {
    public void apply(ExecEnv execEnv, Map options) {
        execEnv.registerOperation(String.class, ASMString.createEvalSOTS(), "evalSOTS");
        execEnv.registerOperation(String.class, ASMString.createEvalSOTSBrackets(), "evalSOTSBrackets");
    }

    public static Operation createEvalSOTS() {
        return new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                String self = (String)localVars[0];
                Tuple args = (Tuple)localVars[1];
                Object ret = null;
                try {
                    ret = new SOTSExpression2(self).exec((StackFrame)frame, args);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                return ret;
            }
        };
    }

    public static Operation createEvalSOTSBrackets() {
        return new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                String self = (String)localVars[0];
                Tuple args = (Tuple)localVars[1];
                StringBuffer ret = new StringBuffer();
                StringReader in = new StringReader(self);
                try {
                    boolean done = false;
                    do {
                        int c = ((Reader)in).read();
                        switch (c) {
                            case -1: {
                                done = true;
                                break;
                            }
                            case 123: {
                                StringBuffer exp = new StringBuffer();
                                while ((c = ((Reader)in).read()) != 125) {
                                    exp.append((char)c);
                                }
                                Object result = new SOTSExpression2(exp.toString()).exec((StackFrame)frame, args);
                                if (result instanceof Collection) {
                                    result = ((Collection)result).iterator().next();
                                }
                                ret.append(result.toString());
                                break;
                            }
                            default: {
                                ret.append((char)c);
                            }
                        }
                    } while (!done);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                return ret.toString();
            }
        };
    }
}

