/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.Variable;

public abstract class AbstractContextualOperations {
    private final EClassifier fContextType;
    private final AbstractQVTStdlib fLib;

    protected AbstractContextualOperations(AbstractQVTStdlib lib, EClassifier contextType) {
        if (lib == null || contextType == null) {
            throw new IllegalArgumentException();
        }
        this.fContextType = contextType;
        this.fLib = lib;
    }

    protected abstract OperationProvider[] getOperations();

    public AbstractQVTStdlib getStdlib() {
        return this.fLib;
    }

    public void define(EcoreEnvironment env) {
        OperationProvider[] operationProviderArray = this.getOperations();
        int n = operationProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperationProvider operation = operationProviderArray[n2];
            EOperation defOper = operation.define(env);
            if (operation.fIsStatic) {
                QvtOperationalParserUtil.markAsStaticOperation(defOper);
            }
            ++n2;
        }
    }

    protected OperationProvider createStaticOperationProvider(CallHandler dispatcher, String name, EClassifier returnType, EClassifier ... paramTypes) {
        OperationProvider provider = new OperationProvider(dispatcher, name, returnType, paramTypes);
        provider.fIsStatic = true;
        return provider;
    }

    protected class OperationProvider {
        private String fName;
        private EClassifier fReturnType;
        private EClassifier[] fParamTypes;
        private CallHandler fDispatcher;
        private boolean fIsStatic;

        protected OperationProvider(CallHandler dispatcher, String name, EClassifier returnType, EClassifier ... paramTypes) {
            this.fName = name;
            this.fReturnType = returnType;
            this.fParamTypes = paramTypes;
            this.fDispatcher = dispatcher;
            this.fIsStatic = false;
        }

        public CallHandler callDispatcher() {
            return this.fDispatcher;
        }

        public OperationProvider implentBy(CallHandler dispatch) {
            return this;
        }

        public EOperation define(EcoreEnvironment env) {
            ArrayList<Variable> argList = new ArrayList<Variable>();
            EClassifier[] eClassifierArray = this.fParamTypes;
            int n = this.fParamTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier cls = eClassifierArray[n2];
                Variable stringVariable = ExpressionsFactory.eINSTANCE.createVariable();
                stringVariable.setName(cls.getName());
                stringVariable.setType((Object)cls);
                argList.add(stringVariable);
                ++n2;
            }
            EOperation result = env.defineOperation(AbstractContextualOperations.this.fContextType, this.fName, this.fReturnType, argList, EcoreFactory.eINSTANCE.createConstraint());
            CallHandlerAdapter.attach(result, this.fDispatcher);
            return result;
        }
    }
}

